/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.AccumulatorFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccumulatorTest {
    private TsBlock rawData;
    private Statistics statistics;

    @Before
    public void setUp() {
        this.initInputTsBlock();
    }

    private void initInputTsBlock() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.DOUBLE);
        dataTypes.add(TSDataType.INT32);
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(dataTypes);
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
        for (int i = 0; i < 100; ++i) {
            timeColumnBuilder.writeLong((long)i);
            columnBuilders[0].writeDouble((double)i * 1.0);
            columnBuilders[1].writeInt(-i);
            tsBlockBuilder.declarePosition();
        }
        this.rawData = tsBlockBuilder.build();
        this.statistics = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        this.statistics.update(100L, 100.0);
    }

    private Column[] getTimeAndValueColumn(int columnIndex) {
        Column[] columns = new Column[]{this.rawData.getTimeColumn(), this.rawData.getColumn(columnIndex)};
        return columns;
    }

    private Column[] getTimeAndTwoValueColumns(int columnIndex1, int columnIndex2) {
        Column[] columns = new Column[]{this.rawData.getTimeColumn(), this.rawData.getColumn(columnIndex1), this.rawData.getColumn(columnIndex2)};
        return columns;
    }

    @Test
    public void avgAccumulatorTest() {
        Accumulator avgAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.AVG, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)avgAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)avgAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)avgAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1), new DoubleColumnBuilder(null, 1)};
        avgAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        avgAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)avgAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        intermediateResult[1] = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)100L, (long)intermediateResult[0].build().getLong(0));
        Assert.assertEquals((double)4950.0, (double)intermediateResult[1].build().getDouble(0), (double)0.001);
        avgAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)49.5, (double)finalResult.build().getDouble(0), (double)0.001);
        avgAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)49.5, (double)finalResult.build().getDouble(0), (double)0.001);
        avgAccumulator.reset();
        avgAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        avgAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void countAccumulatorTest() {
        Accumulator countAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.COUNT, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        countAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)0L, (long)intermediateResult[0].build().getLong(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getLong(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        countAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)countAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        countAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)100L, (long)intermediateResult[0].build().getLong(0));
        countAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)200L, (long)finalResult.build().getLong(0));
        countAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getLong(0), (double)0.001);
        countAccumulator.reset();
        countAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        countAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)1L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void countTimeAccumulatorTest() {
        Accumulator countTimeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.COUNT_TIME, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countTimeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)countTimeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        countTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)0L, (long)intermediateResult[0].build().getLong(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        countTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getLong(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        timeAndValueColumn[1] = timeAndValueColumn[0];
        countTimeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)countTimeAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        countTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)100L, (long)intermediateResult[0].build().getLong(0));
        countTimeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        countTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)200L, (long)finalResult.build().getLong(0));
        countTimeAccumulator.reset();
        TimeStatistics timeStatistics = new TimeStatistics();
        timeStatistics.update(100L);
        countTimeAccumulator.addStatistics((Statistics)timeStatistics);
        finalResult = new LongColumnBuilder(null, 1);
        countTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)1L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void extremeAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.EXTREME, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        extremeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void firstValueAccumulatorTest() {
        Accumulator firstValueAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.FIRST_VALUE, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)firstValueAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)firstValueAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)firstValueAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1), new LongColumnBuilder(null, 1)};
        firstValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        firstValueAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertTrue((boolean)firstValueAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        intermediateResult[1] = new LongColumnBuilder(null, 1);
        firstValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)0.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        Assert.assertEquals((long)0L, (long)intermediateResult[1].build().getLong(0));
        firstValueAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)0.0, (double)finalResult.build().getDouble(0), (double)0.001);
        firstValueAccumulator.reset();
        firstValueAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        firstValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void lastValueAccumulatorTest() {
        Accumulator lastValueAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.LAST_VALUE, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)lastValueAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)lastValueAccumulator.getIntermediateType()[1]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)lastValueAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1), new LongColumnBuilder(null, 1)};
        lastValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        Assert.assertTrue((boolean)intermediateResult[1].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        lastValueAccumulator.addInput(timeAndValueColumn, null);
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        intermediateResult[1] = new LongColumnBuilder(null, 1);
        lastValueAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        Assert.assertEquals((long)99L, (long)intermediateResult[1].build().getLong(0));
        lastValueAccumulator.addIntermediate(new Column[]{intermediateResult[0].build(), intermediateResult[1].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        lastValueAccumulator.reset();
        lastValueAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        lastValueAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void maxTimeAccumulatorTest() {
        Accumulator maxTimeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MAX_TIME, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)maxTimeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)maxTimeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        maxTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        maxTimeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)maxTimeAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)99L, (long)intermediateResult[0].build().getLong(0));
        maxTimeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)99L, (long)finalResult.build().getLong(0));
        maxTimeAccumulator.reset();
        maxTimeAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        maxTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)100L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void minTimeAccumulatorTest() {
        Accumulator minTimeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MIN_TIME, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)minTimeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT64, (Object)minTimeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new LongColumnBuilder(null, 1)};
        minTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        LongColumnBuilder finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        minTimeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertTrue((boolean)minTimeAccumulator.hasFinalResult());
        intermediateResult[0] = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((long)0L, (long)intermediateResult[0].build().getLong(0));
        minTimeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getLong(0));
        minTimeAccumulator.reset();
        minTimeAccumulator.addStatistics(this.statistics);
        finalResult = new LongColumnBuilder(null, 1);
        minTimeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)100L, (long)finalResult.build().getLong(0));
    }

    @Test
    public void maxValueAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MAX_VALUE, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        extremeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)99.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)99.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void minValueAccumulatorTest() {
        Accumulator extremeAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MIN_VALUE, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)extremeAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        extremeAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)extremeAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)0.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        extremeAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)0.0, (double)finalResult.build().getDouble(0), (double)0.001);
        extremeAccumulator.reset();
        extremeAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        extremeAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void sumAccumulatorTest() {
        Accumulator sumAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.SUM, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)sumAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)sumAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new DoubleColumnBuilder(null, 1)};
        sumAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        sumAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)sumAccumulator.hasFinalResult());
        intermediateResult[0] = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputIntermediate(intermediateResult);
        Assert.assertEquals((double)4950.0, (double)intermediateResult[0].build().getDouble(0), (double)0.001);
        sumAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)9900.0, (double)finalResult.build().getDouble(0), (double)0.001);
        sumAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)4950.0, (double)finalResult.build().getDouble(0), (double)0.001);
        sumAccumulator.reset();
        sumAccumulator.addStatistics(this.statistics);
        finalResult = new DoubleColumnBuilder(null, 1);
        sumAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)100.0, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void stddevAccumulatorTest() {
        Accumulator stddevAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.STDDEV, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)stddevAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)stddevAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        stddevAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        stddevAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        intermediateResult[0].writeBinary(new Binary(new byte[0]));
        stddevAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        stddevAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)stddevAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        stddevAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        stddevAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)28.938, (double)finalResult.build().getDouble(0), (double)0.001);
        stddevAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)29.011491975882016, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void stddevPopAccumulatorTest() {
        Accumulator stddevPopAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.STDDEV_POP, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)stddevPopAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)stddevPopAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        stddevPopAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        stddevPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        stddevPopAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)stddevPopAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        stddevPopAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        stddevPopAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)28.866, (double)finalResult.build().getDouble(0), (double)0.001);
        stddevPopAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)28.86607004772212, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void stddevSampAccumulatorTest() {
        Accumulator stddevSampAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.STDDEV_SAMP, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)stddevSampAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)stddevSampAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        stddevSampAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        stddevSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        intermediateResult[0].writeBinary(new Binary(new byte[0]));
        stddevSampAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        stddevSampAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)stddevSampAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        stddevSampAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        stddevSampAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)28.938, (double)finalResult.build().getDouble(0), (double)0.001);
        stddevSampAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        stddevSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)29.011491975882016, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void varianceAccumulatorTest() {
        Accumulator varianceAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.VARIANCE, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)varianceAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)varianceAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        varianceAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        varianceAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        intermediateResult[0].writeBinary(new Binary(new byte[0]));
        varianceAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        finalResult = new DoubleColumnBuilder(null, 1);
        varianceAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        varianceAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)varianceAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        varianceAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        varianceAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varianceAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)837.437, (double)finalResult.build().getDouble(0), (double)0.001);
        varianceAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varianceAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)841.6666666666666, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void varPopAccumulatorTest() {
        Accumulator varPopAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.VAR_POP, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)varPopAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)varPopAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        varPopAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        varPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        varPopAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)varPopAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        varPopAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        varPopAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)833.25, (double)finalResult.build().getDouble(0), (double)0.001);
        varPopAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varPopAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)833.25, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void varSampAccumulatorTest() {
        Accumulator varSampAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.VAR_SAMP, Collections.singletonList(TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)varSampAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)varSampAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        varSampAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        DoubleColumnBuilder finalResult = new DoubleColumnBuilder(null, 1);
        varSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        intermediateResult[0].writeBinary(new Binary(new byte[0]));
        varSampAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        finalResult = new DoubleColumnBuilder(null, 1);
        varSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndValueColumn(0);
        varSampAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)varSampAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        varSampAccumulator.outputIntermediate(intermediateResult);
        byte[] result = intermediateResult[0].build().getBinary(0).getValues();
        Assert.assertEquals((long)100L, (long)BytesUtils.bytesToLong((byte[])result, (int)8));
        Assert.assertEquals((double)49.5, (double)BytesUtils.bytesToDouble((byte[])result, (int)8), (double)0.001);
        Assert.assertEquals((double)83325.0, (double)BytesUtils.bytesToDouble((byte[])result, (int)16), (double)0.001);
        varSampAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)837.437, (double)finalResult.build().getDouble(0), (double)0.001);
        varSampAccumulator.removeIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new DoubleColumnBuilder(null, 1);
        varSampAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((double)841.6666666666666, (double)finalResult.build().getDouble(0), (double)0.001);
    }

    @Test
    public void maxByAccumulatorTest() {
        Accumulator maxByAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MAX_BY, Arrays.asList(TSDataType.INT32, TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)maxByAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT32, (Object)maxByAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        maxByAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        IntColumnBuilder finalResult = new IntColumnBuilder(null, 1);
        maxByAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndTwoValueColumns(1, 0);
        maxByAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)maxByAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        maxByAccumulator.outputIntermediate(intermediateResult);
        maxByAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new IntColumnBuilder(null, 1);
        maxByAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)-99L, (long)finalResult.build().getInt(0));
    }

    @Test
    public void minByAccumulatorTest() {
        Accumulator minByAccumulator = AccumulatorFactory.createBuiltinAccumulator((TAggregationType)TAggregationType.MIN_BY, Arrays.asList(TSDataType.INT32, TSDataType.DOUBLE), Collections.emptyList(), Collections.emptyMap(), (boolean)true);
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)minByAccumulator.getIntermediateType()[0]);
        Assert.assertEquals((Object)TSDataType.INT32, (Object)minByAccumulator.getFinalType());
        ColumnBuilder[] intermediateResult = new ColumnBuilder[]{new BinaryColumnBuilder(null, 1)};
        minByAccumulator.outputIntermediate(intermediateResult);
        Assert.assertTrue((boolean)intermediateResult[0].build().isNull(0));
        IntColumnBuilder finalResult = new IntColumnBuilder(null, 1);
        minByAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertTrue((boolean)finalResult.build().isNull(0));
        Column[] timeAndValueColumn = this.getTimeAndTwoValueColumns(1, 0);
        minByAccumulator.addInput(timeAndValueColumn, null);
        Assert.assertFalse((boolean)minByAccumulator.hasFinalResult());
        intermediateResult[0] = new BinaryColumnBuilder(null, 1);
        minByAccumulator.outputIntermediate(intermediateResult);
        minByAccumulator.addIntermediate(new Column[]{intermediateResult[0].build()});
        finalResult = new IntColumnBuilder(null, 1);
        minByAccumulator.outputFinal((ColumnBuilder)finalResult);
        Assert.assertEquals((long)0L, (long)finalResult.build().getInt(0));
    }
}

