/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.QueryState;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class QueryStateMachineTest {
    @Test
    public void TestBasicTransition() {
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        Assert.assertEquals((Object)QueryState.QUEUED, (Object)stateMachine.getState());
        stateMachine.transitionToPlanned();
        Assert.assertEquals((Object)QueryState.PLANNED, (Object)stateMachine.getState());
        stateMachine.transitionToQueued();
        Assert.assertEquals((Object)QueryState.QUEUED, (Object)stateMachine.getState());
        stateMachine.transitionToPlanned();
        Assert.assertEquals((Object)QueryState.PLANNED, (Object)stateMachine.getState());
        stateMachine.transitionToDispatching();
        Assert.assertEquals((Object)QueryState.DISPATCHING, (Object)stateMachine.getState());
        stateMachine.transitionToRunning();
        Assert.assertEquals((Object)QueryState.RUNNING, (Object)stateMachine.getState());
        stateMachine.transitionToAborted();
        Assert.assertEquals((Object)QueryState.ABORTED, (Object)stateMachine.getState());
        stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToCanceled();
        Assert.assertEquals((Object)QueryState.CANCELED, (Object)stateMachine.getState());
        stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToFinished();
        Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToFailed();
        Assert.assertEquals((Object)QueryState.FAILED, (Object)stateMachine.getState());
        stateMachine = this.genQueryStateMachine();
        TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
        status.setMessage("Unknown");
        stateMachine.transitionToFailed(status);
        Assert.assertEquals((Object)QueryState.FAILED, (Object)stateMachine.getState());
        Assert.assertEquals((Object)"no detailed failure reason in QueryStateMachine", (Object)stateMachine.getFailureMessage());
        Throwable t = stateMachine.getFailureException();
        Assert.assertTrue((boolean)(t instanceof IoTDBException));
        Assert.assertEquals((long)TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode(), (long)((IoTDBException)t).getErrorCode());
        Assert.assertEquals((Object)"Unknown", (Object)t.getMessage());
    }

    @Test
    public void testFailure() {
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToDispatching();
        Assert.assertNotEquals((Object)QueryState.DISPATCHING, (Object)stateMachine.getState());
        Assert.assertEquals((Object)QueryState.QUEUED, (Object)stateMachine.getState());
        stateMachine.transitionToPlanned();
        Assert.assertEquals((Object)QueryState.PLANNED, (Object)stateMachine.getState());
        RuntimeException expected = new RuntimeException("a");
        stateMachine.transitionToCanceled((Throwable)expected, new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode()));
        Assert.assertEquals((Object)QueryState.CANCELED, (Object)stateMachine.getState());
        Assert.assertEquals((long)TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode(), (long)stateMachine.getFailureStatus().code);
        Assert.assertEquals((Object)expected, (Object)stateMachine.getFailureException());
        Assert.assertEquals((Object)"a", (Object)stateMachine.getFailureMessage());
        try {
            stateMachine.transitionToQueued();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"test_query cannot transition from CANCELED to QUEUED", (Object)e.getMessage());
            Assert.assertNotEquals((Object)QueryState.QUEUED, (Object)stateMachine.getState());
        }
    }

    @Test
    public void TestListener() throws ExecutionException, InterruptedException {
        AtomicInteger stateChangeCounter = new AtomicInteger(0);
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        stateMachine.addStateChangeListener(state -> stateChangeCounter.getAndIncrement());
        stateMachine.transitionToFinished();
        SettableFuture future = SettableFuture.create();
        stateMachine.addStateChangeListener(state -> {
            if (state == QueryState.FINISHED) {
                future.set((Object)QueryState.FINISHED);
            }
        });
        future.get();
        Assert.assertEquals((long)2L, (long)stateChangeCounter.get());
    }

    @Test
    public void TestGetStateChange() throws ExecutionException, InterruptedException {
        AtomicInteger stateChangeCounter = new AtomicInteger(0);
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        SettableFuture callbackFuture = SettableFuture.create();
        ListenableFuture future = stateMachine.getStateChange(QueryState.QUEUED);
        future.addListener(() -> {
            stateChangeCounter.getAndIncrement();
            callbackFuture.set(null);
        }, MoreExecutors.directExecutor());
        Assert.assertEquals((long)0L, (long)stateChangeCounter.get());
        stateMachine.transitionToRunning();
        future.get();
        callbackFuture.get();
        Assert.assertEquals((long)1L, (long)stateChangeCounter.get());
    }

    @Test
    public void testTransitionToPendingRetry() {
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToPlanned();
        stateMachine.transitionToPendingRetry(new TSStatus(TSStatusCode.CAN_NOT_CONNECT_DATANODE.getStatusCode()));
        Assert.assertEquals((long)TSStatusCode.CAN_NOT_CONNECT_DATANODE.getStatusCode(), (long)stateMachine.getFailureStatus().code);
    }

    private QueryStateMachine genQueryStateMachine() {
        return new QueryStateMachine(this.genQueryId(), IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"TestQueryStateMachine"));
    }

    private QueryId genQueryId() {
        return new QueryId("test_query");
    }
}

