/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriver;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.exchange.StubSink;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.LimitOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.FullOuterTimeJoinOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DataDriverTest {
    private static final String DATA_DRIVER_TEST_SG = "root.DataDriverTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private static final Duration EXECUTION_TIME_SLICE = new Duration((double)IoTDBDescriptor.getInstance().getConfig().getDriverTaskExecutionTimeSliceInMs(), TimeUnit.MILLISECONDS);

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, DATA_DRIVER_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath1 = new MeasurementPath("root.DataDriverTest.device0.sensor0", TSDataType.INT32);
            HashSet<String> allSensors = new HashSet<String>();
            allSensors.add("sensor0");
            allSensors.add("sensor1");
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            DataRegion dataRegion = (DataRegion)Mockito.mock(DataRegion.class);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            fragmentInstanceContext.setDataRegion((IDataRegionForQuery)dataRegion);
            DataDriverContext driverContext = new DataDriverContext(fragmentInstanceContext, 0);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            driverContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            driverContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            driverContext.addOperatorContext(3, new PlanNodeId("3"), FullOuterTimeJoinOperator.class.getSimpleName());
            driverContext.addOperatorContext(4, new PlanNodeId("4"), LimitOperator.class.getSimpleName());
            SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
            scanOptionsBuilder.withAllSensors(allSensors);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(0), planNodeId1, (PartialPath)measurementPath1, Ordering.ASC, scanOptionsBuilder.build());
            driverContext.addSourceOperator((DataSourceOperator)seriesScanOperator1);
            driverContext.addPath((PartialPath)measurementPath1);
            seriesScanOperator1.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            MeasurementPath measurementPath2 = new MeasurementPath("root.DataDriverTest.device0.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator((OperatorContext)driverContext.getOperatorContexts().get(1), planNodeId2, (PartialPath)measurementPath2, Ordering.ASC, scanOptionsBuilder.build());
            driverContext.addSourceOperator((DataSourceOperator)seriesScanOperator2);
            driverContext.addPath((PartialPath)measurementPath2);
            seriesScanOperator2.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            FullOuterTimeJoinOperator timeJoinOperator = new FullOuterTimeJoinOperator((OperatorContext)driverContext.getOperatorContexts().get(2), Arrays.asList(seriesScanOperator1, seriesScanOperator2), Ordering.ASC, Arrays.asList(TSDataType.INT32, TSDataType.INT32), Arrays.asList(new SingleColumnMerger(new InputLocation(0, 0), (TimeComparator)new AscTimeComparator()), new SingleColumnMerger(new InputLocation(1, 0), (TimeComparator)new AscTimeComparator())), (TimeComparator)new AscTimeComparator());
            timeJoinOperator.getOperatorContext();
            OperatorContext.setMaxRunTime((Duration)new Duration(500.0, TimeUnit.MILLISECONDS));
            LimitOperator limitOperator = new LimitOperator((OperatorContext)driverContext.getOperatorContexts().get(3), 250L, (Operator)timeJoinOperator);
            String deviceId = "root.DataDriverTest.device0";
            Mockito.when((Object)dataRegion.query(driverContext.getPaths(), deviceId, (QueryContext)fragmentInstanceContext, null, null)).thenReturn((Object)new QueryDataSource(this.seqResources, this.unSeqResources));
            fragmentInstanceContext.initQueryDataSource(driverContext.getPaths());
            fragmentInstanceContext.initializeNumOfDrivers(1);
            StubSink stubSink = new StubSink(fragmentInstanceContext);
            driverContext.setSink((ISink)stubSink);
            try (DataDriver dataDriver = null;){
                dataDriver = new DataDriver((Operator)limitOperator, (DriverContext)driverContext, 0L);
                Assert.assertEquals((Object)fragmentInstanceContext.getId(), (Object)dataDriver.getDriverTaskId().getFragmentInstanceId());
                Assert.assertFalse((boolean)dataDriver.isFinished());
                while (!dataDriver.isFinished()) {
                    Assert.assertEquals((Object)FragmentInstanceState.RUNNING, (Object)stateMachine.getState());
                    ListenableFuture blocked = dataDriver.processFor(EXECUTION_TIME_SLICE);
                    Assert.assertTrue((boolean)blocked.isDone());
                }
                Assert.assertEquals((Object)FragmentInstanceState.FLUSHING, (Object)stateMachine.getState());
                List<TsBlock> result = stubSink.getTsBlocks();
                int row = 0;
                for (TsBlock tsBlock : result) {
                    Assert.assertEquals((long)2L, (long)tsBlock.getValueColumnCount());
                    Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof IntColumn));
                    Assert.assertTrue((boolean)(tsBlock.getColumn(1) instanceof IntColumn));
                    int j = 0;
                    while (j < tsBlock.getPositionCount()) {
                        Assert.assertEquals((long)row, (long)tsBlock.getTimeByIndex(j));
                        if ((long)row < 200L) {
                            Assert.assertEquals((long)(20000L + (long)row), (long)tsBlock.getColumn(0).getInt(j));
                            Assert.assertEquals((long)(20000L + (long)row), (long)tsBlock.getColumn(1).getInt(j));
                        } else if ((long)row < 260L || (long)row >= 300L && (long)row < 380L || (long)row >= 400L) {
                            Assert.assertEquals((long)(10000L + (long)row), (long)tsBlock.getColumn(0).getInt(j));
                            Assert.assertEquals((long)(10000L + (long)row), (long)tsBlock.getColumn(1).getInt(j));
                        } else {
                            Assert.assertEquals((long)row, (long)tsBlock.getColumn(0).getInt(j));
                            Assert.assertEquals((long)row, (long)tsBlock.getColumn(1).getInt(j));
                        }
                        ++j;
                        ++row;
                    }
                }
                Assert.assertEquals((long)250L, (long)row);
            }
        }
        catch (IllegalPathException | QueryProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

