/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.junit.Assert;
import org.junit.Test;

public class ConfigExecutionTest {
    @Test
    public void normalConfigTaskTest() {
        IConfigTask task = clientManager -> Futures.immediateFuture((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        ConfigExecution execution = new ConfigExecution(this.genMPPQueryContext(), this.getExecutor(), task);
        execution.start();
        ExecutionResult result = execution.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)result.status.code);
    }

    @Test
    public void normalConfigTaskWithResultTest() {
        TsBlock tsBlock = new TsBlock(new TimeColumn(1, new long[]{0L}), new Column[]{new IntColumn(1, Optional.empty(), new int[]{1})});
        DatasetHeader datasetHeader = new DatasetHeader(Collections.singletonList(new ColumnHeader("TestValue", TSDataType.INT32)), false);
        IConfigTask task = clientManager -> Futures.immediateFuture((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, tsBlock, datasetHeader));
        ConfigExecution execution = new ConfigExecution(this.genMPPQueryContext(), this.getExecutor(), task);
        execution.start();
        ExecutionResult result = execution.getStatus();
        TsBlock tsBlockFromExecution = null;
        if (execution.hasNextResult()) {
            Optional optionalTsBlock = execution.getBatchResult();
            Assert.assertTrue((boolean)optionalTsBlock.isPresent());
            tsBlockFromExecution = (TsBlock)optionalTsBlock.get();
        }
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)result.status.code);
        Assert.assertEquals((Object)tsBlock, (Object)tsBlockFromExecution);
    }

    @Test
    public void exceptionConfigTaskTest() {
        IConfigTask task = clientManager -> {
            throw new RuntimeException("task throw exception when executing");
        };
        ConfigExecution execution = new ConfigExecution(this.genMPPQueryContext(), this.getExecutor(), task);
        execution.start();
        ExecutionResult result = execution.getStatus();
        Assert.assertEquals((long)TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (long)result.status.code);
    }

    @Test
    public void configTaskCancelledTest() throws InterruptedException {
        SettableFuture taskResult = SettableFuture.create();
        class SimpleTask
        implements IConfigTask {
            private final ListenableFuture<ConfigTaskResult> result;

            public SimpleTask(ListenableFuture<ConfigTaskResult> future) {
                this.result = future;
            }

            public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskFetcher) throws InterruptedException {
                return this.result;
            }
        }
        SimpleTask task = new SimpleTask((ListenableFuture<ConfigTaskResult>)taskResult);
        ConfigExecution execution = new ConfigExecution(this.genMPPQueryContext(), this.getExecutor(), (IConfigTask)task);
        execution.start();
        Thread resultThread = new Thread(() -> {
            ExecutionResult result = execution.getStatus();
            Assert.assertEquals((long)TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (long)result.status.code);
        });
        resultThread.start();
        taskResult.cancel(true);
        resultThread.join();
    }

    @Test
    public void exceptionAfterInvokeGetStatusTest() {
        IConfigTask task = clientManager -> {
            throw new RuntimeException("task throw exception when executing");
        };
        ConfigExecution execution = new ConfigExecution(this.genMPPQueryContext(), this.getExecutor(), task);
        Thread resultThread = new Thread(() -> {
            ExecutionResult result = execution.getStatus();
            Assert.assertEquals((long)TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (long)result.status.code);
        });
        resultThread.start();
        execution.start();
        try {
            resultThread.join();
        }
        catch (InterruptedException e) {
            ExecutionResult result = execution.getStatus();
            Assert.assertEquals((long)TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (long)result.status.code);
            execution.stop((Throwable)e);
        }
    }

    private MPPQueryContext genMPPQueryContext() {
        MPPQueryContext context = new MPPQueryContext(new QueryId("query1"));
        context.setQueryType(QueryType.WRITE);
        return context;
    }

    private ExecutorService getExecutor() {
        return IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"ConfigExecutionTest");
    }
}

