/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeMeasurementVisitor;
import org.junit.Assert;

public class MockSchemaTreeMeasurementVisitor
extends SchemaTreeMeasurementVisitor {
    Map<SchemaNode, Integer> map = new HashMap<SchemaNode, Integer>();

    protected MeasurementPath generateResult(SchemaNode nextMatchedNode) {
        Assert.assertTrue((this.map.get(nextMatchedNode) > 0 ? 1 : 0) != 0);
        return super.generateResult(nextMatchedNode);
    }

    public MockSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        super(root, pathPattern, isPrefixMatch);
    }

    public MockSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, PathPatternTree scope) {
        super(root, pathPattern, isPrefixMatch, scope);
    }

    protected Iterator<SchemaNode> getChildrenIterator(SchemaNode parent) {
        return new CountIterator(super.getChildrenIterator(parent));
    }

    protected SchemaNode getChild(SchemaNode parent, String childName) {
        SchemaNode node = super.getChild(parent, childName);
        if (node != null) {
            if (this.map.containsKey(node)) {
                this.map.put(node, this.map.get(node) + 1);
            } else {
                this.map.put(node, 1);
            }
        }
        return node;
    }

    protected void releaseNode(SchemaNode child) {
        this.map.computeIfPresent(child, (node, cnt) -> cnt - 1);
    }

    protected void releaseNodeIterator(Iterator<SchemaNode> nodeIterator) {
        super.releaseNodeIterator(nodeIterator);
    }

    public void close() {
        super.close();
        for (int cnt : this.map.values()) {
            Assert.assertEquals((long)0L, (long)cnt);
        }
    }

    private class CountIterator
    implements Iterator<SchemaNode> {
        Iterator<SchemaNode> iterator;

        private CountIterator(Iterator<SchemaNode> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SchemaNode next() {
            SchemaNode node = this.iterator.next();
            if (MockSchemaTreeMeasurementVisitor.this.map.containsKey(node)) {
                MockSchemaTreeMeasurementVisitor.this.map.put(node, MockSchemaTreeMeasurementVisitor.this.map.get(node) + 1);
            } else {
                MockSchemaTreeMeasurementVisitor.this.map.put(node, 1);
            }
            return node;
        }
    }
}

