/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorFactory;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorWithLimitOffsetWrapper;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.internal.util.collections.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaTreeTest {
    private static final Logger logger = LoggerFactory.getLogger(ClusterSchemaTreeTest.class);

    @Test
    @Ignore
    public void testPerformanceOnSimpleTree() throws IllegalPathException {
        long startTime = System.currentTimeMillis();
        int round = 20;
        for (int i = 0; i < round; ++i) {
            for (int j = 0; j < 10000; ++j) {
                this.testMultiWildcard();
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("AllTime={}", (Object)((endTime - startTime) / (long)round));
    }

    @Test
    @Ignore
    public void testPerformanceOnComplexTree() throws IllegalPathException {
        int deep = 5;
        int width = 5;
        SchemaNode root = this.generateComplexSchemaTree(deep, width);
        PartialPath path = new PartialPath("root.**.d0.s");
        long startTime = System.currentTimeMillis();
        long calTime = 0L;
        int round = 20;
        for (int i = 0; i < round; ++i) {
            for (int j = 0; j < 1000; ++j) {
                SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, path, 0, 0, false);
                long calStartTime = System.currentTimeMillis();
                List res = visitor.getAllResult();
                Assert.assertEquals((long)((int)(1.0 - Math.pow(width, deep)) / (1 - width) - 1), (long)res.size());
                calTime += System.currentTimeMillis() - calStartTime;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("CalculateTime={}", (Object)(calTime / (long)round));
        logger.info("InitialTime={}", (Object)((endTime - startTime - calTime) / (long)round));
        logger.info("AllTime={}", (Object)((endTime - startTime) / (long)round));
    }

    @Test
    public void testSchemaTreeVisitor() throws Exception {
        SchemaNode root = this.generateSchemaTree();
        this.testSchemaTree(root);
    }

    @Test
    public void testMultiWildcard() throws IllegalPathException {
        SchemaNode root = this.generateSchemaTreeWithInternalRepeatedName();
        SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 4, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s", "root.a.a.s"}, null, new boolean[]{false, false, false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.*.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 4, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s", "root.a.a.s"}, null, new boolean[]{false, false, false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.a.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 3, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.a.**.*.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.a.**.a.*.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.c.c.c.d.c.c.s1", "root.c.c.c.d.c.s1"}, null, new boolean[]{false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.c.d.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.s1"}, null, new boolean[]{false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.d.**.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.c.s1"}, null, new boolean[]{false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.d.*.*"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.s1"}, null, new boolean[]{false});
    }

    private void testSchemaTree(SchemaNode root) throws Exception {
        SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.a.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.sg.d2.a.s1"}, null, new boolean[]{true});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.s2"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"", ""}, null);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.status"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, null);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.*.*"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d1"), 0, 0, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.a"), 0, 0, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true}, new int[]{0, 0});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.*"), 2, 2, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", ""}, new boolean[]{false, false}, new int[]{3, 4});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*"), 2, 3, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s1"}, new String[]{"", ""}, new boolean[]{true, false}, new int[]{4, 5});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d1.**"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.**"), 3, 1, true);
        this.checkVisitorResult(visitor, 3, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", ""}, new boolean[]{true, false, false}, new int[]{2, 3, 4});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.**.status"), 2, 1, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, new boolean[]{true, false}, new int[]{2, 3});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.*"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.*.**"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.*.**.**"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
    }

    private SchemaNode generateSchemaTree() {
        SchemaInternalNode root = new SchemaInternalNode("root");
        SchemaInternalNode sg = new SchemaInternalNode("sg");
        root.addChild("sg", (SchemaNode)sg);
        SchemaEntityNode d1 = new SchemaEntityNode("d1");
        sg.addChild("d1", (SchemaNode)d1);
        MeasurementSchema schema1 = new MeasurementSchema("s1", TSDataType.INT32);
        MeasurementSchema schema2 = new MeasurementSchema("s2", TSDataType.INT64);
        SchemaMeasurementNode s1 = new SchemaMeasurementNode("s1", (IMeasurementSchema)schema1);
        d1.addChild("s1", (SchemaNode)s1);
        SchemaMeasurementNode s2 = new SchemaMeasurementNode("s2", (IMeasurementSchema)schema2);
        s2.setAlias("status");
        d1.addChild("s2", (SchemaNode)s2);
        d1.addAliasChild("status", s2);
        SchemaEntityNode d2 = new SchemaEntityNode("d2");
        sg.addChild("d2", (SchemaNode)d2);
        d2.addChild("s1", (SchemaNode)s1);
        d2.addChild("s2", (SchemaNode)s2);
        d2.addAliasChild("status", s2);
        SchemaEntityNode a = new SchemaEntityNode("a");
        a.setAligned(true);
        d2.addChild("a", (SchemaNode)a);
        a.addChild("s1", (SchemaNode)s1);
        a.addChild("s2", (SchemaNode)s2);
        a.addAliasChild("status", s2);
        return root;
    }

    private SchemaNode generateSchemaTreeWithInternalRepeatedName() {
        SchemaInternalNode root;
        SchemaInternalNode parent = root = new SchemaInternalNode("root");
        MeasurementSchema schema = new MeasurementSchema("s", TSDataType.INT32);
        for (int i = 0; i < 5; ++i) {
            SchemaEntityNode a = new SchemaEntityNode("a");
            SchemaMeasurementNode s = new SchemaMeasurementNode("s", (IMeasurementSchema)schema);
            a.addChild("s", (SchemaNode)s);
            parent.addChild("a", (SchemaNode)a);
            parent = a;
        }
        parent = root;
        for (int i = 0; i < 3; ++i) {
            SchemaInternalNode c = new SchemaInternalNode("c");
            parent.addChild("c", (SchemaNode)c);
            parent = c;
        }
        SchemaInternalNode d = new SchemaInternalNode("d");
        parent.addChild("d", (SchemaNode)d);
        parent = d;
        for (int i = 0; i < 2; ++i) {
            SchemaEntityNode c = new SchemaEntityNode("c");
            c.addChild("s1", (SchemaNode)new SchemaMeasurementNode("s1", (IMeasurementSchema)schema));
            parent.addChild("c", (SchemaNode)c);
            parent = c;
        }
        return root;
    }

    private SchemaNode generateComplexSchemaTree(int deep, int width) {
        int i;
        SchemaInternalNode root = new SchemaInternalNode("root");
        ArrayList<SchemaEntityNode> nodes = new ArrayList<SchemaEntityNode>();
        MeasurementSchema schema = new MeasurementSchema("s", TSDataType.INT32);
        for (i = 0; i < width; ++i) {
            SchemaEntityNode schemaEntityNode = new SchemaEntityNode("d" + i);
            nodes.add(schemaEntityNode);
            root.addChild("d" + i, (SchemaNode)schemaEntityNode);
        }
        for (i = 0; i < deep - 1; ++i) {
            ArrayList<SchemaEntityNode> arrayList = new ArrayList<SchemaEntityNode>();
            for (SchemaNode schemaNode : nodes) {
                SchemaMeasurementNode measurementNode = new SchemaMeasurementNode("s", (IMeasurementSchema)schema);
                schemaNode.addChild("s", (SchemaNode)measurementNode);
                for (int j = 0; j < width; ++j) {
                    SchemaEntityNode entityNode = new SchemaEntityNode("d" + j);
                    schemaNode.addChild("d" + j, (SchemaNode)entityNode);
                    arrayList.add(entityNode);
                }
            }
            nodes = arrayList;
        }
        for (SchemaNode schemaNode : nodes) {
            SchemaMeasurementNode measurementNode = new SchemaMeasurementNode("s", (IMeasurementSchema)schema);
            schemaNode.addChild("s", (SchemaNode)measurementNode);
        }
        return root;
    }

    @Test
    public void testSchemaTreeWithScope() throws Exception {
        SchemaNode root = this.generateSchemaTree();
        PathPatternTree scope = new PathPatternTree();
        scope.appendPathPattern(new PartialPath("root.sg.d1.**"));
        scope.appendPathPattern(new PartialPath("root.sg.d2.status"));
        scope.appendPathPattern(new PartialPath("root.sg.d2.a.**"));
        scope.constructTree();
        SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.a.s1"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 1, new String[]{"root.sg.d2.a.s1"}, null, new boolean[]{true});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.s1"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 0, new String[0], null, new boolean[0]);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.s2"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"", ""}, null);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.s1"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 1, new String[]{"root.sg.d1.s1"}, new String[]{""}, null);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.status"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, null);
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.*.*"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d1"), 0, 0, true, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.a"), 0, 0, true, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true}, new int[]{0, 0});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*.*"), 2, 2, false, scope);
        this.checkVisitorResult(visitor, 1, new String[]{"root.sg.d2.s2"}, new String[]{""}, new boolean[]{false}, new int[]{3});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.*"), 2, 3, true, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"", ""}, new boolean[]{true, false}, new int[]{4, 5});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d1.**"), 0, 0, false, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.d2.**"), 3, 1, true, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"", ""}, new boolean[]{true, false}, new int[]{2, 3});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.sg.**.status"), 2, 1, true, scope);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, new boolean[]{true, false}, new int[]{2, 3});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.*"), 10, 0, false, scope);
        this.checkVisitorResult(visitor, 5, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"", "", "", "", ""}, new boolean[]{false, false, true, true, false}, new int[]{1, 2, 3, 4, 5});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.**.*.**"), 10, 0, false, scope);
        this.checkVisitorResult(visitor, 5, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"", "", "", "", ""}, new boolean[]{false, false, true, true, false}, new int[]{1, 2, 3, 4, 5});
        visitor = this.createSchemaTreeVisitorWithLimitOffsetWrapper(root, new PartialPath("root.*.**.**"), 10, 0, false, scope);
        this.checkVisitorResult(visitor, 5, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"", "", "", "", ""}, new boolean[]{false, false, true, true, false}, new int[]{1, 2, 3, 4, 5});
    }

    private void checkVisitorResult(SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor, int expectedNum, String[] expectedPath, String[] expectedAlias, boolean[] expectedAligned) {
        int i;
        List result = visitor.getAllResult();
        Assert.assertEquals((long)expectedNum, (long)result.size());
        for (i = 0; i < expectedNum; ++i) {
            Assert.assertEquals((Object)expectedPath[i], (Object)((MeasurementPath)result.get(i)).getFullPath());
        }
        if (expectedAlias != null) {
            for (i = 0; i < expectedNum; ++i) {
                Assert.assertEquals((Object)expectedAlias[i], (Object)((MeasurementPath)result.get(i)).getMeasurementAlias());
            }
        }
        if (expectedAligned != null) {
            for (i = 0; i < expectedNum; ++i) {
                Assert.assertEquals((Object)expectedAligned[i], (Object)((MeasurementPath)result.get(i)).isUnderAlignedEntity());
            }
        }
        visitor.close();
    }

    private void checkVisitorResult(SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor, int expectedNum, String[] expectedPath, String[] expectedAlias, boolean[] expectedAligned, int[] expectedOffset) {
        this.checkVisitorResult(visitor, expectedNum, expectedPath, expectedAlias, expectedAligned);
        visitor.reset();
        int i = 0;
        while (visitor.hasNext()) {
            MeasurementPath result = (MeasurementPath)visitor.next();
            Assert.assertEquals((Object)expectedPath[i], (Object)result.getFullPath());
            Assert.assertEquals((Object)expectedAlias[i], (Object)result.getMeasurementAlias());
            Assert.assertEquals((Object)expectedAligned[i], (Object)result.isUnderAlignedEntity());
            Assert.assertEquals((long)expectedOffset[i], (long)visitor.getNextOffset());
            ++i;
        }
        Assert.assertEquals((long)expectedNum, (long)i);
        visitor.close();
    }

    @Test
    public void testSearchDeviceInfo() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree(this.generateSchemaTree());
        this.testSearchDeviceInfo((ISchemaTree)schemaTree);
    }

    private void testSearchDeviceInfo(ISchemaTree schemaTree) throws Exception {
        PartialPath devicePath = new PartialPath("root.sg.d1");
        ArrayList<String> measurements = new ArrayList<String>();
        measurements.add("s1");
        measurements.add("s2");
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
        Assert.assertEquals(measurements, deviceSchemaInfo.getMeasurementSchemaList().stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
        devicePath = new PartialPath("root.sg.d2.a");
        measurements.remove(1);
        measurements.add("status");
        deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        measurements.remove(1);
        measurements.add("s2");
        Assert.assertEquals(measurements, deviceSchemaInfo.getMeasurementSchemaList().stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
    }

    @Test
    public void testGetMatchedDevices() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree(this.generateSchemaTree());
        List deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.d2.a"));
        Assert.assertEquals((long)1L, (long)deviceSchemaInfoList.size());
        DeviceSchemaInfo deviceSchemaInfo = (DeviceSchemaInfo)deviceSchemaInfoList.get(0);
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)deviceSchemaInfo.getDevicePath());
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        Assert.assertEquals((long)2L, (long)deviceSchemaInfo.getMeasurements(Sets.newSet((Object[])new String[]{"*"})).size());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.*"));
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)2L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.**"));
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)3L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(2)).getDevicePath());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.**"));
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)3L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(2)).getDevicePath());
    }

    @Test
    public void testSerialization() throws Exception {
        SchemaNode root = this.generateSchemaTree();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        root.serialize((OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ClusterSchemaTree schemaTree = ClusterSchemaTree.deserialize((InputStream)inputStream);
        Pair visitResult = schemaTree.searchMeasurementPaths(new PartialPath("root.sg.**.status"), 2, 1, true);
        Assert.assertEquals((long)2L, (long)((List)visitResult.left).size());
        Assert.assertEquals((long)3L, (long)((Integer)visitResult.right).intValue());
        this.testSearchDeviceInfo((ISchemaTree)schemaTree);
    }

    @Test
    public void testAppendMeasurementPath() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        List<MeasurementPath> measurementPathList = this.generateMeasurementPathList();
        schemaTree.appendMeasurementPaths(measurementPathList);
        this.testSchemaTree(schemaTree.getRoot());
    }

    private List<MeasurementPath> generateMeasurementPathList() throws Exception {
        ArrayList<MeasurementPath> measurementPathList = new ArrayList<MeasurementPath>();
        MeasurementSchema schema1 = new MeasurementSchema("s1", TSDataType.INT32);
        MeasurementSchema schema2 = new MeasurementSchema("s2", TSDataType.INT64);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d1.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.a.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPath.setUnderAlignedEntity(Boolean.valueOf(true));
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.a.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPath.setUnderAlignedEntity(Boolean.valueOf(true));
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPathList.add(measurementPath);
        return measurementPathList;
    }

    @Test
    public void testMergeSchemaTree() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (ClusterSchemaTree tree : this.generateSchemaTrees()) {
            schemaTree.mergeSchemaTree(tree);
        }
        this.testSchemaTree(schemaTree.getRoot());
    }

    @Test
    public void testMergeSchemaTreeWithTemplate() throws Exception {
        Template template1 = new Template("t1", Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY, CompressionType.SNAPPY));
        template1.setId(1);
        ClusterSchemaTree schemaTree1 = new ClusterSchemaTree();
        ClusterSchemaTree schemaTree2 = new ClusterSchemaTree();
        schemaTree1.appendTemplateDevice(new PartialPath("root.sg1.v1.d1"), false, 1, template1);
        schemaTree1.appendTemplateDevice(new PartialPath("root.sg1.v1.d2"), false, 1, template1);
        schemaTree2.appendTemplateDevice(new PartialPath("root.sg1.v1"), false, 1, template1);
        schemaTree1.mergeSchemaTree(schemaTree2);
        List deviceSchemaInfoList = schemaTree1.getAllDevices();
        Assert.assertEquals((long)3L, (long)deviceSchemaInfoList.size());
        for (DeviceSchemaInfo deviceSchemaInfo : deviceSchemaInfoList) {
            Assert.assertEquals((long)1L, (long)deviceSchemaInfo.getTemplateId());
            int measurementIndex = 1;
            for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                Assert.assertEquals((Object)("s" + measurementIndex++), (Object)measurementPath.getMeasurement());
            }
        }
        Assert.assertFalse((boolean)schemaTree1.hasNormalTimeSeries());
        Assert.assertEquals((long)1L, (long)schemaTree1.getUsingTemplates().size());
        this.checkDeviceUsingTemplate((ISchemaTree)schemaTree1, 1, Sets.newSet((Object[])new String[]{"root.sg1.v1.d1", "root.sg1.v1.d2", "root.sg1.v1"}));
        Template template2 = new Template("t2", Arrays.asList("s11", "s22", "s33"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY, CompressionType.SNAPPY));
        template2.setId(2);
        ClusterSchemaTree schemaTree3 = new ClusterSchemaTree();
        schemaTree3.appendTemplateDevice(new PartialPath("root.sg2.d1"), false, 2, template2);
        schemaTree1.mergeSchemaTree(schemaTree3);
        Assert.assertFalse((boolean)schemaTree1.hasNormalTimeSeries());
        Assert.assertEquals((long)2L, (long)schemaTree1.getUsingTemplates().size());
        this.checkDeviceUsingTemplate((ISchemaTree)schemaTree1, 1, Sets.newSet((Object[])new String[]{"root.sg1.v1.d1", "root.sg1.v1.d2", "root.sg1.v1"}));
        this.checkDeviceUsingTemplate((ISchemaTree)schemaTree1, 2, Sets.newSet((Object[])new String[]{"root.sg2.d1"}));
        for (DeviceSchemaInfo deviceSchemaInfo : deviceSchemaInfoList) {
            int measurementIndex;
            if (deviceSchemaInfo.getDevicePath().startsWith("root.sg1")) {
                Assert.assertEquals((long)1L, (long)deviceSchemaInfo.getTemplateId());
                measurementIndex = 1;
                for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                    Assert.assertEquals((Object)("s" + measurementIndex), (Object)measurementPath.getMeasurement());
                }
                continue;
            }
            Assert.assertEquals((long)2L, (long)deviceSchemaInfo.getTemplateId());
            measurementIndex = 1;
            for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                Assert.assertEquals((Object)String.format("s%d%d", measurementIndex, measurementIndex), (Object)measurementPath.getMeasurement());
                ++measurementIndex;
            }
        }
        ClusterSchemaTree schemaTree4 = new ClusterSchemaTree();
        schemaTree4.appendSingleMeasurementPath(new MeasurementPath("root.sg3.d1.s1", TSDataType.INT32));
        schemaTree1.mergeSchemaTree(schemaTree4);
        Assert.assertTrue((boolean)schemaTree1.hasNormalTimeSeries());
        Assert.assertEquals((long)2L, (long)schemaTree1.getUsingTemplates().size());
        for (DeviceSchemaInfo deviceSchemaInfo : deviceSchemaInfoList) {
            int measurementIndex;
            if (deviceSchemaInfo.getDevicePath().startsWith("root.sg1")) {
                Assert.assertEquals((long)1L, (long)deviceSchemaInfo.getTemplateId());
                measurementIndex = 1;
                for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                    Assert.assertEquals((Object)("s" + measurementIndex), (Object)measurementPath.getMeasurement());
                }
                continue;
            }
            if (deviceSchemaInfo.getDevicePath().startsWith("root.sg2")) {
                Assert.assertEquals((long)2L, (long)deviceSchemaInfo.getTemplateId());
                measurementIndex = 1;
                for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                    Assert.assertEquals((Object)String.format("s%d%d", measurementIndex, measurementIndex), (Object)measurementPath.getMeasurement());
                    ++measurementIndex;
                }
                continue;
            }
            Assert.assertEquals((long)-1L, (long)deviceSchemaInfo.getTemplateId());
            Assert.assertEquals((long)1L, (long)deviceSchemaInfo.getMeasurementSchemaPathList().size());
            Assert.assertEquals((Object)"s1", (Object)((MeasurementPath)deviceSchemaInfo.getMeasurementSchemaPathList().get(0)).getMeasurement());
        }
    }

    private void checkDeviceUsingTemplate(ISchemaTree schemaTree, int templateId, Set<String> expected) {
        List deviceUsingTemplate = schemaTree.getDeviceUsingTemplate(templateId);
        Assert.assertEquals((long)expected.size(), (long)deviceUsingTemplate.size());
        for (PartialPath d : deviceUsingTemplate) {
            Assert.assertTrue((boolean)expected.contains(d.getFullPath()));
            expected.remove(d.getFullPath());
        }
        Assert.assertTrue((boolean)expected.isEmpty());
    }

    @Test
    public void testMergeSchemaTreeAndSearchDeviceSchemaInfo() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (ClusterSchemaTree tree : this.generateSchemaTrees()) {
            schemaTree.mergeSchemaTree(tree);
        }
        PartialPath devicePath = new PartialPath("root.sg.d99999");
        ArrayList<String> measurements = new ArrayList<String>();
        measurements.add("s1");
        measurements.add("s2");
        schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
    }

    private List<ClusterSchemaTree> generateSchemaTrees() throws Exception {
        ArrayList<ClusterSchemaTree> schemaTreeList = new ArrayList<ClusterSchemaTree>();
        List<MeasurementPath> measurementPathList = this.generateMeasurementPathList();
        for (int i = 0; i < 6; i += 2) {
            ArrayList<MeasurementPath> list = new ArrayList<MeasurementPath>();
            list.add(measurementPathList.get(i));
            list.add(measurementPathList.get(i + 1));
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            schemaTree.appendMeasurementPaths(list);
            schemaTreeList.add(schemaTree);
        }
        return schemaTreeList;
    }

    @Test
    public void testNestedDevice() throws Exception {
        ArrayList<MeasurementPath> measurementPathList = new ArrayList<MeasurementPath>();
        MeasurementSchema schema1 = new MeasurementSchema("s1", TSDataType.INT32);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.a.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d1.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPath.setUnderAlignedEntity(Boolean.valueOf(true));
        measurementPathList.add(measurementPath);
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendMeasurementPaths(measurementPathList);
        Assert.assertTrue((boolean)schemaTree.searchDeviceSchemaInfo(new PartialPath("root.sg.d1"), Collections.singletonList("s1")).isAligned());
    }

    protected SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> createSchemaTreeVisitorWithLimitOffsetWrapper(SchemaNode root, PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        return SchemaTreeVisitorFactory.createSchemaTreeMeasurementVisitor((SchemaNode)root, (PartialPath)pathPattern, (boolean)isPrefixMatch, (int)slimit, (int)soffset);
    }

    protected SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> createSchemaTreeVisitorWithLimitOffsetWrapper(SchemaNode root, PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch, PathPatternTree scope) {
        return SchemaTreeVisitorFactory.createSchemaTreeMeasurementVisitor((SchemaNode)root, (PartialPath)pathPattern, (boolean)isPrefixMatch, (int)slimit, (int)soffset, (PathPatternTree)scope);
    }

    @Test
    public void testHasView() throws IllegalPathException {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendSingleMeasurement(new PartialPath("root.db.db.s1"), (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), null, null, false);
        Assert.assertFalse((boolean)schemaTree.hasLogicalViewMeasurement());
        schemaTree.appendSingleMeasurement(new PartialPath("root.db.view.s1"), (IMeasurementSchema)new LogicalViewSchema("s1", (ViewExpression)new TimeSeriesViewOperand("root.db.d.s1")), null, null, false);
        Assert.assertTrue((boolean)schemaTree.hasLogicalViewMeasurement());
    }
}

