/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class GrafanaApiServiceTest {
    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private String getAuthorization(String username, String password) {
        return Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private HttpPost getHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        String authorization = this.getAuthorization("root", "root");
        httpPost.setHeader("Authorization", authorization);
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void login() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet("http://127.0.0.1:18080/grafana/v1/login");
        CloseableHttpResponse response = null;
        try {
            String authorization = this.getAuthorization("root", "root");
            httpGet.setHeader("Authorization", authorization);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)200L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rightInsertTablet(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/insertTablet");
            String json = "{\"timestamps\":[1635232143960,1635232153960],\"measurements\":[\"s4\",\"s5\"],\"dataTypes\":[\"INT32\",\"INT32\"],\"values\":[[11,2],[15,13]],\"isAligned\":false,\"deviceId\":\"root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            JsonObject result = JsonParser.parseString((String)message).getAsJsonObject();
            Assert.assertEquals((long)200L, (long)Integer.parseInt(result.get("code").toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expressionAggGroupByTimeAndLevel(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"count(s4)\"],\"prefixPath\":[\"root.sg25\"],\"startTime\":1635232143960,\"endTime\":1635232153960,\"control\":\"group by([1635232143960,1635232153960),1s),level=1\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            List timestampsResult = (List)map.get("timestamps");
            List expressionsResult = (List)map.get("expressions");
            List valuesResult = (List)map.get("values");
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((timestampsResult.size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((valuesResult.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)"count(root.sg25.s4)".equals(expressionsResult.get(0)));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expression(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"s4\",\"s5\"],\"prefixPath\":[\"root.sg25\"],\"startTime\":1635232133960,\"endTime\":1635232163960}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            Object[] expressionsResult = new String[]{"root.sg25.s4", "root.sg25.s5"};
            Object[] timestamps = new Long[]{1635232143960L, 1635232153960L};
            Object[] values1 = new Object[]{11, 2};
            Object[] values2 = new Object[]{15, 13};
            Assert.assertArrayEquals((Object[])expressionsResult, (Object[])((List)map.get("expressions")).toArray(new String[0]));
            Assert.assertArrayEquals((Object[])timestamps, (Object[])((List)map.get("timestamps")).toArray(new Long[0]));
            Assert.assertArrayEquals((Object[])values1, (Object[])((List)((List)map.get("values")).get(0)).toArray(new Object[0]));
            Assert.assertArrayEquals((Object[])values2, (Object[])((List)((List)map.get("values")).get(1)).toArray(new Object[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expressionWithControl(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"sum(s4)\",\"avg(s5)\"],\"prefixPath\":[\"root.sg25\"],\"startTime\":1635232133960,\"endTime\":1635232163960,\"control\":\"group by([1635232133960,1635232163960),20s)\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            Object[] expressionsResult = new String[]{"sum(root.sg25.s4)", "avg(root.sg25.s5)"};
            Object[] timestamps = new Long[]{1635232133960L, 1635232153960L};
            Object[] values1 = new Object[]{11.0, 2.0};
            Object[] values2 = new Object[]{15.0, 13.0};
            Assert.assertArrayEquals((Object[])expressionsResult, (Object[])((List)map.get("expressions")).toArray(new String[0]));
            Assert.assertArrayEquals((Object[])timestamps, (Object[])((List)map.get("timestamps")).toArray(new Long[0]));
            Assert.assertArrayEquals((Object[])values1, (Object[])((List)((List)map.get("values")).get(0)).toArray(new Object[0]));
            Assert.assertArrayEquals((Object[])values2, (Object[])((List)((List)map.get("values")).get(1)).toArray(new Object[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expressionWithConditionControl(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"sum(s4)\",\"avg(s5)\"],\"prefixPath\":[\"root.sg25\"],\"condition\":\"timestamp=1635232143960\",\"startTime\":1635232133960,\"endTime\":1635232163960,\"control\":\"group by([1635232133960,1635232163960),20s)\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            Object[] expressionsResult = new String[]{"sum(root.sg25.s4)", "avg(root.sg25.s5)"};
            Object[] timestamps = new Long[]{1635232133960L, 1635232153960L};
            Object[] values1 = new Object[]{11.0, null};
            Object[] values2 = new Object[]{15.0, null};
            Assert.assertArrayEquals((Object[])expressionsResult, (Object[])((List)map.get("expressions")).toArray(new String[0]));
            Assert.assertArrayEquals((Object[])timestamps, (Object[])((List)map.get("timestamps")).toArray(new Long[0]));
            Assert.assertArrayEquals((Object[])values1, (Object[])((List)((List)map.get("values")).get(0)).toArray(new Object[0]));
            Assert.assertArrayEquals((Object[])values2, (Object[])((List)((List)map.get("values")).get(1)).toArray(new Object[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void variable(CloseableHttpClient httpClient) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/variable");
            String sql = "{\"sql\":\"show child paths root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            List list = (List)mapper.readValue(message, List.class);
            Object[] expectedResult = new String[]{"s4", "s5"};
            Assert.assertArrayEquals((Object[])expectedResult, (Object[])list.toArray(new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void expressionWithConditionControlTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        this.expressionWithConditionControl(httpClient);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void expressionTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        this.expression(httpClient);
        this.expressionAggGroupByTimeAndLevel(httpClient);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void expressionWithControlTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        this.expressionWithControl(httpClient);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void variableTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        this.variable(httpClient);
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expressionWithAggGroupByTimeTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"count(s4)\"],\"prefixPath\":[\"root.sg25\"],\"startTime\":1635232143960,\"endTime\":1635232153960,\"control\":\"group by([1635232143960,1635232153960),1s)\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            List timestampsResult = (List)map.get("timestamps");
            List expressionsResult = (List)map.get("expressions");
            List valuesResult = (List)map.get("values");
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((timestampsResult.size() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((valuesResult.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)"count(root.sg25.s4)".equals(expressionsResult.get(0)));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expressionWithAggGroupByLevelTest() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this.rightInsertTablet(httpClient);
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/grafana/v1/query/expression");
            String sql = "{\"expression\":[\"count(s4)\"],\"prefixPath\":[\"root.sg25\"],\"startTime\":1635232143960,\"endTime\":1635232153960,\"control\":\"group by level = 1\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(message, Map.class);
            List timestampsResult = (List)map.get("timestamps");
            List expressionsResult = (List)map.get("expressions");
            List valuesResult = (List)map.get("values");
            Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((timestampsResult == null ? 1 : 0) != 0);
            Assert.assertTrue((valuesResult.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)"count(root.sg25.s4)".equals(expressionsResult.get(0)));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        try {
            httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

