/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.pipe.resource.wal.hardlink.PipeWALHardlinkResourceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeWALHardlinkResourceManagerTest {
    private static final String ROOT_DIR = "target" + File.separator + "PipeWALHolderTest";
    private static final String WAL_DIR = ROOT_DIR + File.separator + "wal";
    private static final String WAL_NAME = WAL_DIR + File.separator + "test.wal";
    private PipeWALHardlinkResourceManager pipeWALHardlinkResourceManager;

    @Before
    public void setUp() throws Exception {
        this.pipeWALHardlinkResourceManager = new PipeWALHardlinkResourceManager();
        this.createWAL();
    }

    private void createWAL() {
        File file = new File(WAL_NAME);
        if (file.exists()) {
            boolean bl = file.delete();
        }
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() throws Exception {
        File pipeFolder = new File(ROOT_DIR);
        if (pipeFolder.exists()) {
            FileUtils.deleteFileOrDirectory((File)pipeFolder);
        }
    }

    @Test
    public void testIncreaseTsfile() throws IOException {
        File originWALFile = new File(WAL_NAME);
        Assert.assertEquals((long)0L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(originWALFile));
        File pipeWALFile = this.pipeWALHardlinkResourceManager.increaseFileReference(originWALFile);
        Assert.assertEquals((long)1L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(pipeWALFile));
        Assert.assertTrue((boolean)Files.exists(originWALFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
        this.pipeWALHardlinkResourceManager.increaseFileReference(pipeWALFile);
        Assert.assertEquals((long)2L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(pipeWALFile));
        Assert.assertTrue((boolean)Files.exists(originWALFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
    }

    @Test
    public void testDecreaseTsfile() throws IOException {
        File originFile = new File(WAL_NAME);
        this.pipeWALHardlinkResourceManager.decreaseFileReference(originFile);
        Assert.assertEquals((long)0L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(originFile));
        File pipeWALFile = this.pipeWALHardlinkResourceManager.increaseFileReference(originFile);
        Assert.assertEquals((long)1L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(pipeWALFile));
        Assert.assertTrue((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)originFile.delete());
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertEquals((long)1L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(pipeWALFile));
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
        this.pipeWALHardlinkResourceManager.decreaseFileReference(pipeWALFile);
        Assert.assertEquals((long)0L, (long)this.pipeWALHardlinkResourceManager.getFileReferenceCount(pipeWALFile));
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(pipeWALFile.toPath(), new LinkOption[0]));
    }
}

