/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeTsFileResourceManagerTest {
    private static final String ROOT_DIR = "target" + File.separator + "PipeTsFileHolderTest";
    private static final String SEQUENCE_DIR = ROOT_DIR + File.separator + "sequence";
    private static final String TS_FILE_NAME = SEQUENCE_DIR + File.separator + "test.tsfile";
    private static final String MODS_FILE_NAME = TS_FILE_NAME + ".mods";
    private PipeTsFileResourceManager pipeTsFileResourceManager;

    @Before
    public void setUp() throws Exception {
        this.pipeTsFileResourceManager = new PipeTsFileResourceManager();
        PipeAgent.runtime().startPeriodicalJobExecutor();
        this.createTsfile(TS_FILE_NAME);
        this.creatModsFile(MODS_FILE_NAME);
    }

    private void createTsfile(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            boolean bl = file.delete();
        }
        Schema schema = new Schema();
        String template = "template";
        schema.extendTemplate(template, new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate(template, new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate(template, new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403004L, "root.lemming.device1");
        dPoint1 = new FloatDataPoint("sensor1", 4.1f);
        dPoint2 = new IntDataPoint("sensor2", 42);
        dPoint3 = new IntDataPoint("sensor3", 43);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    private void creatModsFile(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device1.sensor1"), 2L, 1L), new Deletion(new PartialPath("root.lemming.device1.sensor1"), 3L, 2L, 5L), new Deletion(new PartialPath("root.lemming.**"), 11L, 1L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() throws Exception {
        File pipeFolder = new File(ROOT_DIR);
        if (pipeFolder.exists()) {
            FileUtils.deleteFileOrDirectory((File)pipeFolder);
        }
        PipeAgent.runtime().stopPeriodicalJobExecutor();
        PipeAgent.runtime().clearPeriodicalJobExecutor();
    }

    @Test
    public void testIncreaseTsfile() throws IOException {
        File originTsfile = new File(TS_FILE_NAME);
        File originModFile = new File(MODS_FILE_NAME);
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(originTsfile));
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(originModFile));
        File pipeTsfile = this.pipeTsFileResourceManager.increaseFileReference(originTsfile, true);
        File pipeModFile = this.pipeTsFileResourceManager.increaseFileReference(originModFile, false);
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        Assert.assertTrue((boolean)Files.exists(originTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(originModFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
        this.pipeTsFileResourceManager.increaseFileReference(originTsfile, true);
        this.pipeTsFileResourceManager.increaseFileReference(originModFile, false);
        Assert.assertEquals((long)2L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertEquals((long)2L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        this.pipeTsFileResourceManager.increaseFileReference(pipeTsfile, true);
        Assert.assertEquals((long)3L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertTrue((boolean)Files.exists(originTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
        this.pipeTsFileResourceManager.increaseFileReference(pipeModFile, false);
        Assert.assertEquals((long)3L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        Assert.assertTrue((boolean)Files.exists(originModFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
    }

    @Test
    public void testDecreaseTsfile() throws IOException {
        File originFile = new File(TS_FILE_NAME);
        File originModFile = new File(MODS_FILE_NAME);
        this.pipeTsFileResourceManager.decreaseFileReference(originFile);
        this.pipeTsFileResourceManager.decreaseFileReference(originModFile);
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(originFile));
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(originModFile));
        File pipeTsfile = this.pipeTsFileResourceManager.increaseFileReference(originFile, true);
        File pipeModFile = this.pipeTsFileResourceManager.increaseFileReference(originModFile, false);
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        Assert.assertTrue((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)originFile.delete());
        Assert.assertTrue((boolean)originModFile.delete());
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(originModFile.toPath(), new LinkOption[0]));
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertEquals((long)1L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(originModFile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
        this.pipeTsFileResourceManager.decreaseFileReference(pipeTsfile);
        this.pipeTsFileResourceManager.decreaseFileReference(pipeModFile);
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeTsfile));
        Assert.assertEquals((long)0L, (long)this.pipeTsFileResourceManager.getFileReferenceCount(pipeModFile));
        Assert.assertFalse((boolean)Files.exists(originFile.toPath(), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(originModFile.toPath(), new LinkOption[0]));
        Awaitility.await().atMost(60000L, TimeUnit.MILLISECONDS).untilAsserted(() -> {
            Assert.assertFalse((boolean)Files.exists(pipeTsfile.toPath(), new LinkOption[0]));
            Assert.assertFalse((boolean)Files.exists(pipeModFile.toPath(), new LinkOption[0]));
        });
    }
}

