/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeDataNodeSnapshotResourceManagerTest {
    private static final String ROOT_DIR = "target" + File.separator + "PipeSnapshotResourceManagerTest";
    private static final String CONSENSUS_SNAPSHOT_DIR = ROOT_DIR + File.separator + "consensus" + File.separator + "snapshot0";
    private static final String PIPE_CONSENSUS_SNAPSHOT_DIR = ROOT_DIR + File.separator + "consensus" + File.separator + "pipe_snapshot" + File.separator + "snapshot0";
    private static final String WRONG_SNAPSHOT_DIR = ROOT_DIR + File.separator + "wrong" + File.separator + "snapshot0";
    private static final String PIPE_WRONG_SNAPSHOT_DIR = ROOT_DIR + File.separator + "wrong" + File.separator + "pipe_snapshot" + File.separator + "snapshot0";
    private static final String FILE = "test_file";

    @Before
    public void setUp() throws Exception {
        File testDir = new File(ROOT_DIR);
        if (testDir.exists()) {
            FileUtils.deleteFileOrDirectory((File)testDir);
        }
        new File(CONSENSUS_SNAPSHOT_DIR).mkdirs();
        new File(WRONG_SNAPSHOT_DIR).mkdirs();
        new File(CONSENSUS_SNAPSHOT_DIR, FILE).createNewFile();
        new File(WRONG_SNAPSHOT_DIR, FILE).createNewFile();
    }

    @After
    public void tearDown() throws Exception {
        File testDir = new File(ROOT_DIR);
        if (testDir.exists()) {
            FileUtils.deleteFileOrDirectory((File)testDir);
        }
    }

    @Test
    public void test() {
        try {
            PipeResourceManager.snapshot().increaseSnapshotReference(CONSENSUS_SNAPSHOT_DIR + File.separator + FILE);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)1L, (long)PipeResourceManager.snapshot().getSnapshotReferenceCount(PIPE_CONSENSUS_SNAPSHOT_DIR + File.separator + FILE));
        Assert.assertTrue((boolean)new File(PIPE_CONSENSUS_SNAPSHOT_DIR, FILE).exists());
        PipeResourceManager.snapshot().decreaseSnapshotReference(PIPE_CONSENSUS_SNAPSHOT_DIR + File.separator + FILE);
        Assert.assertEquals((long)0L, (long)PipeResourceManager.snapshot().getSnapshotReferenceCount(PIPE_CONSENSUS_SNAPSHOT_DIR + File.separator + FILE));
        Assert.assertFalse((boolean)new File(PIPE_CONSENSUS_SNAPSHOT_DIR, FILE).exists());
        try {
            PipeResourceManager.snapshot().increaseSnapshotReference(WRONG_SNAPSHOT_DIR + File.separator + FILE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)PipeResourceManager.snapshot().getSnapshotReferenceCount(PIPE_WRONG_SNAPSHOT_DIR + File.separator + FILE));
        Assert.assertFalse((boolean)new File(PIPE_WRONG_SNAPSHOT_DIR, FILE).exists());
    }
}

