/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.pattern;

import org.apache.iotdb.commons.pipe.pattern.PrefixPipePattern;
import org.junit.Assert;
import org.junit.Test;

public class PrefixPipePatternTest {
    @Test
    public void testPrefixPipePattern() {
        String[] legalPatterns = new String[]{"root", "root.", "root.db", "root.db.d1.s", "root.db.`1`"};
        String[] illegalPatterns = new String[]{"roo", "", "root..", "root./"};
        for (String string : legalPatterns) {
            Assert.assertTrue((boolean)new PrefixPipePattern(string).isLegal());
        }
        for (String string : illegalPatterns) {
            Assert.assertFalse((boolean)new PrefixPipePattern(string).isLegal());
        }
        String db = "root.db";
        String[] patternsCoverDb = new String[]{"root", "root.", "root.d", "root.db"};
        String[] patternsNotCoverDb = new String[]{"root.**", "root.db."};
        for (String string : patternsCoverDb) {
            Assert.assertTrue((boolean)new PrefixPipePattern(string).coversDb(db));
        }
        for (String string : patternsNotCoverDb) {
            Assert.assertFalse((boolean)new PrefixPipePattern(string).coversDb(db));
        }
        String string = "root.db.d1";
        String[] patternsCoverDevice = new String[]{"root", "root.", "root.d", "root.db", "root.db.", "root.db.d", "root.db.d1"};
        String[] patternsNotCoverDevice = new String[]{"root.db.d1.", "root.db.d1.s1", "root.**", "root.db.d2"};
        for (String s : patternsCoverDevice) {
            Assert.assertTrue((boolean)new PrefixPipePattern(s).coversDevice(string));
        }
        for (String t : patternsNotCoverDevice) {
            Assert.assertFalse((boolean)new PrefixPipePattern(t).coversDevice(string));
        }
        String[] stringArray = new String[]{"root", "root.db.d1", "root.db.d1.", "root.db.d1.s1"};
        String[] patternsNotOverlapWithDevice = new String[]{"root.db.d2", "root.**"};
        for (String s : stringArray) {
            Assert.assertTrue((boolean)new PrefixPipePattern(s).mayOverlapWithDevice(string));
        }
        for (String t : patternsNotOverlapWithDevice) {
            Assert.assertFalse((boolean)new PrefixPipePattern(t).mayOverlapWithDevice(string));
        }
        String measurement = "s1";
        String[] patternsMatchMeasurement = new String[]{"root.db.d1", "root.db.d1.", "root.db.d1.s", "root.db.d1.s1"};
        String[] patternsNotMatchMeasurement = new String[]{"root.db.d1.s11", "root.db.d1.s2"};
        for (String s : patternsMatchMeasurement) {
            Assert.assertTrue((boolean)new PrefixPipePattern(s).matchesMeasurement(string, measurement));
        }
        for (String t : patternsNotMatchMeasurement) {
            Assert.assertFalse((boolean)new PrefixPipePattern(t).matchesMeasurement(string, measurement));
        }
    }
}

