/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.pattern;

import org.apache.iotdb.commons.pipe.pattern.IoTDBPipePattern;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.junit.Assert;
import org.junit.Test;

public class IoTDBPipePatternTest {
    @Test
    public void testIotdbPipePattern() {
        String[] legalPatterns = new String[]{"root", "root.db", "root.db.d1.s", "root.db.`1`", "root.*.d.*s.s"};
        String[] illegalPatterns = new String[]{"root.", "roo", "", "root..", "root./"};
        for (String string : legalPatterns) {
            Assert.assertTrue((boolean)new IoTDBPipePattern(string).isLegal());
        }
        for (String string : illegalPatterns) {
            try {
                Assert.assertFalse((boolean)new IoTDBPipePattern(string).isLegal());
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof PipeException));
            }
        }
        String db = "root.db";
        String[] patternsCoverDb = new String[]{"root.**", "root.db.**", "root.*db*.**"};
        String[] patternsNotCoverDb = new String[]{"root.db", "root.*", "root.*.*", "root.db.*.**", "root.db.d1", "root.**.db.**"};
        for (String string : patternsCoverDb) {
            Assert.assertTrue((boolean)new IoTDBPipePattern(string).coversDb(db));
        }
        for (String string : patternsNotCoverDb) {
            Assert.assertFalse((boolean)new IoTDBPipePattern(string).coversDb(db));
        }
        String string = "root.db.d1";
        String[] patternsCoverDevice = new String[]{"root.**", "root.db.**", "root.*.*.*", "root.db.d1.*", "root.*db*.*d*.*", "root.**.*1.*"};
        String[] patternsNotCoverDevice = new String[]{"root.*", "root.*.*", "root.db.d1", "root.db.d2.*", "root.**.d2.**"};
        for (String s : patternsCoverDevice) {
            Assert.assertTrue((boolean)new IoTDBPipePattern(s).coversDevice(string));
        }
        for (String t : patternsNotCoverDevice) {
            Assert.assertFalse((boolean)new IoTDBPipePattern(t).coversDevice(string));
        }
        String[] stringArray = new String[]{"root.db.**", "root.db.d1", "root.db.d1.*", "root.db.d1.s1", "root.**.d2.**", "root.*.d*.**"};
        String[] patternsNotOverlapWithDevice = new String[]{"root.db.d2.**", "root.db2.d1.**", "root.db.db.d1.**"};
        for (String s : stringArray) {
            Assert.assertTrue((boolean)new IoTDBPipePattern(s).mayOverlapWithDevice(string));
        }
        for (String t : patternsNotOverlapWithDevice) {
            Assert.assertFalse((boolean)new IoTDBPipePattern(t).mayOverlapWithDevice(string));
        }
        String measurement = "s1";
        String[] patternsMatchMeasurement = new String[]{"root.db.d1.s1", "root.db.d1.*"};
        String[] patternsNotMatchMeasurement = new String[]{"root.db.d1", "root.db.d1", "root.db.d1.*.*"};
        for (String s : patternsMatchMeasurement) {
            Assert.assertTrue((boolean)new IoTDBPipePattern(s).matchesMeasurement(string, measurement));
        }
        for (String t : patternsNotMatchMeasurement) {
            Assert.assertFalse((boolean)new IoTDBPipePattern(t).matchesMeasurement(string, measurement));
        }
    }
}

