/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.pattern.PrefixPipePattern;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.pattern.CachedSchemaPatternMatcher;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachedSchemaPatternMatcherTest {
    private CachedSchemaPatternMatcher matcher;
    private ExecutorService executorService;
    private List<PipeRealtimeDataRegionExtractor> extractors;

    @Before
    public void setUp() {
        this.matcher = new CachedSchemaPatternMatcher();
        this.executorService = Executors.newSingleThreadExecutor();
        this.extractors = new ArrayList<PipeRealtimeDataRegionExtractor>();
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testCachedMatcher() throws Exception {
        PipeRealtimeDataRegionFakeExtractor dataRegionExtractor = new PipeRealtimeDataRegionFakeExtractor();
        dataRegionExtractor.customize(new PipeParameters((Map)new HashMap<String, String>(){
            {
                this.put("extractor.pattern", "root");
            }
        }), (PipeExtractorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskExtractorRuntimeEnvironment("1", 1L, 1, null)));
        this.extractors.add(dataRegionExtractor);
        int deviceExtractorNum = 10;
        int seriesExtractorNum = 10;
        for (int i = 0; i < deviceExtractorNum; ++i) {
            PipeRealtimeDataRegionFakeExtractor deviceExtractor = new PipeRealtimeDataRegionFakeExtractor();
            final int finalI1 = i;
            deviceExtractor.customize(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("extractor.pattern", "root." + finalI1);
                }
            }), (PipeExtractorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskExtractorRuntimeEnvironment("1", 1L, 1, null)));
            this.extractors.add(deviceExtractor);
            int j = 0;
            while (j < seriesExtractorNum) {
                PipeRealtimeDataRegionFakeExtractor seriesExtractor = new PipeRealtimeDataRegionFakeExtractor();
                final int finalI = i;
                final int finalJ = j++;
                seriesExtractor.customize(new PipeParameters((Map)new HashMap<String, String>(){
                    {
                        this.put("extractor.pattern", "root." + finalI + "." + finalJ);
                    }
                }), (PipeExtractorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskExtractorRuntimeEnvironment("1", 1L, 1, null)));
                this.extractors.add(seriesExtractor);
            }
        }
        Future<?> future = this.executorService.submit(() -> this.extractors.forEach(extractor -> this.matcher.register(extractor)));
        int epochNum = 10000;
        int deviceNum = 1000;
        int seriesNum = 100;
        Map<String, String[]> deviceMap = IntStream.range(0, deviceNum).mapToObj(String::valueOf).collect(Collectors.toMap(s -> "root." + s, s -> new String[0]));
        String[] measurements = (String[])IntStream.range(0, seriesNum).mapToObj(String::valueOf).toArray(String[]::new);
        long totalTime = 0L;
        for (int i = 0; i < epochNum; ++i) {
            for (int j = 0; j < deviceNum; ++j) {
                PipeRealtimeEvent event = new PipeRealtimeEvent(null, null, Collections.singletonMap("root." + i, measurements), null);
                long startTime = System.currentTimeMillis();
                this.matcher.match(event).forEach(extractor -> extractor.extract(event));
                totalTime += System.currentTimeMillis() - startTime;
            }
            PipeRealtimeEvent event = new PipeRealtimeEvent(null, null, deviceMap, null);
            long startTime = System.currentTimeMillis();
            this.matcher.match(event).forEach(extractor -> extractor.extract(event));
            totalTime += System.currentTimeMillis() - startTime;
        }
        System.out.println("matcher.getRegisterCount() = " + this.matcher.getRegisterCount());
        System.out.println("totalTime = " + totalTime);
        System.out.println("device match per second = " + (double)(epochNum * (deviceNum + 1)) / (double)totalTime * 1000.0);
        future.get();
    }

    public static class PipeRealtimeDataRegionFakeExtractor
    extends PipeRealtimeDataRegionExtractor {
        public PipeRealtimeDataRegionFakeExtractor() {
            this.pipePattern = new PrefixPipePattern(null);
        }

        public Event supply() {
            return null;
        }

        protected void doExtract(PipeRealtimeEvent event) {
            boolean[] match = new boolean[]{false};
            event.getSchemaInfo().forEach((k, v) -> {
                if (((String[])v).length > 0) {
                    for (String s : v) {
                        match[0] = match[0] || (k + "." + s).startsWith(this.getPatternString());
                    }
                } else {
                    match[0] = match[0] || this.getPatternString().startsWith((String)k) || k.startsWith(this.getPatternString());
                }
            });
            Assert.assertTrue((boolean)match[0]);
        }

        public boolean isNeedListenToTsFile() {
            return true;
        }

        public boolean isNeedListenToInsertNode() {
            return true;
        }
    }
}

