/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedWritePlanNode;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchemaRegionListeningQueueTest {
    private static final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");

    @BeforeClass
    public static void setup() {
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).close();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException, AuthException, IllegalPathException {
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).open();
        PipeAgent.runtime().notifySchemaLeaderReady(new SchemaRegionId(0));
        CreateTimeSeriesNode node1 = new CreateTimeSeriesNode(new PlanNodeId("CreateTimeSeriesNode"), new PartialPath("root.db.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, "alias");
        PipeEnrichedWritePlanNode node2 = new PipeEnrichedWritePlanNode((WritePlanNode)new ActivateTemplateNode(new PlanNodeId("ActivateTemplateNode"), new PartialPath("root.sg.d1.s1"), 2, 1));
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).tryListenToNode((PlanNode)node1);
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).tryListenToNode((PlanNode)node2);
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).createSnapshot(snapshotDir);
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).close();
        PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).loadSnapshot(snapshotDir);
        Assert.assertTrue((boolean)PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).isOpened());
        ConcurrentIterableLinkedQueue.DynamicIterator itr = PipeAgent.runtime().schemaListener(new SchemaRegionId(0)).newIterator(0L);
        Event event1 = (Event)itr.next(0L);
        Assert.assertEquals((Object)node1, (Object)((PipeSchemaRegionWritePlanEvent)event1).getPlanNode());
        Event event2 = (Event)itr.next(0L);
        Assert.assertEquals((Object)node2.getWritePlanNode(), (Object)((PipeSchemaRegionWritePlanEvent)event2).getPlanNode());
        Assert.assertTrue((boolean)((PipeSchemaRegionWritePlanEvent)event2).isGeneratedByPipe());
        Assert.assertNull((Object)itr.next(0L));
    }
}

