/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.junit.Assert;
import org.junit.Test;

public class IoTDBDataRegionExtractorTest {
    @Test
    public void testIoTDBDataRegionExtractor() {
        IoTDBDataRegionExtractor extractor = new IoTDBDataRegionExtractor();
        try {
            extractor.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("extractor.history.enable", Boolean.TRUE.toString());
                    this.put("extractor.realtime.enable", Boolean.TRUE.toString());
                    this.put("extractor.realtime.mode", "hybrid");
                }
            })));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testIoTDBDataRegionExtractorWithPattern() {
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("root.a-b").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("root.1.a").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("r").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("123").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("root.a b").getClass());
        Assert.assertEquals(IllegalArgumentException.class, this.testIoTDBDataRegionExtractorWithPattern("root.a+b").getClass());
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.ab."));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.a#b"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.\u4e00\u4e8c\u4e09"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.\u4e00\u4e8c\u3002\u4e09"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root."));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.ab"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.a.b.c.1e2"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.`a-b`"));
        Assert.assertNull((Object)this.testIoTDBDataRegionExtractorWithPattern("root.1"));
    }

    public Exception testIoTDBDataRegionExtractorWithPattern(final String pattern) {
        try (IoTDBDataRegionExtractor extractor = new IoTDBDataRegionExtractor();){
            extractor.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("extractor.pattern", pattern);
                }
            })));
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }
}

