/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.execution;

import org.apache.iotdb.commons.pipe.execution.executor.PipeSubtaskExecutor;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class PipeSubtaskExecutorTest {
    protected PipeSubtaskExecutor executor;
    protected PipeSubtask subtask;

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
    }

    @Test
    public void testRegister() {
        Assert.assertFalse((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertTrue((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertTrue((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
    }

    @Test
    public void testStart() throws Exception {
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((PipeSubtask)Mockito.verify((Object)this.subtask, (VerificationMode)Mockito.times((int)0))).call();
        this.executor.register(this.subtask);
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((PipeSubtask)Mockito.verify((Object)this.subtask, (VerificationMode)Mockito.atLeast((int)2))).call();
        Assert.assertTrue((boolean)this.subtask.isSubmittingSelf());
        this.executor.start(this.subtask.getTaskID());
        Assert.assertTrue((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testStop() {
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.register(this.subtask);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testDeregister() {
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testShutdown() {
        this.executor.start(this.subtask.getTaskID());
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }
}

