/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.pattern.PrefixPipePattern;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataContainer;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionDataContainerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionDataContainerTest.class);
    private static final long TSFILE_START_TIME = 300L;
    private static final String PREFIX_FORMAT = "prefix";
    private static final String IOTDB_FORMAT = "iotdb";
    private File alignedTsFile;
    private File nonalignedTsFile;

    @After
    public void tearDown() throws Exception {
        if (this.alignedTsFile != null) {
            this.alignedTsFile.delete();
        }
        if (this.nonalignedTsFile != null) {
            this.nonalignedTsFile.delete();
        }
    }

    @Test
    public void testToTabletInsertionEvents() throws Exception {
        HashSet<Integer> deviceNumbers = new HashSet<Integer>();
        deviceNumbers.add(1);
        deviceNumbers.add(2);
        HashSet<Integer> measurementNumbers = new HashSet<Integer>();
        measurementNumbers.add(1);
        measurementNumbers.add(2);
        HashSet<String> patternFormats = new HashSet<String>();
        patternFormats.add(PREFIX_FORMAT);
        patternFormats.add(IOTDB_FORMAT);
        HashSet<Pair> startEndTimes = new HashSet<Pair>();
        startEndTimes.add(new Pair((Object)100L, (Object)299L));
        startEndTimes.add(new Pair((Object)100L, (Object)300L));
        startEndTimes.add(new Pair((Object)100L, (Object)301L));
        startEndTimes.add(new Pair((Object)299L, (Object)299L));
        startEndTimes.add(new Pair((Object)300L, (Object)300L));
        startEndTimes.add(new Pair((Object)301L, (Object)301L));
        startEndTimes.add(new Pair((Object)301L, (Object)301L));
        startEndTimes.add(new Pair((Object)301L, (Object)310L));
        startEndTimes.add(new Pair((Object)301L, (Object)400L));
        startEndTimes.add(new Pair((Object)301L, (Object)10300L));
        startEndTimes.add(new Pair((Object)1000300L, (Object)2000300L));
        startEndTimes.add(new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
        Iterator iterator = deviceNumbers.iterator();
        while (iterator.hasNext()) {
            int deviceNumber = (Integer)iterator.next();
            Iterator iterator2 = measurementNumbers.iterator();
            while (iterator2.hasNext()) {
                int measurementNumber = (Integer)iterator2.next();
                for (String patternFormat : patternFormats) {
                    for (Pair startEndTime : startEndTimes) {
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 0, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 2, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 999, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1000, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1001, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1999, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1000, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 2001, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1023, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1024, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 1025, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 2047, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 2048, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 2049, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                        this.testToTabletInsertionEvents(deviceNumber, measurementNumber, 10001, patternFormat, (Long)startEndTime.left, (Long)startEndTime.right);
                    }
                }
            }
        }
    }

    private void testToTabletInsertionEvents(int deviceNumber, int measurementNumber, int rowNumberInOneDevice, String patternFormat, long startTime, long endTime) throws Exception {
        PrefixPipePattern notExistPattern;
        PrefixPipePattern oneNonAlignedMeasurementPattern;
        PrefixPipePattern oneAlignedMeasurementPattern;
        PrefixPipePattern oneNonAlignedDevicePattern;
        PrefixPipePattern oneAlignedDevicePattern;
        PrefixPipePattern rootPattern;
        LOGGER.debug("testToTabletInsertionEvents: deviceNumber: {}, measurementNumber: {}, rowNumberInOneDevice: {}, patternFormat: {}, startTime: {}, endTime: {}", new Object[]{deviceNumber, measurementNumber, rowNumberInOneDevice, patternFormat, startTime, endTime});
        this.alignedTsFile = TsFileGeneratorUtils.generateAlignedTsFile((String)"aligned.tsfile", (int)deviceNumber, (int)measurementNumber, (int)rowNumberInOneDevice, (int)300, (int)10000, (int)700, (int)50);
        this.nonalignedTsFile = TsFileGeneratorUtils.generateNonAlignedTsFile((String)"nonaligned.tsfile", (int)deviceNumber, (int)measurementNumber, (int)rowNumberInOneDevice, (int)300, (int)10000, (int)700, (int)50);
        int tsfileEndTime = 300 + rowNumberInOneDevice - 1;
        int expectedRowNumber = rowNumberInOneDevice;
        Assert.assertTrue((startTime <= endTime ? 1 : 0) != 0);
        if (startTime != Long.MIN_VALUE && endTime != Long.MAX_VALUE) {
            expectedRowNumber = startTime < 300L ? (endTime < 300L ? 0 : Math.min((int)(endTime - 300L + 1L), rowNumberInOneDevice)) : ((long)tsfileEndTime < startTime ? 0 : Math.min((int)(Math.min(endTime, (long)tsfileEndTime) - startTime + 1L), rowNumberInOneDevice));
        }
        switch (patternFormat) {
            case "prefix": {
                rootPattern = new PrefixPipePattern("root");
                break;
            }
            default: {
                rootPattern = new IoTDBPipePattern("root.**");
            }
        }
        try (TsFileInsertionDataContainer alignedContainer = new TsFileInsertionDataContainer(this.alignedTsFile, (PipePattern)rootPattern, startTime, endTime);
             TsFileInsertionDataContainer nonalignedContainer = new TsFileInsertionDataContainer(this.nonalignedTsFile, (PipePattern)rootPattern, startTime, endTime);){
            AtomicInteger count1 = new AtomicInteger(0);
            AtomicInteger count2 = new AtomicInteger(0);
            AtomicInteger count3 = new AtomicInteger(0);
            alignedContainer.toTabletInsertionEvents().forEach(event -> event.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })))));
            Assert.assertEquals((long)count1.getAndSet(0), (long)(deviceNumber * expectedRowNumber));
            Assert.assertEquals((long)count2.getAndSet(0), (long)(deviceNumber * expectedRowNumber));
            Assert.assertEquals((long)count3.getAndSet(0), (long)(deviceNumber * expectedRowNumber));
            nonalignedContainer.toTabletInsertionEvents().forEach(event -> event.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)measurementNumber, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }))));
            Assert.assertEquals((long)(deviceNumber * expectedRowNumber), (long)count1.get());
            Assert.assertEquals((long)(deviceNumber * expectedRowNumber), (long)count2.get());
            Assert.assertEquals((long)(deviceNumber * expectedRowNumber), (long)count3.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        AtomicReference oneDeviceInAlignedTsFile = new AtomicReference();
        AtomicReference oneMeasurementInAlignedTsFile = new AtomicReference();
        AtomicReference oneDeviceInUnalignedTsFile = new AtomicReference();
        AtomicReference oneMeasurementInUnalignedTsFile = new AtomicReference();
        try (TsFileSequenceReader alignedReader = new TsFileSequenceReader(this.alignedTsFile.getAbsolutePath());
             TsFileSequenceReader nonalignedReader = new TsFileSequenceReader(this.nonalignedTsFile.getAbsolutePath());){
            alignedReader.getDeviceMeasurementsMap().forEach((k, v) -> v.stream().filter(p -> p != null && !p.isEmpty()).forEach(p -> {
                oneDeviceInAlignedTsFile.set(((PlainDeviceID)k).toStringID());
                oneMeasurementInAlignedTsFile.set(new Path(k, p, false).toString());
            }));
            nonalignedReader.getDeviceMeasurementsMap().forEach((k, v) -> v.stream().filter(p -> p != null && !p.isEmpty()).forEach(p -> {
                oneDeviceInUnalignedTsFile.set(((PlainDeviceID)k).toStringID());
                oneMeasurementInUnalignedTsFile.set(new Path(k, p, false).toString());
            }));
        }
        switch (patternFormat) {
            case "prefix": {
                oneAlignedDevicePattern = new PrefixPipePattern((String)oneDeviceInAlignedTsFile.get());
                oneNonAlignedDevicePattern = new PrefixPipePattern((String)oneDeviceInUnalignedTsFile.get());
                break;
            }
            default: {
                oneAlignedDevicePattern = new IoTDBPipePattern((String)oneDeviceInAlignedTsFile.get() + ".**");
                oneNonAlignedDevicePattern = new IoTDBPipePattern((String)oneDeviceInUnalignedTsFile.get() + ".**");
            }
        }
        try (TsFileInsertionDataContainer alignedContainer = new TsFileInsertionDataContainer(this.alignedTsFile, (PipePattern)oneAlignedDevicePattern, startTime, endTime);
             TsFileInsertionDataContainer nonalignedContainer = new TsFileInsertionDataContainer(this.nonalignedTsFile, (PipePattern)oneNonAlignedDevicePattern, startTime, endTime);){
            Object count1 = new AtomicInteger(0);
            AtomicInteger count2 = new AtomicInteger(0);
            AtomicInteger count3 = new AtomicInteger(0);
            alignedContainer.toTabletInsertionEvents().forEach(arg_0 -> TsFileInsertionDataContainerTest.lambda$testToTabletInsertionEvents$26(measurementNumber, (AtomicInteger)count1, count2, count3, arg_0));
            Assert.assertEquals((long)expectedRowNumber, (long)((AtomicInteger)count1).getAndSet(0));
            Assert.assertEquals((long)expectedRowNumber, (long)count2.getAndSet(0));
            Assert.assertEquals((long)expectedRowNumber, (long)count3.getAndSet(0));
            nonalignedContainer.toTabletInsertionEvents().forEach(arg_0 -> TsFileInsertionDataContainerTest.lambda$testToTabletInsertionEvents$33(measurementNumber, (AtomicInteger)count1, count2, count3, arg_0));
            Assert.assertEquals((long)expectedRowNumber, (long)((AtomicInteger)count1).get());
            Assert.assertEquals((long)expectedRowNumber, (long)count2.get());
            Assert.assertEquals((long)expectedRowNumber, (long)count3.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        switch (patternFormat) {
            case "prefix": {
                oneAlignedMeasurementPattern = new PrefixPipePattern((String)oneMeasurementInAlignedTsFile.get());
                oneNonAlignedMeasurementPattern = new PrefixPipePattern((String)oneMeasurementInUnalignedTsFile.get());
                break;
            }
            default: {
                oneAlignedMeasurementPattern = new IoTDBPipePattern((String)oneMeasurementInAlignedTsFile.get());
                oneNonAlignedMeasurementPattern = new IoTDBPipePattern((String)oneMeasurementInUnalignedTsFile.get());
            }
        }
        try (TsFileInsertionDataContainer alignedContainer = new TsFileInsertionDataContainer(this.alignedTsFile, (PipePattern)oneAlignedMeasurementPattern, startTime, endTime);
             TsFileInsertionDataContainer nonalignedContainer = new TsFileInsertionDataContainer(this.nonalignedTsFile, (PipePattern)oneNonAlignedMeasurementPattern, startTime, endTime);){
            AtomicInteger count1 = new AtomicInteger(0);
            AtomicInteger count2 = new AtomicInteger(0);
            AtomicInteger count3 = new AtomicInteger(0);
            alignedContainer.toTabletInsertionEvents().forEach(event -> event.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })))));
            Assert.assertEquals((long)expectedRowNumber, (long)count1.getAndSet(0));
            Assert.assertEquals((long)expectedRowNumber, (long)count2.getAndSet(0));
            Assert.assertEquals((long)expectedRowNumber, (long)count3.getAndSet(0));
            nonalignedContainer.toTabletInsertionEvents().forEach(event -> event.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)1L, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }))));
            Assert.assertEquals((long)expectedRowNumber, (long)count1.get());
            Assert.assertEquals((long)expectedRowNumber, (long)count2.get());
            Assert.assertEquals((long)expectedRowNumber, (long)count3.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        switch (patternFormat) {
            case "prefix": {
                notExistPattern = new PrefixPipePattern("root.`not-exist-pattern`");
                break;
            }
            default: {
                notExistPattern = new IoTDBPipePattern("root.`not-exist-pattern`");
            }
        }
        try (TsFileInsertionDataContainer alignedContainer = new TsFileInsertionDataContainer(this.alignedTsFile, (PipePattern)notExistPattern, startTime, endTime);
             TsFileInsertionDataContainer nonalignedContainer = new TsFileInsertionDataContainer(this.nonalignedTsFile, (PipePattern)notExistPattern, startTime, endTime);){
            AtomicInteger count1 = new AtomicInteger(0);
            AtomicInteger count2 = new AtomicInteger(0);
            AtomicInteger count3 = new AtomicInteger(0);
            alignedContainer.toTabletInsertionEvents().forEach(event -> event.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })))));
            Assert.assertEquals((long)0L, (long)count1.getAndSet(0));
            Assert.assertEquals((long)0L, (long)count2.getAndSet(0));
            Assert.assertEquals((long)0L, (long)count3.getAndSet(0));
            nonalignedContainer.toTabletInsertionEvents().forEach(event -> event.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
                try {
                    rowCollector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count1.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count2.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processRowByRow((row, collector) -> {
                try {
                    collector.collectRow(row);
                    Assert.assertEquals((long)0L, (long)row.size());
                    count3.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }))));
            Assert.assertEquals((long)0L, (long)count1.get());
            Assert.assertEquals((long)0L, (long)count2.get());
            Assert.assertEquals((long)0L, (long)count3.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static /* synthetic */ void lambda$testToTabletInsertionEvents$33(int measurementNumber, AtomicInteger count1, AtomicInteger count2, AtomicInteger count3, TabletInsertionEvent event) {
        event.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
            try {
                rowCollector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count1.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
            try {
                collector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count2.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processRowByRow((row, collector) -> {
            try {
                collector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count3.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })));
    }

    private static /* synthetic */ void lambda$testToTabletInsertionEvents$26(int measurementNumber, AtomicInteger count1, AtomicInteger count2, AtomicInteger count3, TabletInsertionEvent event) {
        event.processRowByRow((row, collector) -> {
            try {
                collector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count1.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(tabletInsertionEvent1 -> tabletInsertionEvent1.processRowByRow((row, collector) -> {
            try {
                collector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count2.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(tabletInsertionEvent2 -> tabletInsertionEvent2.processTablet((tablet, rowCollector) -> new PipeRawTabletInsertionEvent(tablet, false).processRowByRow((row, collector) -> {
            try {
                rowCollector.collectRow(row);
                Assert.assertEquals((long)measurementNumber, (long)row.size());
                count3.incrementAndGet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }))));
    }
}

