/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.Arrays;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.pattern.PrefixPipePattern;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeTabletInsertionEventTest {
    private InsertRowNode insertRowNode;
    private InsertRowNode insertRowNodeAligned;
    private InsertTabletNode insertTabletNode;
    private InsertTabletNode insertTabletNodeAligned;
    final String deviceId = "root.sg.d1";
    final long[] times = new long[]{110L, 111L, 112L, 113L, 114L};
    final String[] measurementIds = new String[]{"s1", "s2", "s3", "s4", "s5", "s6"};
    final TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.TEXT};
    final MeasurementSchema[] schemas = new MeasurementSchema[6];
    final String pattern = "root.sg.d1";
    Tablet tabletForInsertRowNode;
    Tablet tabletForInsertTabletNode;

    @Before
    public void setUp() throws Exception {
        this.createMeasurementSchema();
        this.createInsertRowNode();
        this.createInsertTabletNode();
        this.createTablet();
    }

    private void createMeasurementSchema() {
        for (int i = 0; i < this.schemas.length; ++i) {
            this.schemas[i] = new MeasurementSchema(this.measurementIds[i], this.dataTypes[i]);
        }
    }

    private void createInsertRowNode() throws IllegalPathException {
        Object[] values = new Object[this.schemas.length];
        values[0] = 100;
        values[1] = 10000L;
        values[2] = Float.valueOf(2.0f);
        values[3] = 1.0;
        values[4] = false;
        values[5] = BytesUtils.valueOf((String)"text");
        this.insertRowNode = new InsertRowNode(new PlanNodeId("plan node 1"), new PartialPath("root.sg.d1"), false, this.measurementIds, this.dataTypes, this.schemas, this.times[0], values, false);
        this.insertRowNodeAligned = new InsertRowNode(new PlanNodeId("plan node 1"), new PartialPath("root.sg.d1"), true, this.measurementIds, this.dataTypes, this.schemas, this.times[0], values, false);
    }

    private void createInsertTabletNode() throws IllegalPathException {
        Object[] values = new Object[this.schemas.length];
        values[0] = new int[this.times.length];
        values[1] = new long[this.times.length];
        values[2] = new float[this.times.length];
        values[3] = new double[this.times.length];
        values[4] = new boolean[this.times.length];
        values[5] = new Binary[this.times.length];
        for (int r = 0; r < this.times.length; ++r) {
            ((int[])values[0])[r] = 100;
            ((long[])values[1])[r] = 10000L;
            ((float[])values[2])[r] = 2.0f;
            ((double[])values[3])[r] = 1.0;
            ((boolean[])values[4])[r] = false;
            ((Binary[])values[5])[r] = BytesUtils.valueOf((String)"text");
        }
        this.insertTabletNode = new InsertTabletNode(new PlanNodeId("plannode 1"), new PartialPath("root.sg.d1"), false, this.measurementIds, this.dataTypes, this.schemas, this.times, null, values, this.times.length);
        this.insertTabletNodeAligned = new InsertTabletNode(new PlanNodeId("plannode 1"), new PartialPath("root.sg.d1"), true, this.measurementIds, this.dataTypes, this.schemas, this.times, null, values, this.times.length);
    }

    private void createTablet() {
        Object[] values = new Object[this.schemas.length];
        BitMap[] bitMapsForInsertRowNode = new BitMap[this.schemas.length];
        for (int i = 0; i < this.schemas.length; ++i) {
            bitMapsForInsertRowNode[i] = new BitMap(1);
        }
        values[0] = new int[1];
        values[1] = new long[1];
        values[2] = new float[1];
        values[3] = new double[1];
        values[4] = new boolean[1];
        values[5] = new Binary[1];
        for (int r = 0; r < 1; ++r) {
            ((int[])values[0])[r] = 100;
            ((long[])values[1])[r] = 10000L;
            ((float[])values[2])[r] = 2.0f;
            ((double[])values[3])[r] = 1.0;
            ((boolean[])values[4])[r] = false;
            ((Binary[])values[5])[r] = BytesUtils.valueOf((String)"text");
        }
        this.tabletForInsertRowNode = new Tablet("root.sg.d1", Arrays.asList(this.schemas), 1);
        this.tabletForInsertRowNode.values = values;
        this.tabletForInsertRowNode.timestamps = new long[]{this.times[0]};
        this.tabletForInsertRowNode.rowSize = 1;
        this.tabletForInsertRowNode.bitMaps = bitMapsForInsertRowNode;
        BitMap[] bitMapsForInsertTabletNode = new BitMap[this.schemas.length];
        for (int i = 0; i < this.schemas.length; ++i) {
            bitMapsForInsertTabletNode[i] = new BitMap(this.times.length);
        }
        values[0] = new int[this.times.length];
        values[1] = new long[this.times.length];
        values[2] = new float[this.times.length];
        values[3] = new double[this.times.length];
        values[4] = new boolean[this.times.length];
        values[5] = new Binary[this.times.length];
        for (int r = 0; r < this.times.length; ++r) {
            ((int[])values[0])[r] = 100;
            ((long[])values[1])[r] = 10000L;
            ((float[])values[2])[r] = 2.0f;
            ((double[])values[3])[r] = 1.0;
            ((boolean[])values[4])[r] = false;
            ((Binary[])values[5])[r] = BytesUtils.valueOf((String)"text");
        }
        this.tabletForInsertTabletNode = new Tablet("root.sg.d1", Arrays.asList(this.schemas), this.times.length);
        this.tabletForInsertTabletNode.values = values;
        this.tabletForInsertTabletNode.timestamps = this.times;
        this.tabletForInsertTabletNode.rowSize = this.times.length;
        this.tabletForInsertTabletNode.bitMaps = bitMapsForInsertTabletNode;
    }

    @Test
    public void convertToTabletForTest() {
        TabletInsertionDataContainer container1 = new TabletInsertionDataContainer((InsertNode)this.insertRowNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet1 = container1.convertToTablet();
        boolean isAligned1 = container1.isAligned();
        Assert.assertEquals((Object)tablet1, (Object)this.tabletForInsertRowNode);
        Assert.assertFalse((boolean)isAligned1);
        TabletInsertionDataContainer container2 = new TabletInsertionDataContainer((InsertNode)this.insertTabletNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet2 = container2.convertToTablet();
        boolean isAligned2 = container2.isAligned();
        Assert.assertEquals((Object)tablet2, (Object)this.tabletForInsertTabletNode);
        Assert.assertFalse((boolean)isAligned2);
        PipeRawTabletInsertionEvent event3 = new PipeRawTabletInsertionEvent(tablet1, false, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet3 = event3.convertToTablet();
        boolean isAligned3 = event3.isAligned();
        Assert.assertEquals((Object)tablet1, (Object)tablet3);
        Assert.assertFalse((boolean)isAligned3);
        PipeRawTabletInsertionEvent event4 = new PipeRawTabletInsertionEvent(tablet2, false, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet4 = event4.convertToTablet();
        boolean isAligned4 = event4.isAligned();
        Assert.assertEquals((Object)tablet2, (Object)tablet4);
        Assert.assertFalse((boolean)isAligned4);
    }

    @Test
    public void convertToAlignedTabletForTest() {
        TabletInsertionDataContainer container1 = new TabletInsertionDataContainer((InsertNode)this.insertRowNodeAligned, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet1 = container1.convertToTablet();
        boolean isAligned1 = container1.isAligned();
        Assert.assertEquals((Object)tablet1, (Object)this.tabletForInsertRowNode);
        Assert.assertTrue((boolean)isAligned1);
        TabletInsertionDataContainer container2 = new TabletInsertionDataContainer((InsertNode)this.insertTabletNodeAligned, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet2 = container2.convertToTablet();
        boolean isAligned2 = container2.isAligned();
        Assert.assertEquals((Object)tablet2, (Object)this.tabletForInsertTabletNode);
        Assert.assertTrue((boolean)isAligned2);
        PipeRawTabletInsertionEvent event3 = new PipeRawTabletInsertionEvent(tablet1, true, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet3 = event3.convertToTablet();
        boolean isAligned3 = event3.isAligned();
        Assert.assertEquals((Object)tablet1, (Object)tablet3);
        Assert.assertTrue((boolean)isAligned3);
        PipeRawTabletInsertionEvent event4 = new PipeRawTabletInsertionEvent(tablet2, true, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet4 = event4.convertToTablet();
        boolean isAligned4 = event4.isAligned();
        Assert.assertEquals((Object)tablet2, (Object)tablet4);
        Assert.assertTrue((boolean)isAligned4);
    }

    @Test
    public void convertToTabletWithFilteredRowsForTest() {
        TabletInsertionDataContainer container1 = new TabletInsertionDataContainer(null, (EnrichedEvent)new PipeRawTabletInsertionEvent(this.tabletForInsertRowNode, 111L, 113L), (InsertNode)this.insertRowNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet1 = container1.convertToTablet();
        Assert.assertEquals((long)0L, (long)tablet1.rowSize);
        boolean isAligned1 = container1.isAligned();
        Assert.assertFalse((boolean)isAligned1);
        TabletInsertionDataContainer container2 = new TabletInsertionDataContainer(null, (EnrichedEvent)new PipeRawTabletInsertionEvent(this.tabletForInsertRowNode, 110L, 110L), (InsertNode)this.insertRowNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet2 = container2.convertToTablet();
        Assert.assertEquals((long)1L, (long)tablet2.rowSize);
        boolean isAligned2 = container2.isAligned();
        Assert.assertFalse((boolean)isAligned2);
        TabletInsertionDataContainer container3 = new TabletInsertionDataContainer(null, (EnrichedEvent)new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, 111L, 113L), (InsertNode)this.insertTabletNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet3 = container3.convertToTablet();
        Assert.assertEquals((long)3L, (long)tablet3.rowSize);
        boolean isAligned3 = container3.isAligned();
        Assert.assertFalse((boolean)isAligned3);
        TabletInsertionDataContainer container4 = new TabletInsertionDataContainer(null, (EnrichedEvent)new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, Long.MIN_VALUE, 109L), (InsertNode)this.insertTabletNode, (PipePattern)new PrefixPipePattern("root.sg.d1"));
        Tablet tablet4 = container4.convertToTablet();
        Assert.assertEquals((long)0L, (long)tablet4.rowSize);
        boolean isAligned4 = container4.isAligned();
        Assert.assertFalse((boolean)isAligned4);
    }

    @Test
    public void isEventTimeOverlappedWithTimeRangeTest() {
        PipeRawTabletInsertionEvent event = new PipeRawTabletInsertionEvent(this.tabletForInsertRowNode, 111L, 113L);
        Assert.assertFalse((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertRowNode, 110L, 110L);
        Assert.assertTrue((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, 111L, 113L);
        Assert.assertTrue((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, Long.MIN_VALUE, 110L);
        Assert.assertTrue((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, 114L, Long.MAX_VALUE);
        Assert.assertTrue((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, Long.MIN_VALUE, 109L);
        Assert.assertFalse((boolean)event.mayEventTimeOverlappedWithTimeRange());
        event = new PipeRawTabletInsertionEvent(this.tabletForInsertTabletNode, 115L, Long.MAX_VALUE);
        Assert.assertFalse((boolean)event.mayEventTimeOverlappedWithTimeRange());
    }
}

