/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.pipe.event.common.row.PipeDataTypeTransformer;
import org.apache.iotdb.pipe.api.type.Type;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeDataTypeTransformerTest {
    private List<TSDataType> nullTsDataTypeList;
    private List<TSDataType> tsDataTypeList;
    private List<Type> nullTypeList;
    private List<Type> typeList;

    @Before
    public void setUp() {
        this.createDataTypeList();
    }

    public void createDataTypeList() {
        this.nullTsDataTypeList = null;
        this.tsDataTypeList = new ArrayList<TSDataType>();
        this.tsDataTypeList.add(TSDataType.INT32);
        this.tsDataTypeList.add(TSDataType.INT64);
        this.tsDataTypeList.add(TSDataType.FLOAT);
        this.tsDataTypeList.add(TSDataType.DOUBLE);
        this.tsDataTypeList.add(TSDataType.BOOLEAN);
        this.tsDataTypeList.add(TSDataType.TEXT);
        this.tsDataTypeList.add(null);
        this.nullTypeList = null;
        this.typeList = new ArrayList<Type>();
        this.typeList.add(Type.INT32);
        this.typeList.add(Type.INT64);
        this.typeList.add(Type.FLOAT);
        this.typeList.add(Type.DOUBLE);
        this.typeList.add(Type.BOOLEAN);
        this.typeList.add(Type.TEXT);
        this.typeList.add(null);
    }

    @Test
    public void testDataTypeTransformer() {
        List nullResultList = PipeDataTypeTransformer.transformToPipeDataTypeList(this.nullTsDataTypeList);
        List resultList = PipeDataTypeTransformer.transformToPipeDataTypeList(this.tsDataTypeList);
        Assert.assertEquals((Object)nullResultList, this.nullTypeList);
        Assert.assertEquals((Object)resultList, this.typeList);
    }
}

