/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class PipeDataNodeThriftRequestTest {
    private static final String TIME_PRECISION = "ms";

    @Test
    public void testPipeTransferDataNodeHandshakeReq() throws IOException {
        PipeTransferDataNodeHandshakeV1Req req = PipeTransferDataNodeHandshakeV1Req.toTPipeTransferReq((String)TIME_PRECISION);
        PipeTransferDataNodeHandshakeV1Req deserializeReq = PipeTransferDataNodeHandshakeV1Req.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getTimestampPrecision(), (Object)deserializeReq.getTimestampPrecision());
    }

    @Test
    public void testPipeTransferInsertNodeReq() {
        PipeTransferTabletInsertNodeReq req = PipeTransferTabletInsertNodeReq.toTPipeTransferReq((InsertNode)new InsertRowNode(new PlanNodeId(""), new PartialPath(new String[]{"root", "sg", "d"}), false, new String[]{"s"}, new TSDataType[]{TSDataType.INT32}, 1L, new Object[]{1}, false));
        PipeTransferTabletInsertNodeReq deserializeReq = PipeTransferTabletInsertNodeReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getInsertNode(), (Object)deserializeReq.getInsertNode());
        InsertBaseStatement statement = req.constructStatement();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(new PartialPath(new String[]{"root", "sg", "d", "s"}));
        Assert.assertEquals((Object)statement.getPaths(), paths);
    }

    @Test
    public void testPipeTransferTabletBinaryReq() {
        PipeTransferTabletBinaryReq req = PipeTransferTabletBinaryReq.toTPipeTransferReq((ByteBuffer)ByteBuffer.wrap(new byte[]{97, 98}));
        PipeTransferTabletBinaryReq deserializeReq = PipeTransferTabletBinaryReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
    }

    @Test
    public void testPipeTransferSchemaPlanReq() {
        PipeTransferPlanNodeReq req = PipeTransferPlanNodeReq.toTPipeTransferReq((PlanNode)new CreateAlignedTimeSeriesNode(new PlanNodeId(""), new PartialPath(new String[]{"root", "sg", "d"}), Collections.singletonList("s"), Collections.singletonList(TSDataType.INT32), Collections.singletonList(TSEncoding.PLAIN), Collections.singletonList(CompressionType.UNCOMPRESSED), null, null, null));
        PipeTransferPlanNodeReq deserializeReq = PipeTransferPlanNodeReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getPlanNode(), (Object)deserializeReq.getPlanNode());
    }

    @Test
    public void testPipeTransferTabletReq() {
        try {
            ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
            schemaList.add(new MeasurementSchema("s1", TSDataType.INT32));
            schemaList.add(new MeasurementSchema("s2", TSDataType.INT64));
            schemaList.add(new MeasurementSchema("s3", TSDataType.FLOAT));
            schemaList.add(new MeasurementSchema("s4", TSDataType.DOUBLE));
            schemaList.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
            schemaList.add(new MeasurementSchema("s6", TSDataType.TEXT));
            Tablet t = new Tablet("root.sg.d", schemaList, 1024);
            t.rowSize = 2;
            t.addTimestamp(0, 2000L);
            t.addTimestamp(1, 1000L);
            t.addValue("s1", 0, (Object)2);
            t.addValue("s6", 0, (Object)"2");
            t.addValue("s1", 1, (Object)1);
            t.addValue("s6", 1, (Object)"1");
            PipeTransferTabletRawReq req = PipeTransferTabletRawReq.toTPipeTransferReq((Tablet)t, (boolean)false);
            PipeTransferTabletRawReq deserializeReq = PipeTransferTabletRawReq.fromTPipeTransferReq((TPipeTransferReq)req);
            Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
            Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
            Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
            InsertTabletStatement statement = req.constructStatement();
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s1"}));
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s2"}));
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s3"}));
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s4"}));
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s5"}));
            paths.add(new PartialPath(new String[]{"root", "sg", "d", "s6"}));
            Assert.assertEquals((Object)statement.getPaths(), paths);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testPipeTransferTabletBatchReq() throws IOException {
        ArrayList<ByteBuffer> binaryBuffers = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> insertNodeBuffers = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> tabletBuffers = new ArrayList<ByteBuffer>();
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath(new String[]{"root", "sg", "d"}), false, new String[]{"s"}, new TSDataType[]{TSDataType.INT32}, 1L, new Object[]{1}, false);
        insertNodeBuffers.add(node.serializeToByteBuffer());
        binaryBuffers.add(ByteBuffer.wrap(new byte[]{97, 98}));
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        schemaList.add(new MeasurementSchema("s1", TSDataType.INT32));
        schemaList.add(new MeasurementSchema("s2", TSDataType.INT64));
        schemaList.add(new MeasurementSchema("s3", TSDataType.FLOAT));
        schemaList.add(new MeasurementSchema("s4", TSDataType.DOUBLE));
        schemaList.add(new MeasurementSchema("s5", TSDataType.BOOLEAN));
        schemaList.add(new MeasurementSchema("s6", TSDataType.TEXT));
        Tablet t = new Tablet("root.sg.d", schemaList, 1024);
        t.rowSize = 2;
        t.addTimestamp(0, 2000L);
        t.addTimestamp(1, 1000L);
        t.addValue("s1", 0, (Object)2);
        t.addValue("s6", 0, (Object)"2");
        t.addValue("s1", 1, (Object)1);
        t.addValue("s6", 1, (Object)"1");
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            t.serialize(outputStream);
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)outputStream);
            tabletBuffers.add(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
        }
        PipeTransferTabletBatchReq req = PipeTransferTabletBatchReq.toTPipeTransferReq(binaryBuffers, insertNodeBuffers, tabletBuffers);
        PipeTransferTabletBatchReq deserializedReq = PipeTransferTabletBatchReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertArrayEquals((byte[])new byte[]{97, 98}, (byte[])((PipeTransferTabletBinaryReq)deserializedReq.getBinaryReqs().get(0)).getBody());
        Assert.assertEquals((Object)node, (Object)((PipeTransferTabletInsertNodeReq)deserializedReq.getInsertNodeReqs().get(0)).getInsertNode());
        Assert.assertEquals((Object)t, (Object)((PipeTransferTabletRawReq)deserializedReq.getTabletReqs().get(0)).getTablet());
        Assert.assertFalse((boolean)((PipeTransferTabletRawReq)deserializedReq.getTabletReqs().get(0)).getIsAligned());
    }

    @Test
    public void testPipeTransferFilePieceReq() throws IOException {
        byte[] body = "testPipeTransferFilePieceReq".getBytes();
        String fileName = "1.tsfile";
        PipeTransferTsFilePieceReq req = PipeTransferTsFilePieceReq.toTPipeTransferReq((String)fileName, (long)0L, (byte[])body);
        PipeTransferTsFilePieceReq deserializeReq = PipeTransferTsFilePieceReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getFileName(), (Object)deserializeReq.getFileName());
        Assert.assertEquals((long)req.getStartWritingOffset(), (long)deserializeReq.getStartWritingOffset());
        Assert.assertArrayEquals((byte[])req.getFilePiece(), (byte[])deserializeReq.getFilePiece());
    }

    @Test
    public void testPipeTransferFilePieceWithModReq() throws IOException {
        byte[] body = "testPipeTransferFilePieceWithModReq".getBytes();
        String fileName = "1.tsfile.mod";
        PipeTransferTsFilePieceWithModReq req = PipeTransferTsFilePieceWithModReq.toTPipeTransferReq((String)fileName, (long)0L, (byte[])body);
        PipeTransferTsFilePieceWithModReq deserializeReq = PipeTransferTsFilePieceWithModReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getFileName(), (Object)deserializeReq.getFileName());
        Assert.assertEquals((long)req.getStartWritingOffset(), (long)deserializeReq.getStartWritingOffset());
        Assert.assertArrayEquals((byte[])req.getFilePiece(), (byte[])deserializeReq.getFilePiece());
    }

    @Test
    public void testPipeTransferSchemaSnapshotPieceReq() throws IOException {
        byte[] body = "testPipeTransferSchemaSnapshotPieceReq".getBytes();
        String fileName = "1.temp";
        PipeTransferSchemaSnapshotPieceReq req = PipeTransferSchemaSnapshotPieceReq.toTPipeTransferReq((String)fileName, (long)0L, (byte[])body);
        PipeTransferSchemaSnapshotPieceReq deserializeReq = PipeTransferSchemaSnapshotPieceReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getFileName(), (Object)deserializeReq.getFileName());
        Assert.assertEquals((long)req.getStartWritingOffset(), (long)deserializeReq.getStartWritingOffset());
        Assert.assertArrayEquals((byte[])req.getFilePiece(), (byte[])deserializeReq.getFilePiece());
    }

    @Test
    public void testPipeTransferTsFileSealReq() throws IOException {
        String fileName = "1.tsfile";
        PipeTransferTsFileSealReq req = PipeTransferTsFileSealReq.toTPipeTransferReq((String)fileName, (long)100L);
        PipeTransferTsFileSealReq deserializeReq = PipeTransferTsFileSealReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getFileName(), (Object)deserializeReq.getFileName());
        Assert.assertEquals((long)req.getFileLength(), (long)deserializeReq.getFileLength());
    }

    @Test
    public void testPipeTransferSchemaSnapshotSealReq() throws IOException {
        String mTreeSnapshotName = "mtree.snapshot";
        String tLogName = "tlog.txt";
        String databaseName = "root.db";
        String typeString = "19";
        PipeTransferSchemaSnapshotSealReq req = PipeTransferSchemaSnapshotSealReq.toTPipeTransferReq((String)mTreeSnapshotName, (long)100L, (String)tLogName, (long)10L, (String)databaseName, (String)typeString);
        PipeTransferSchemaSnapshotSealReq deserializeReq = PipeTransferSchemaSnapshotSealReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertArrayEquals((byte[])req.getBody(), (byte[])deserializeReq.getBody());
        Assert.assertEquals((Object)req.getFileNames(), (Object)deserializeReq.getFileNames());
        Assert.assertEquals((Object)req.getFileLengths(), (Object)deserializeReq.getFileLengths());
        Assert.assertEquals((Object)req.getParameters(), (Object)deserializeReq.getParameters());
    }

    @Test
    public void testPipeTransferFilePieceResp() throws IOException {
        PipeTransferFilePieceResp resp = PipeTransferFilePieceResp.toTPipeTransferResp((TSStatus)RpcUtils.SUCCESS_STATUS, (long)100L);
        PipeTransferFilePieceResp deserializeResp = PipeTransferFilePieceResp.fromTPipeTransferResp((TPipeTransferResp)resp);
        Assert.assertEquals((Object)resp.getStatus(), (Object)deserializeResp.getStatus());
        Assert.assertEquals((long)resp.getEndWritingOffset(), (long)deserializeResp.getEndWritingOffset());
    }
}

