/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.db.pipe.connector.protocol.legacy.IoTDBLegacyPipeConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBDataRegionSyncConnector;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.junit.Assert;
import org.junit.Test;

public class PipeConnectorTest {
    @Test(expected=PipeParameterNotValidException.class)
    public void testIoTDBLegacyPipeConnectorToSelf() throws Exception {
        try (IoTDBLegacyPipeConnector connector = new IoTDBLegacyPipeConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName());
                    this.put("connector.ip", "127.0.0.1");
                    this.put("connector.port", "6667");
                }
            })));
        }
    }

    @Test
    public void testIoTDBLegacyPipeConnectorToOthers() {
        try (IoTDBLegacyPipeConnector connector = new IoTDBLegacyPipeConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName());
                    this.put("connector.ip", "127.0.0.1");
                    this.put("connector.port", "6668");
                }
            })));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=PipeParameterNotValidException.class)
    public void testIoTDBThriftSyncConnectorToSelf() throws Exception {
        try (IoTDBDataRegionSyncConnector connector = new IoTDBDataRegionSyncConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName());
                    this.put("connector.ip", "127.0.0.1");
                    this.put("connector.port", "6667");
                }
            })));
        }
    }

    @Test
    public void testIoTDBThriftSyncConnectorToOthers() {
        try (IoTDBDataRegionSyncConnector connector = new IoTDBDataRegionSyncConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName());
                    this.put("connector.ip", "127.0.0.1");
                    this.put("connector.port", "6668");
                }
            })));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=PipeParameterNotValidException.class)
    public void testIoTDBThriftAsyncConnectorToSelf() throws Exception {
        try (IoTDBDataRegionAsyncConnector connector = new IoTDBDataRegionAsyncConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName());
                    this.put("connector.node-urls", "127.0.0.1:6667");
                }
            })));
        }
    }

    @Test
    public void testIoTDBThriftAsyncConnectorToOthers() {
        try (IoTDBDataRegionAsyncConnector connector = new IoTDBDataRegionAsyncConnector();){
            connector.validate(new PipeParameterValidator(new PipeParameters((Map)new HashMap<String, String>(){
                {
                    this.put("connector", BuiltinPipePlugin.IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName());
                    this.put("connector.node-urls", "127.0.0.1:6668");
                }
            })));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

