/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.db.pipe.agent.plugin.PipeDataNodePluginAgent;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeDataNodePluginAgentTest {
    private static final String TMP_DIR = "PipePluginAgentTest_libroot";

    @Before
    public void before() {
        try {
            Files.createDirectory(Paths.get(TMP_DIR, new String[0]), new FileAttribute[0]);
            PipePluginClassLoaderManager.setupAndGetInstance((String)TMP_DIR);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @After
    public void after() {
        try {
            Files.deleteIfExists(Paths.get(TMP_DIR, new String[0]));
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testPipePluginAgent() {
        PipeDataNodePluginAgent agent = new PipeDataNodePluginAgent();
        try {
            agent.register(new PipePluginMeta("plugin-name", "org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor", false, "jar", "md5"), null);
            agent.deregister("plugin-name", false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals(IoTDBDataRegionExtractor.class, agent.dataRegion().reflectExtractor(new PipeParameters((Map)new HashMap<String, String>(){
            {
                this.put("extractor", BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName());
            }
        })).getClass());
        Assert.assertEquals((Object)BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginClass(), agent.dataRegion().reflectProcessor(new PipeParameters((Map)new HashMap<String, String>(){
            {
                this.put("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName());
            }
        })).getClass());
        Assert.assertEquals(IoTDBDataRegionAsyncConnector.class, agent.dataRegion().reflectConnector(new PipeParameters((Map)new HashMap<String, String>(){
            {
                this.put("connector", BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName());
            }
        })).getClass());
    }
}

