/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metric;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.DoNothingMetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.junit.Assert;
import org.junit.Test;

public class MetricServiceTest {
    private static final double DELTA = 1.0E-6;
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static AbstractMetricService metricService = new DoNothingMetricService();

    @Test
    public void testMetricService() {
        metricConfig.setMetricLevel(MetricLevel.IMPORTANT);
        metricService = MetricService.getInstance();
        metricService.startService();
        Assert.assertTrue((boolean)metricService.getMetricManager().isEnableMetricInGivenLevel(MetricLevel.CORE));
        Assert.assertTrue((boolean)metricService.getMetricManager().isEnableMetricInGivenLevel(MetricLevel.IMPORTANT));
        Assert.assertFalse((boolean)metricService.getMetricManager().isEnableMetricInGivenLevel(MetricLevel.NORMAL));
        Assert.assertFalse((boolean)metricService.getMetricManager().isEnableMetricInGivenLevel(MetricLevel.ALL));
        this.testNormalSituation();
        this.testOtherSituation();
        metricService.stopService();
    }

    private void testNormalSituation() {
        Counter counter1 = metricService.getOrCreateCounter("counter1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)counter1);
        metricService.count(10L, "counter1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)10L, (long)counter1.getCount());
        metricService.count(20L, "counter1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)30L, (long)counter1.getCount());
        Counter counter2 = metricService.getOrCreateCounter("counter1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((Object)counter1, (Object)counter2);
        counter2 = metricService.getOrCreateCounter("counter2", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotEquals((Object)counter1, (Object)counter2);
        counter2 = metricService.getOrCreateCounter("counter3", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)counter1, (Object)counter2);
        counter2 = metricService.getOrCreateCounter("counter4", MetricLevel.IMPORTANT, new String[]{"tag", "value", "tag2", "value"});
        Assert.assertNotEquals((Object)counter1, (Object)counter2);
        counter2 = metricService.getOrCreateCounter("counter5", MetricLevel.NORMAL, new String[]{"tag", "value"});
        Assert.assertEquals((Object)DoNothingMetricManager.DO_NOTHING_COUNTER, (Object)counter2);
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        metricService.count(10L, "counter6", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        metricService.remove(MetricType.COUNTER, "counter6", new String[0]);
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        metricService.remove(MetricType.COUNTER, "counter6", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        Assert.assertEquals((long)4L, (long)metricService.getAllMetricKeys().size());
        Gauge gauge1 = metricService.getOrCreateGauge("gauge1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)gauge1);
        metricService.gauge(10L, "gauge1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)10L, (long)gauge1.getValue());
        Gauge gauge2 = metricService.getOrCreateGauge("gauge1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((Object)gauge1, (Object)gauge2);
        gauge2 = metricService.getOrCreateGauge("gauge2", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotEquals((Object)gauge1, (Object)gauge2);
        gauge2 = metricService.getOrCreateGauge("gauge3", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)gauge1, (Object)gauge2);
        gauge2 = metricService.getOrCreateGauge("gauge4", MetricLevel.IMPORTANT, new String[]{"tag", "value", "tag2", "value"});
        Assert.assertNotEquals((Object)gauge1, (Object)gauge2);
        gauge2 = metricService.getOrCreateGauge("gauge5", MetricLevel.NORMAL, new String[]{"tag", "value"});
        Assert.assertEquals((Object)DoNothingMetricManager.DO_NOTHING_GAUGE, (Object)gauge2);
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        metricService.gauge(10L, "gauge6", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        metricService.remove(MetricType.GAUGE, "gauge6", new String[0]);
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        metricService.remove(MetricType.GAUGE, "gauge6", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        Assert.assertEquals((long)8L, (long)metricService.getAllMetricKeys().size());
        ArrayList<Integer> list = new ArrayList<Integer>();
        AutoGauge autoGauge = metricService.createAutoGauge("autoGauge", MetricLevel.IMPORTANT, list, List::size, new String[]{"tag", "value"});
        Assert.assertEquals((double)0.0, (double)autoGauge.getValue(), (double)1.0E-6);
        list.add(1);
        Assert.assertEquals((double)1.0, (double)autoGauge.getValue(), (double)1.0E-6);
        list.clear();
        Assert.assertEquals((double)0.0, (double)autoGauge.getValue(), (double)1.0E-6);
        list.add(1);
        Assert.assertEquals((double)1.0, (double)autoGauge.getValue(), (double)1.0E-6);
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        Assert.assertEquals((long)1L, (long)metricService.getMetricsByType(MetricType.AUTO_GAUGE).size());
        metricService.remove(MetricType.AUTO_GAUGE, "autoGauge", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.GAUGE).size());
        Assert.assertEquals((long)8L, (long)metricService.getAllMetricKeys().size());
        Rate rate1 = metricService.getOrCreateRate("rate1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)rate1);
        metricService.rate(10L, "rate1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)10L, (long)rate1.getCount());
        metricService.rate(20L, "rate1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)30L, (long)rate1.getCount());
        Rate rate2 = metricService.getOrCreateRate("rate1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((Object)rate1, (Object)rate2);
        rate2 = metricService.getOrCreateRate("rate2", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotEquals((Object)rate1, (Object)rate2);
        rate2 = metricService.getOrCreateRate("rate3", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)rate1, (Object)rate2);
        rate2 = metricService.getOrCreateRate("rate4", MetricLevel.IMPORTANT, new String[]{"tag", "value", "tag2", "value"});
        Assert.assertNotEquals((Object)rate1, (Object)rate2);
        rate2 = metricService.getOrCreateRate("rate5", MetricLevel.NORMAL, new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.RATE).size());
        Assert.assertEquals((Object)DoNothingMetricManager.DO_NOTHING_RATE, (Object)rate2);
        metricService.rate(10L, "rate6", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.RATE).size());
        metricService.remove(MetricType.RATE, "rate6", new String[0]);
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.RATE).size());
        metricService.remove(MetricType.RATE, "rate6", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.RATE).size());
        Assert.assertEquals((long)12L, (long)metricService.getAllMetricKeys().size());
        Histogram histogram1 = metricService.getOrCreateHistogram("histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)histogram1);
        metricService.histogram(10L, "histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.histogram(20L, "histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.histogram(30L, "histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.histogram(40L, "histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.histogram(50L, "histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)histogram1.getCount());
        Assert.assertEquals((double)150.0, (double)histogram1.takeSnapshot().getSum(), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)histogram1.takeSnapshot().getMax(), (double)1.0E-5);
        Histogram histogram2 = metricService.getOrCreateHistogram("histogram1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((Object)histogram1, (Object)histogram2);
        histogram2 = metricService.getOrCreateHistogram("histogram2", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotEquals((Object)histogram1, (Object)histogram2);
        histogram2 = metricService.getOrCreateHistogram("histogram3", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)histogram1, (Object)histogram2);
        histogram2 = metricService.getOrCreateHistogram("histogram4", MetricLevel.IMPORTANT, new String[]{"tag", "value", "tag2", "value"});
        Assert.assertNotEquals((Object)histogram1, (Object)histogram2);
        histogram2 = metricService.getOrCreateHistogram("histogram5", MetricLevel.NORMAL, new String[]{"tag", "value"});
        Assert.assertEquals((Object)DoNothingMetricManager.DO_NOTHING_HISTOGRAM, (Object)histogram2);
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.HISTOGRAM).size());
        metricService.histogram(10L, "histogram6", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.HISTOGRAM).size());
        metricService.remove(MetricType.HISTOGRAM, "histogram6", new String[0]);
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.HISTOGRAM).size());
        metricService.remove(MetricType.HISTOGRAM, "histogram6", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.HISTOGRAM).size());
        Assert.assertEquals((long)16L, (long)metricService.getAllMetricKeys().size());
        Timer timer1 = metricService.getOrCreateTimer("timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)timer1);
        metricService.timer(2L, TimeUnit.MILLISECONDS, "timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.timer(4L, TimeUnit.MILLISECONDS, "timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.timer(6L, TimeUnit.MILLISECONDS, "timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.timer(8L, TimeUnit.MILLISECONDS, "timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        metricService.timer(10L, TimeUnit.MILLISECONDS, "timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)timer1.getCount());
        Timer timer2 = metricService.getOrCreateTimer("timer1", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((Object)timer1, (Object)timer2);
        timer2 = metricService.getOrCreateTimer("timer2", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotEquals((Object)timer1, (Object)timer2);
        timer2 = metricService.getOrCreateTimer("timer3", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)timer1, (Object)timer2);
        timer2 = metricService.getOrCreateTimer("timer4", MetricLevel.IMPORTANT, new String[]{"tag", "value", "tag2", "value"});
        Assert.assertNotEquals((Object)timer1, (Object)timer2);
        timer2 = metricService.getOrCreateTimer("timer5", MetricLevel.NORMAL, new String[]{"tag", "value"});
        Assert.assertNotEquals((Object)timer1, (Object)timer2);
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.TIMER).size());
        metricService.timer(10L, TimeUnit.MILLISECONDS, "timer6", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.TIMER).size());
        metricService.remove(MetricType.TIMER, "timer6", new String[0]);
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.TIMER).size());
        metricService.remove(MetricType.TIMER, "timer6", new String[]{"tag", "value"});
        Assert.assertEquals((long)4L, (long)metricService.getMetricsByType(MetricType.TIMER).size());
        Assert.assertEquals((long)20L, (long)metricService.getAllMetricKeys().size());
        Counter removeCounter1 = metricService.getOrCreateCounter("remove", MetricLevel.IMPORTANT, new String[]{"tag", "value1"});
        Assert.assertNotNull((Object)removeCounter1);
        Counter removeCounter2 = metricService.getOrCreateCounter("remove", MetricLevel.IMPORTANT, new String[]{"tag", "value2"});
        Assert.assertNotNull((Object)removeCounter2);
        Assert.assertEquals((long)6L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        Assert.assertEquals((long)22L, (long)metricService.getAllMetricKeys().size());
        metricService.remove(MetricType.COUNTER, "remove", new String[]{"tag", "value1"});
        Assert.assertEquals((long)5L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        Assert.assertEquals((long)21L, (long)metricService.getAllMetricKeys().size());
        removeCounter2 = metricService.getOrCreateCounter("remove", MetricLevel.IMPORTANT, new String[]{"tag", "value1"});
        Assert.assertNotNull((Object)removeCounter2);
        Assert.assertEquals((long)6L, (long)metricService.getMetricsByType(MetricType.COUNTER).size());
        Assert.assertEquals((long)22L, (long)metricService.getAllMetricKeys().size());
    }

    private void testOtherSituation() {
        Assert.assertThrows(IllegalArgumentException.class, this::getOrCreateDifferentMetricsWithSameName);
        Timer timer = metricService.getOrCreateTimer("same_name", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)timer);
        Assert.assertNotEquals((Object)DoNothingMetricManager.DO_NOTHING_TIMER, (Object)timer);
        Counter counter = metricService.getOrCreateCounter("same_name", MetricLevel.IMPORTANT, new String[0]);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((Object)DoNothingMetricManager.DO_NOTHING_COUNTER, (Object)counter);
    }

    private void getOrCreateDifferentMetricsWithSameName() {
        Timer timer = metricService.getOrCreateTimer("same_name", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
        Assert.assertNotNull((Object)timer);
        metricService.getOrCreateCounter("same_name", MetricLevel.IMPORTANT, new String[]{"tag", "value"});
    }
}

