/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.AdditionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.MultiplicationViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.ConstantViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimestampViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.multi.FunctionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.BetweenViewExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class ViewExpressionToStringTest {
    @Test
    public void testTimseriesOperand() {
        String fullPath = "root.db.device.s01";
        TimeSeriesViewOperand timeSeriesViewOperand = new TimeSeriesViewOperand(fullPath);
        Assert.assertEquals((Object)fullPath, (Object)timeSeriesViewOperand.toString());
        Assert.assertEquals((Object)fullPath, (Object)timeSeriesViewOperand.toString(true));
        Assert.assertEquals((Object)fullPath, (Object)timeSeriesViewOperand.toString(false));
    }

    @Test
    public void testAdditionViewExpression() {
        TimeSeriesViewOperand timeSeriesViewOperand = new TimeSeriesViewOperand("root.db.device.s01");
        ConstantViewOperand constantViewOperand = new ConstantViewOperand(TSDataType.INT32, "2");
        AdditionViewExpression add = new AdditionViewExpression((ViewExpression)timeSeriesViewOperand, (ViewExpression)constantViewOperand);
        String expectedRoot = "root.db.device.s01 + 2";
        String expectedNotRoot = "(root.db.device.s01 + 2)";
        Assert.assertEquals((Object)expectedRoot, (Object)add.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)add.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)add.toString(false));
    }

    @Test
    public void testTwoBinaryExpression() {
        TimeSeriesViewOperand ts1 = new TimeSeriesViewOperand("root.db.device.s01");
        ConstantViewOperand constant2 = new ConstantViewOperand(TSDataType.INT32, "2");
        AdditionViewExpression add = new AdditionViewExpression((ViewExpression)ts1, (ViewExpression)constant2);
        TimeSeriesViewOperand ts2 = new TimeSeriesViewOperand("root.ln.d.s01");
        MultiplicationViewExpression multiplication = new MultiplicationViewExpression((ViewExpression)add, (ViewExpression)ts2);
        String expectedRoot = "(root.db.device.s01 + 2) * root.ln.d.s01";
        String expectedNotRoot = "((root.db.device.s01 + 2) * root.ln.d.s01)";
        Assert.assertEquals((Object)expectedRoot, (Object)multiplication.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)multiplication.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)multiplication.toString(false));
    }

    @Test
    public void testFunctionViewExpression01() {
        String functionName = "func";
        FunctionViewExpression func = new FunctionViewExpression(functionName);
        String expectedRoot = "func()";
        String expectedNotRoot = "func()";
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)func.toString(false));
    }

    @Test
    public void testFunctionViewExpression02() {
        String functionName = "MAX";
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        TimeSeriesViewOperand ts1 = new TimeSeriesViewOperand("root.db.device.s01");
        ConstantViewOperand constant2 = new ConstantViewOperand(TSDataType.INT32, "2");
        AdditionViewExpression add = new AdditionViewExpression((ViewExpression)ts1, (ViewExpression)constant2);
        TimeSeriesViewOperand ts2 = new TimeSeriesViewOperand("root.ln.d.s01");
        List<ViewExpression> exps = Arrays.asList(add, ts2);
        FunctionViewExpression func = new FunctionViewExpression(functionName, keys, values, exps);
        String expectedRoot = "MAX(root.db.device.s01 + 2, root.ln.d.s01)";
        String expectedNotRoot = "MAX(root.db.device.s01 + 2, root.ln.d.s01)";
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)func.toString(false));
    }

    @Test
    public void testFunctionViewExpression03() {
        String functionName = "CAST";
        List<String> keys = Collections.singletonList("type");
        List<String> values = Collections.singletonList("INT32");
        TimeSeriesViewOperand ts2 = new TimeSeriesViewOperand("root.ln.d.s01");
        List<TimeSeriesViewOperand> exps = Collections.singletonList(ts2);
        FunctionViewExpression func = new FunctionViewExpression(functionName, keys, values, exps);
        String expectedRoot = "CAST(root.ln.d.s01, type=INT32)";
        String expectedNotRoot = "CAST(root.ln.d.s01, type=INT32)";
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)func.toString(false));
    }

    @Test
    public void testFunctionViewExpression04() {
        String functionName = "CAST";
        List<String> keys = Collections.singletonList("type");
        List<String> values = Collections.singletonList("INT32");
        TimeSeriesViewOperand ts2 = new TimeSeriesViewOperand("root.ln.d.s01");
        List<TimeSeriesViewOperand> exps = Collections.singletonList(ts2);
        FunctionViewExpression func = new FunctionViewExpression(functionName, keys, values, exps);
        String expectedRoot = "CAST(root.ln.d.s01, type=INT32)";
        String expectedNotRoot = "CAST(root.ln.d.s01, type=INT32)";
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)func.toString(false));
    }

    @Test
    public void testFunctionViewExpression05() {
        String functionName = "FUNC";
        List<String> keys = Arrays.asList("type", "key");
        List<String> values = Arrays.asList("INT32", "value");
        TimeSeriesViewOperand ts1 = new TimeSeriesViewOperand("root.db.device.s01");
        TimeSeriesViewOperand ts2 = new TimeSeriesViewOperand("root.ln.d.s01");
        List<ViewExpression> exps = Arrays.asList(ts1, ts2);
        FunctionViewExpression func = new FunctionViewExpression(functionName, keys, values, exps);
        String expectedRoot = "FUNC(root.db.device.s01, root.ln.d.s01, type=INT32, key=value)";
        String expectedNotRoot = "FUNC(root.db.device.s01, root.ln.d.s01, type=INT32, key=value)";
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)func.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)func.toString(false));
    }

    @Test
    public void testBetweenViewExpression() {
        TimestampViewOperand timestamp01 = new TimestampViewOperand();
        TimestampViewOperand timestamp02 = new TimestampViewOperand();
        TimeSeriesViewOperand ts1 = new TimeSeriesViewOperand("root.db.device.s01");
        BetweenViewExpression exp = new BetweenViewExpression((ViewExpression)ts1, (ViewExpression)timestamp01, (ViewExpression)timestamp02);
        String expectedRoot = "root.db.device.s01 BETWEEN TIMESTAMP AND TIMESTAMP";
        String expectedNotRoot = "(root.db.device.s01 BETWEEN TIMESTAMP AND TIMESTAMP)";
        Assert.assertEquals((Object)expectedRoot, (Object)exp.toString());
        Assert.assertEquals((Object)expectedRoot, (Object)exp.toString(true));
        Assert.assertEquals((Object)expectedNotRoot, (Object)exp.toString(false));
    }
}

