/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.metadata.schemaRegion.SchemaRegionTestUtil;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class SchemaStatisticsTest
extends AbstractSchemaRegionTest {
    public SchemaStatisticsTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    @Test
    public void testPBTreeMemoryStatistics() throws Exception {
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.n.s0", "root.sg1.n.v.d1.s1", "root.sg1.n.v.d2.s2"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.d0.s0"));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.appendPathPattern(new PartialPath("root.**.s2"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        schemaRegion1.deleteTimeseriesInBlackList(patternTree);
        if (this.testParams.getTestModeName().equals("PBTree-PartialMemory") || this.testParams.getTestModeName().equals("PBTree-NonMemory")) {
            IMNodeFactory nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
            Thread.sleep(6000L);
            IDatabaseMNode sg1 = nodeFactory.createDatabaseMNode(null, "sg1", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg1.setFullPath("root.sg1");
            long size1 = sg1.estimateSize();
            if (size1 != schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage()) {
                Assert.assertEquals((Object)"PBTree-PartialMemory", (Object)this.testParams.getTestModeName());
                Assert.assertEquals((long)(size1 + (long)nodeFactory.createDeviceMNode((IMNode)((ICachedMNode)sg1.getAsMNode()), "n").estimateSize()), (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
                ReleaseFlushMonitor.getInstance().forceFlushAndRelease();
                Assert.assertEquals((long)size1, (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
            }
        }
        Assert.assertEquals((long)0L, (long)schemaRegion1.getSchemaRegionStatistics().getSchemaRegionId());
        this.checkPBTreeStatistics(engineStatistics);
    }

    @Test
    public void testMemoryStatistics2() throws Exception {
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.v.d0", "root.sg1.d1.v.s1", "root.sg1.d1.s2.v.t1"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Arrays.asList("root.sg2.d1.v.s3", "root.sg2.d2.v.s1", "root.sg2.d2.v.s2"));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((schemaRegion2.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        schemaRegion1.deleteTimeseriesInBlackList(patternTree);
        schemaRegion2.deleteTimeseriesInBlackList(patternTree);
        if (this.testParams.getTestModeName().equals("PBTree-PartialMemory") || this.testParams.getTestModeName().equals("PBTree-NonMemory")) {
            IMNodeFactory nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
            Thread.sleep(1000L);
            IDatabaseMNode sg1 = nodeFactory.createDatabaseMNode(null, "sg1", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg1.setFullPath("root.sg1");
            long size1 = sg1.estimateSize();
            Assert.assertEquals((long)size1, (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
            IDatabaseMNode sg2 = nodeFactory.createDatabaseMNode(null, "sg2", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg2.setFullPath("root.sg2");
            long size2 = sg2.estimateSize();
            Assert.assertEquals((long)size2, (long)schemaRegion2.getSchemaRegionStatistics().getRegionMemoryUsage());
            Assert.assertEquals((long)(size1 + size2), (long)engineStatistics.getMemoryUsage());
        } else {
            IMNodeFactory nodeFactory = this.testParams.getSchemaEngineMode().equals("Memory") ? MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory() : MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
            IDatabaseMNode sg1 = nodeFactory.createDatabaseMNode(null, "sg1", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg1.setFullPath("root.sg1");
            long size1 = sg1.estimateSize();
            IDeviceMNode tmp = nodeFactory.createDeviceMNode((IMNode)sg1, "v");
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "d0", (IMeasurementSchema)new MeasurementSchema("d0", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null);
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createInternalMNode(sg1.getAsMNode(), "d1");
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createInternalMNode((IMNode)tmp, "s2");
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)tmp, "v");
            size1 += (long)tmp.estimateSize();
            Assert.assertEquals((long)(size1 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "t1", (IMeasurementSchema)new MeasurementSchema("t1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize()), (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
            IDatabaseMNode sg2 = nodeFactory.createDatabaseMNode(null, "sg2", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg2.setFullPath("root.sg2");
            long size2 = sg2.estimateSize();
            tmp = nodeFactory.createInternalMNode((IMNode)sg2, "d1");
            size2 += (long)tmp.estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)tmp, "v");
            size2 += (long)tmp.estimateSize();
            size2 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "s3", (IMeasurementSchema)new MeasurementSchema("s3", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize();
            tmp = nodeFactory.createInternalMNode((IMNode)sg2, "d2");
            size2 += (long)tmp.estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)tmp, "v");
            size2 += (long)tmp.estimateSize();
            Assert.assertEquals((long)(size2 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "s2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize()), (long)schemaRegion2.getSchemaRegionStatistics().getRegionMemoryUsage());
            Assert.assertEquals((long)(size1 + size2), (long)engineStatistics.getMemoryUsage());
        }
        Assert.assertEquals((long)0L, (long)schemaRegion1.getSchemaRegionStatistics().getSchemaRegionId());
        Assert.assertEquals((long)1L, (long)schemaRegion2.getSchemaRegionStatistics().getSchemaRegionId());
        this.checkPBTreeStatistics(engineStatistics);
    }

    @Test
    public void testMemoryStatistics() throws Exception {
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.d0", "root.sg1.d1.s1", "root.sg1.d1.s2.t1"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Arrays.asList("root.sg2.d1.s3", "root.sg2.d2.s1", "root.sg2.d2.s2"));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((schemaRegion2.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        schemaRegion1.deleteTimeseriesInBlackList(patternTree);
        schemaRegion2.deleteTimeseriesInBlackList(patternTree);
        if (this.testParams.getTestModeName().equals("PBTree-PartialMemory") || this.testParams.getTestModeName().equals("PBTree-NonMemory")) {
            IMNodeFactory nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
            Thread.sleep(1000L);
            IMNode sg1 = nodeFactory.createDatabaseDeviceMNode(null, "sg1", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg1.setFullPath("root.sg1");
            long size1 = sg1.estimateSize();
            if ((long)sg1.estimateSize() != schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage()) {
                Assert.assertEquals((Object)"PBTree-PartialMemory", (Object)this.testParams.getTestModeName());
                long d0ExistSize = size1 + (long)nodeFactory.createMeasurementMNode(sg1.getAsDeviceMNode(), "d0", (IMeasurementSchema)new MeasurementSchema("d0", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize();
                long d1ExistSize = size1 + (long)((ICachedMNode)nodeFactory.createInternalMNode((IMNode)((ICachedMNode)sg1.getAsMNode()), "d1")).estimateSize();
                Assert.assertTrue((d0ExistSize == schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage() || d1ExistSize == schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage() ? 1 : 0) != 0);
                ReleaseFlushMonitor.getInstance().forceFlushAndRelease();
                Thread.sleep(1000L);
                Assert.assertEquals((long)size1, (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
            }
            IDatabaseMNode sg2 = nodeFactory.createDatabaseMNode(null, "sg2", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg2.setFullPath("root.sg2");
            long size2 = sg2.estimateSize();
            Assert.assertEquals((long)size2, (long)schemaRegion2.getSchemaRegionStatistics().getRegionMemoryUsage());
            Assert.assertEquals((long)(size1 + size2), (long)engineStatistics.getMemoryUsage());
        } else {
            IMNodeFactory nodeFactory = this.testParams.getSchemaEngineMode().equals("Memory") ? MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory() : MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
            IMNode sg1 = nodeFactory.createDatabaseDeviceMNode(null, "sg1", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg1.setFullPath("root.sg1");
            long size1 = sg1.estimateSize();
            IMeasurementMNode tmp = nodeFactory.createMeasurementMNode(sg1.getAsDeviceMNode(), "d0", (IMeasurementSchema)new MeasurementSchema("d0", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null);
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createInternalMNode(sg1.getAsMNode(), "d1");
            size1 += (long)tmp.estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)tmp, "s2");
            size1 += (long)tmp.estimateSize();
            Assert.assertEquals((long)(size1 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "t1", (IMeasurementSchema)new MeasurementSchema("t1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize()), (long)schemaRegion1.getSchemaRegionStatistics().getRegionMemoryUsage());
            IDatabaseMNode sg2 = nodeFactory.createDatabaseMNode(null, "sg2", CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            sg2.setFullPath("root.sg2");
            long size2 = sg2.estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)sg2, "d1");
            size2 += (long)tmp.estimateSize();
            size2 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "s3", (IMeasurementSchema)new MeasurementSchema("s3", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize();
            tmp = nodeFactory.createDeviceMNode((IMNode)sg2, "d2");
            size2 += (long)tmp.estimateSize();
            Assert.assertEquals((long)(size2 += (long)nodeFactory.createMeasurementMNode(tmp.getAsDeviceMNode(), "s2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY), null).estimateSize()), (long)schemaRegion2.getSchemaRegionStatistics().getRegionMemoryUsage());
            Assert.assertEquals((long)(size1 + size2), (long)engineStatistics.getMemoryUsage());
        }
        Assert.assertEquals((long)0L, (long)schemaRegion1.getSchemaRegionStatistics().getSchemaRegionId());
        Assert.assertEquals((long)1L, (long)schemaRegion2.getSchemaRegionStatistics().getSchemaRegionId());
        this.checkPBTreeStatistics(engineStatistics);
    }

    private void checkPBTreeStatistics(ISchemaEngineStatistics engineStatistics) {
        if (engineStatistics instanceof CachedSchemaEngineStatistics) {
            CachedSchemaEngineStatistics cachedEngineStatistics = (CachedSchemaEngineStatistics)engineStatistics;
            Assert.assertEquals((long)cachedEngineStatistics.getMemoryUsage(), (long)(cachedEngineStatistics.getPinnedMemorySize() + cachedEngineStatistics.getUnpinnedMemorySize()));
        }
    }

    @Test
    public void testSeriesNumStatistics() throws Exception {
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.d0", "root.sg1.d1.s1", "root.sg1.d1.s2.t1"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Arrays.asList("root.sg2.d1.s3", "root.sg2.d2.s1", "root.sg2.d2.s2"));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((schemaRegion2.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        schemaRegion1.deleteTimeseriesInBlackList(patternTree);
        schemaRegion2.deleteTimeseriesInBlackList(patternTree);
        Assert.assertEquals((long)2L, (long)schemaRegion1.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)2L, (long)schemaRegion2.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)4L, (long)engineStatistics.getTotalSeriesNumber());
    }

    @Test
    public void testDeviceNumStatistics() throws Exception {
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.d0", "root.sg1.d1.s1", "root.sg1.d1.s2.t1"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Arrays.asList("root.sg2.d1.s3", "root.sg2.d2.s1", "root.sg2.d2.s2"));
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Collections.singletonList("root.sg2.s1"));
        Assert.assertEquals((long)3L, (long)schemaRegion1.getSchemaRegionStatistics().getDevicesNumber());
        Assert.assertEquals((long)3L, (long)schemaRegion2.getSchemaRegionStatistics().getDevicesNumber());
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((schemaRegion2.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
        schemaRegion1.deleteTimeseriesInBlackList(patternTree);
        schemaRegion2.deleteTimeseriesInBlackList(patternTree);
        Assert.assertEquals((long)2L, (long)schemaRegion1.getSchemaRegionStatistics().getDevicesNumber());
        Assert.assertEquals((long)2L, (long)schemaRegion2.getSchemaRegionStatistics().getDevicesNumber());
    }

    @Test
    public void testPBTreeNodeStatistics() throws Exception {
        if (this.testParams.getSchemaEngineMode().equals("PBTree")) {
            ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
            ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
            CachedSchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics().getAsCachedSchemaEngineStatistics();
            SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion1, Arrays.asList("root.sg1.d0", "root.sg1.d1.s1", "root.sg1.d1.s2.t1"));
            SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion2, Arrays.asList("root.sg2.d1.s3", "root.sg2.d2.s1", "root.sg2.d2.s2"));
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(new PartialPath("root.**.s1"));
            patternTree.constructTree();
            Assert.assertTrue((schemaRegion1.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
            Assert.assertTrue((schemaRegion2.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
            schemaRegion1.deleteTimeseriesInBlackList(patternTree);
            schemaRegion2.deleteTimeseriesInBlackList(patternTree);
            Thread.sleep(1000L);
            CachedSchemaRegionStatistics cachedRegionStatistics1 = schemaRegion1.getSchemaRegionStatistics().getAsCachedSchemaRegionStatistics();
            CachedSchemaRegionStatistics cachedRegionStatistics2 = schemaRegion2.getSchemaRegionStatistics().getAsCachedSchemaRegionStatistics();
            if (this.testParams.getCachedMNodeSize() > 3) {
                Assert.assertEquals((long)1L, (long)cachedRegionStatistics1.getPinnedMNodeNum());
                Assert.assertEquals((long)4L, (long)cachedRegionStatistics1.getUnpinnedMNodeNum());
                Assert.assertEquals((long)1L, (long)cachedRegionStatistics2.getPinnedMNodeNum());
                Assert.assertEquals((long)4L, (long)cachedRegionStatistics2.getUnpinnedMNodeNum());
            } else {
                Assert.assertEquals((long)1L, (long)cachedRegionStatistics1.getPinnedMNodeNum());
                if (0L != cachedRegionStatistics1.getUnpinnedMNodeNum()) {
                    Assert.assertEquals((Object)"PBTree-PartialMemory", (Object)this.testParams.getTestModeName());
                    ReleaseFlushMonitor.getInstance().forceFlushAndRelease();
                    Thread.sleep(1000L);
                    Assert.assertEquals((long)0L, (long)cachedRegionStatistics1.getUnpinnedMNodeNum());
                }
                Assert.assertEquals((long)1L, (long)cachedRegionStatistics2.getPinnedMNodeNum());
                Assert.assertEquals((long)0L, (long)cachedRegionStatistics2.getUnpinnedMNodeNum());
            }
            Assert.assertEquals((long)(cachedRegionStatistics1.getPinnedMNodeNum() + cachedRegionStatistics2.getPinnedMNodeNum()), (long)engineStatistics.getPinnedMNodeNum());
            Assert.assertEquals((long)(cachedRegionStatistics1.getUnpinnedMNodeNum() + cachedRegionStatistics2.getUnpinnedMNodeNum()), (long)engineStatistics.getUnpinnedMNodeNum());
            Assert.assertEquals((long)(cachedRegionStatistics1.getPinnedMemorySize() + cachedRegionStatistics2.getPinnedMemorySize()), (long)engineStatistics.getPinnedMemorySize());
            Assert.assertEquals((long)(cachedRegionStatistics1.getUnpinnedMemorySize() + cachedRegionStatistics2.getUnpinnedMemorySize()), (long)engineStatistics.getUnpinnedMemorySize());
        }
    }

    @Test
    public void testTemplateStatistics() throws Exception {
        ISchemaEngineStatistics engineStatistics = SchemaEngine.getInstance().getSchemaEngineStatistics();
        ISchemaRegion schemaRegion1 = this.getSchemaRegion("root.sg1", 0);
        ISchemaRegion schemaRegion2 = this.getSchemaRegion("root.sg2", 1);
        schemaRegion1.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        Template template1 = new Template("t1", Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY, CompressionType.SNAPPY));
        template1.setId(1);
        Template template2 = new Template("t2", Arrays.asList("temperature", "status"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template2.setId(2);
        ClusterTemplateManager.getInstance().putTemplate(template1);
        ClusterTemplateManager.getInstance().putTemplate(template2);
        for (int i = 0; i < 4; ++i) {
            schemaRegion1.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg1.d" + i), (int)2, (int)1), template1);
            schemaRegion2.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg2.d" + i), (int)2, (int)1), template1);
        }
        schemaRegion2.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg2.wf01.wt02"), (int)3, (int)2), template2);
        Assert.assertEquals((long)26L, (long)engineStatistics.getTemplateSeriesNumber());
        Assert.assertEquals((long)27L, (long)engineStatistics.getTotalSeriesNumber());
        Assert.assertEquals((long)13L, (long)schemaRegion1.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)12L, (long)schemaRegion1.getSchemaRegionStatistics().getTemplateSeriesNumber());
        Assert.assertEquals((long)14L, (long)schemaRegion2.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)14L, (long)schemaRegion2.getSchemaRegionStatistics().getTemplateSeriesNumber());
        HashMap<PartialPath, List<Integer>> allDeviceTemplateMap = new HashMap<PartialPath, List<Integer>>();
        allDeviceTemplateMap.put(new PartialPath("root.**.d0"), Arrays.asList(1, 2));
        schemaRegion1.constructSchemaBlackListWithTemplate(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(allDeviceTemplateMap));
        schemaRegion2.constructSchemaBlackListWithTemplate(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(allDeviceTemplateMap));
        schemaRegion1.deactivateTemplateInBlackList(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(allDeviceTemplateMap));
        schemaRegion2.deactivateTemplateInBlackList(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(allDeviceTemplateMap));
        Assert.assertEquals((long)20L, (long)engineStatistics.getTemplateSeriesNumber());
        Assert.assertEquals((long)21L, (long)engineStatistics.getTotalSeriesNumber());
        Assert.assertEquals((long)10L, (long)schemaRegion1.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)9L, (long)schemaRegion1.getSchemaRegionStatistics().getTemplateSeriesNumber());
        Assert.assertEquals((long)11L, (long)schemaRegion2.getSchemaRegionStatistics().getSeriesNumber(true));
        Assert.assertEquals((long)11L, (long)schemaRegion2.getSchemaRegionStatistics().getTemplateSeriesNumber());
    }
}

