/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowTimeSeriesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaRegionTestUtil {
    public static void createTimeseries(ISchemaRegion schemaRegion, String fullPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String alias) throws MetadataException {
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath(fullPath), (TSDataType)dataType, (TSEncoding)encoding, (CompressionType)compressor, props, tags, attributes, (String)alias), -1L);
    }

    public static void createTimeseries(ISchemaRegion schemaRegion, List<String> fullPaths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> props, List<Map<String, String>> tags, List<Map<String, String>> attributes, List<String> alias) throws MetadataException {
        for (int i = 0; i < fullPaths.size(); ++i) {
            schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath(fullPaths.get(i)), (TSDataType)dataTypes.get(i), (TSEncoding)encodings.get(i), (CompressionType)compressors.get(i), props == null ? null : props.get(i), tags == null ? null : tags.get(i), attributes == null ? null : attributes.get(i), alias == null ? null : alias.get(i)), -1L);
        }
    }

    public static void createAlignedTimeseries(ISchemaRegion schemaRegion, String devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> tags, List<Map<String, String>> attributes, List<String> alias) throws MetadataException {
        schemaRegion.createAlignedTimeSeries(SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan((PartialPath)new PartialPath(devicePath), measurements, dataTypes, encodings, compressors, alias, tags, attributes));
    }

    public static void createSimpleTimeSeriesInt64(ISchemaRegion schemaRegion, String path) throws Exception {
        SchemaRegionTestUtil.createTimeseries(schemaRegion, path, TSDataType.INT64, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null);
    }

    public static void createSimpleTimeseriesByList(ISchemaRegion schemaRegion, List<String> pathList) throws Exception {
        for (String path : pathList) {
            SchemaRegionTestUtil.createSimpleTimeSeriesInt64(schemaRegion, path);
        }
    }

    public static long getAllTimeseriesCount(ISchemaRegion schemaRegion, PartialPath pathPattern, Map<Integer, Template> templateMap, boolean isPrefixMatch) {
        long l;
        block9: {
            ISchemaReader timeSeriesReader = schemaRegion.getTimeSeriesReader(SchemaRegionReadPlanFactory.getShowTimeSeriesPlan((PartialPath)pathPattern, templateMap, (long)0L, (long)0L, (boolean)isPrefixMatch, null, (boolean)false, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));
            try {
                long count = 0L;
                while (timeSeriesReader.hasNext()) {
                    timeSeriesReader.next();
                    ++count;
                }
                l = count;
                if (timeSeriesReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (timeSeriesReader != null) {
                        try {
                            timeSeriesReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            timeSeriesReader.close();
        }
        return l;
    }

    public static long getDevicesNum(ISchemaRegion schemaRegion, PartialPath pathPattern, boolean isPrefixMatch) {
        long l;
        block9: {
            ISchemaReader deviceReader = schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan((PartialPath)pathPattern, (long)0L, (long)0L, (boolean)isPrefixMatch, null, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));
            try {
                long count = 0L;
                while (deviceReader.hasNext()) {
                    deviceReader.next();
                    ++count;
                }
                l = count;
                if (deviceReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (deviceReader != null) {
                        try {
                            deviceReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            deviceReader.close();
        }
        return l;
    }

    public static Map<PartialPath, Long> getMeasurementCountGroupByLevel(ISchemaRegion schemaRegion, PartialPath pathPattern, int level, boolean isPrefixMatch) {
        HashMap<PartialPath, Long> hashMap;
        block9: {
            ISchemaReader timeSeriesReader = schemaRegion.getTimeSeriesReader(SchemaRegionReadPlanFactory.getShowTimeSeriesPlan((PartialPath)pathPattern, null, (long)0L, (long)0L, (boolean)isPrefixMatch, null, (boolean)false, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));
            try {
                HashMap<PartialPath, Long> countMap = new HashMap<PartialPath, Long>();
                while (timeSeriesReader.hasNext()) {
                    ITimeSeriesSchemaInfo timeSeriesSchemaInfo = (ITimeSeriesSchemaInfo)timeSeriesReader.next();
                    PartialPath path = timeSeriesSchemaInfo.getPartialPath();
                    if (path.getNodeLength() < level) continue;
                    countMap.compute(new PartialPath(Arrays.copyOf(path.getNodes(), level + 1)), (k, v) -> {
                        if (v == null) {
                            return 1L;
                        }
                        return v + 1L;
                    });
                }
                hashMap = countMap;
                if (timeSeriesReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (timeSeriesReader != null) {
                        try {
                            timeSeriesReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            timeSeriesReader.close();
        }
        return hashMap;
    }

    public static List<String> getPathsUsingTemplate(ISchemaRegion schemaRegion, PartialPath pathPattern, int templateId) {
        ArrayList<String> result = new ArrayList<String>();
        try (ISchemaReader deviceReader = schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan((PartialPath)pathPattern, (int)0, (int)0, (boolean)false, (int)templateId, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));){
            while (deviceReader.hasNext()) {
                result.add(((IDeviceSchemaInfo)deviceReader.next()).getFullPath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<PartialPath> getNodesListInGivenLevel(ISchemaRegion schemaRegion, PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (ISchemaReader nodeReader = schemaRegion.getNodeReader(SchemaRegionReadPlanFactory.getShowNodesPlan((PartialPath)pathPattern, (int)nodeLevel, (boolean)isPrefixMatch, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));){
            while (nodeReader.hasNext()) {
                result.add(((INodeSchemaInfo)nodeReader.next()).getPartialPath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Set<INodeSchemaInfo> getChildNodePathInNextLevel(ISchemaRegion schemaRegion, PartialPath pathPattern) {
        HashSet<INodeSchemaInfo> result = new HashSet<INodeSchemaInfo>();
        try (ISchemaReader nodeReader = schemaRegion.getNodeReader(SchemaRegionReadPlanFactory.getShowNodesPlan((PartialPath)pathPattern.concatNode("*"), (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));){
            while (nodeReader.hasNext()) {
                result.add((INodeSchemaInfo)nodeReader.next());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<ITimeSeriesSchemaInfo> showTimeseries(ISchemaRegion schemaRegion, PartialPath path) {
        return SchemaRegionTestUtil.showTimeseries(schemaRegion, path, Collections.emptyMap(), 0L, 0L, false, null, false);
    }

    public static List<ITimeSeriesSchemaInfo> showTimeseries(ISchemaRegion schemaRegion, PartialPath path, Map<Integer, Template> relatedTemplate) {
        return SchemaRegionTestUtil.showTimeseries(schemaRegion, path, relatedTemplate, 0L, 0L, false, null, false);
    }

    public static List<ITimeSeriesSchemaInfo> showTimeseries(ISchemaRegion schemaRegion, PartialPath path, boolean isContains, String tagKey, String tagValue) {
        return SchemaRegionTestUtil.showTimeseries(schemaRegion, path, Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createTagFilter((String)tagKey, (String)tagValue, (boolean)isContains), false);
    }

    public static List<ITimeSeriesSchemaInfo> showTimeseries(ISchemaRegion schemaRegion, PartialPath path, Map<Integer, Template> relatedTemplate, long limit, long offset, boolean isPrefixMatch, SchemaFilter schemaFilter, boolean needViewDetail) {
        ArrayList<ITimeSeriesSchemaInfo> result = new ArrayList<ITimeSeriesSchemaInfo>();
        try (ISchemaReader reader = schemaRegion.getTimeSeriesReader(SchemaRegionReadPlanFactory.getShowTimeSeriesPlan((PartialPath)path, relatedTemplate, (long)limit, (long)offset, (boolean)isPrefixMatch, (SchemaFilter)schemaFilter, (boolean)needViewDetail, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));){
            while (reader.hasNext()) {
                ITimeSeriesSchemaInfo timeSeriesSchemaInfo = (ITimeSeriesSchemaInfo)reader.next();
                result.add((ITimeSeriesSchemaInfo)new ShowTimeSeriesResult(timeSeriesSchemaInfo.getFullPath(), timeSeriesSchemaInfo.getAlias(), timeSeriesSchemaInfo.getSchema(), timeSeriesSchemaInfo.getTags(), timeSeriesSchemaInfo.getAttributes(), timeSeriesSchemaInfo.isUnderAlignedDevice()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<IDeviceSchemaInfo> getMatchedDevices(ISchemaRegion schemaRegion, PartialPath path) {
        return SchemaRegionTestUtil.getMatchedDevices(schemaRegion, path, 0, 0, false);
    }

    public static List<IDeviceSchemaInfo> getMatchedDevices(ISchemaRegion schemaRegion, PartialPath path, int limit, int offset, boolean isPrefixMatch) {
        return SchemaRegionTestUtil.getMatchedDevices(schemaRegion, path, limit, offset, isPrefixMatch, null);
    }

    public static List<IDeviceSchemaInfo> getMatchedDevices(ISchemaRegion schemaRegion, PartialPath path, int limit, int offset, boolean isPrefixMatch, SchemaFilter filter) {
        ArrayList<IDeviceSchemaInfo> result = new ArrayList<IDeviceSchemaInfo>();
        try (ISchemaReader reader = schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan((PartialPath)path, (long)limit, (long)offset, (boolean)isPrefixMatch, (SchemaFilter)filter, (PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE));){
            while (reader.hasNext()) {
                result.add((IDeviceSchemaInfo)reader.next());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static long deleteTimeSeries(ISchemaRegion schemaRegion, PartialPath pathPattern) throws MetadataException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(pathPattern);
        patternTree.constructTree();
        long num = schemaRegion.constructSchemaBlackList(patternTree);
        schemaRegion.deleteTimeseriesInBlackList(patternTree);
        return num;
    }
}

