/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.metadata.schemaRegion.SchemaRegionTestUtil;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegionTemplateTest
extends AbstractSchemaRegionTest {
    public SchemaRegionTemplateTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    @Test
    public void testFetchNestedTemplateDevice() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.d1"), (int)2, (int)templateId), template);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.d1.GPS"), (int)3, (int)templateId), template);
        ClusterSchemaTree schemaTree = schemaRegion.fetchSchema(SchemaConstant.ALL_MATCH_SCOPE, Collections.singletonMap(templateId, template), true, true);
        Assert.assertEquals((long)2L, (long)schemaTree.getAllDevices().size());
        for (DeviceSchemaInfo deviceSchemaInfo : schemaTree.getAllDevices()) {
            Assert.assertEquals((long)templateId, (long)deviceSchemaInfo.getTemplateId());
        }
    }

    @Test
    public void testActivateSchemaTemplate() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.wf01.wt01"), (int)3, (int)templateId), template);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.wf02"), (int)2, (int)templateId), template);
        HashSet<String> expectedPaths = new HashSet<String>(Arrays.asList("root.sg.wf01.wt01", "root.sg.wf02"));
        HashSet<String> pathsUsingTemplate = new HashSet<String>(SchemaRegionTestUtil.getPathsUsingTemplate(schemaRegion, new PartialPath("root.**"), templateId));
        Assert.assertEquals(expectedPaths, pathsUsingTemplate);
        PathPatternTree allPatternTree = new PathPatternTree();
        allPatternTree.appendPathPattern(new PartialPath("root.**"));
        allPatternTree.constructTree();
        Assert.assertEquals((long)2L, (long)schemaRegion.countPathsUsingTemplate(templateId, allPatternTree));
        PathPatternTree wf01PatternTree = new PathPatternTree();
        wf01PatternTree.appendPathPattern(new PartialPath("root.sg.wf01.*"));
        wf01PatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, wf01PatternTree));
        Assert.assertEquals((Object)"root.sg.wf01.wt01", (Object)SchemaRegionTestUtil.getPathsUsingTemplate(schemaRegion, new PartialPath("root.sg.wf01.*"), templateId).get(0));
        PathPatternTree wf02PatternTree = new PathPatternTree();
        wf02PatternTree.appendPathPattern(new PartialPath("root.sg.wf02"));
        wf02PatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, wf02PatternTree));
        Assert.assertEquals((Object)"root.sg.wf02", (Object)SchemaRegionTestUtil.getPathsUsingTemplate(schemaRegion, new PartialPath("root.sg.wf02"), templateId).get(0));
    }

    @Test
    public void testDeactivateTemplate() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.wf01.wt01"), (int)3, (int)templateId), template);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.wf02"), (int)2, (int)templateId), template);
        HashMap<PartialPath, List<Integer>> allDeviceTemplateMap = new HashMap<PartialPath, List<Integer>>();
        allDeviceTemplateMap.put(new PartialPath("root.**"), Collections.singletonList(templateId));
        schemaRegion.constructSchemaBlackListWithTemplate(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(allDeviceTemplateMap));
        HashMap<PartialPath, List<Integer>> wf02TemplateMap = new HashMap<PartialPath, List<Integer>>();
        wf02TemplateMap.put(new PartialPath("root.sg.wf02"), Collections.singletonList(templateId));
        schemaRegion.rollbackSchemaBlackListWithTemplate(SchemaRegionWritePlanFactory.getRollbackPreDeactivateTemplatePlan(wf02TemplateMap));
        schemaRegion.deactivateTemplateInBlackList(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(allDeviceTemplateMap));
        List<String> expectedPaths = Collections.singletonList("root.sg.wf02");
        List<String> pathsUsingTemplate = SchemaRegionTestUtil.getPathsUsingTemplate(schemaRegion, new PartialPath("root.**"), templateId);
        Assert.assertEquals(expectedPaths, pathsUsingTemplate);
        PathPatternTree allPatternTree = new PathPatternTree();
        allPatternTree.appendPathPattern(new PartialPath("root.**"));
        allPatternTree.constructTree();
        Assert.assertEquals((long)1L, (long)schemaRegion.countPathsUsingTemplate(templateId, allPatternTree));
    }

    @Test
    public void testFetchSchemaWithTemplate() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.sg.wf01.wt01.status", "root.sg.wf01.wt01.temperature"));
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template.setId(templateId);
        ClusterTemplateManager.getInstance().putTemplate(template);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.wf02"), (int)2, (int)templateId), template);
        Map<Integer, Template> templateMap = Collections.singletonMap(templateId, template);
        List<String> expectedTimeseries = Arrays.asList("root.sg.wf01.wt01.status", "root.sg.wf01.wt01.temperature", "root.sg.wf02.s1", "root.sg.wf02.s2");
        ClusterSchemaTree schemaTree = schemaRegion.fetchSchema(SchemaConstant.ALL_MATCH_SCOPE, templateMap, true, true);
        schemaTree.setTemplateMap(templateMap);
        List schemas = (List)schemaTree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left;
        Assert.assertEquals((long)expectedTimeseries.size(), (long)schemas.size());
        schemas.sort(Comparator.comparing(PartialPath::getFullPath));
        for (int i = 0; i < schemas.size(); ++i) {
            Assert.assertEquals((Object)expectedTimeseries.get(i), (Object)((MeasurementPath)schemas.get(i)).getFullPath());
        }
        List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), templateMap);
        result.sort(Comparator.comparing(ISchemaInfo::getFullPath));
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertEquals((Object)expectedTimeseries.get(i), (Object)result.get(i).getFullPath());
        }
    }

    @Test
    public void testDeleteSchemaWithTemplate() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.db", 0);
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template.setId(templateId);
        ClusterTemplateManager.getInstance().putTemplate(template);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.db.d1"), (int)3, (int)templateId), template);
        Assert.assertEquals((long)0L, (long)SchemaRegionTestUtil.deleteTimeSeries(schemaRegion, new PartialPath("root.db.d1.s1")));
        Assert.assertEquals((long)0L, (long)SchemaRegionTestUtil.deleteTimeSeries(schemaRegion, new PartialPath("root.db.d1.s3")));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(new PartialPath("root.db.d1.s1"));
        ClusterSchemaTree schemaTree = schemaRegion.fetchSchema(patternTree, Collections.singletonMap(templateId, template), false, true);
        schemaTree.setTemplateMap(Collections.singletonMap(templateId, template));
        Assert.assertEquals((long)1L, (long)((List)schemaTree.searchMeasurementPaths((PartialPath)new PartialPath((String)"root.db.d1.s1")).left).size());
        patternTree = new PathPatternTree();
        patternTree.appendFullPath(new PartialPath("root.db.d1.s3"));
        schemaTree = schemaRegion.fetchSchema(patternTree, Collections.singletonMap(templateId, template), false, true);
        schemaTree.setTemplateMap(Collections.singletonMap(templateId, template));
        Assert.assertEquals((long)0L, (long)((List)schemaTree.searchMeasurementPaths((PartialPath)new PartialPath((String)"root.db.d1.s3")).left).size());
    }
}

