/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.Arrays;
import java.util.Collections;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaRegionSimpleRecoverTest
extends AbstractSchemaRegionTest {
    private String schemaRegionConsensusProtocolClass;

    public SchemaRegionSimpleRecoverTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.schemaRegionConsensusProtocolClass = IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass();
        IoTDBDescriptor.getInstance().getConfig().setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.simple.SimpleConsensus");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        IoTDBDescriptor.getInstance().getConfig().setSchemaRegionConsensusProtocolClass(this.schemaRegionConsensusProtocolClass);
    }

    @Test
    public void testRecoverWithAlignedTemplate() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        int templateId = 1;
        Template template = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY), true);
        template.setId(templateId);
        schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.d1"), (int)2, (int)templateId), template);
        ClusterSchemaTree schemaTree = schemaRegion.fetchSchema(SchemaConstant.ALL_MATCH_SCOPE, Collections.singletonMap(templateId, template), true, true);
        Assert.assertTrue((boolean)((DeviceSchemaInfo)schemaTree.getAllDevices().get(0)).isAligned());
        this.simulateRestart();
        schemaRegion = this.getSchemaRegion("root.sg", 0);
        schemaTree = schemaRegion.fetchSchema(SchemaConstant.ALL_MATCH_SCOPE, Collections.singletonMap(templateId, template), true, true);
        Assert.assertTrue((boolean)((DeviceSchemaInfo)schemaTree.getAllDevices().get(0)).isAligned());
    }
}

