/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.metadata.schemaRegion.SchemaRegionTestUtil;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaRegionManagementTest
extends AbstractSchemaRegionTest {
    IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public SchemaRegionManagementTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRatisModeSnapshot() throws Exception {
        String schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        try {
            ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
            File mLogFile = SystemFileFactory.INSTANCE.getFile(schemaRegion.getDatabaseFullPath() + File.separator + schemaRegion.getSchemaRegionId().getId(), "mlog.bin");
            Assert.assertFalse((boolean)mLogFile.exists());
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag-key", "tag-value");
            schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.d1.s1"), (TSDataType)TSDataType.INT32, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
            Template template = this.generateTemplate();
            schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.d2"), (int)1, (int)template.getId()), template);
            File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
            snapshotDir.mkdir();
            schemaRegion.createSnapshot(snapshotDir);
            schemaRegion.loadSnapshot(snapshotDir);
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.sg.**"), false, "tag-key", "tag-value");
            ITimeSeriesSchemaInfo seriesResult = result.get(0);
            Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)seriesResult.getFullPath());
            Map resultTagMap = seriesResult.getTags();
            Assert.assertEquals((long)1L, (long)resultTagMap.size());
            Assert.assertEquals((Object)"tag-value", resultTagMap.get("tag-key"));
            this.simulateRestart();
            ISchemaRegion newSchemaRegion = this.getSchemaRegion("root.sg", 0);
            newSchemaRegion.loadSnapshot(snapshotDir);
            result = SchemaRegionTestUtil.showTimeseries(newSchemaRegion, new PartialPath("root.sg.**"), false, "tag-key", "tag-value");
            seriesResult = result.get(0);
            Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)seriesResult.getFullPath());
            resultTagMap = seriesResult.getTags();
            Assert.assertEquals((long)1L, (long)resultTagMap.size());
            Assert.assertEquals((Object)"tag-value", resultTagMap.get("tag-key"));
            result = SchemaRegionTestUtil.showTimeseries(newSchemaRegion, new PartialPath("root.sg.*.s1"), Collections.singletonMap(template.getId(), template));
            result.sort(Comparator.comparing(ISchemaInfo::getFullPath));
            Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)result.get(0).getFullPath());
            Assert.assertEquals((Object)new PartialPath("root.sg.d2.s1").getFullPath(), (Object)result.get(1).getFullPath());
        }
        finally {
            this.config.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
    }

    private Template generateTemplate() throws IllegalPathException {
        Template template = new Template("t1", Collections.singletonList("s1"), Collections.singletonList(TSDataType.INT32), Collections.singletonList(TSEncoding.PLAIN), Collections.singletonList(CompressionType.GZIP));
        template.setId(1);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptySnapshot() throws Exception {
        String schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        try {
            ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
            File mLogFile = SystemFileFactory.INSTANCE.getFile(schemaRegion.getDatabaseFullPath() + File.separator + schemaRegion.getSchemaRegionId().getId(), "mlog.bin");
            Assert.assertFalse((boolean)mLogFile.exists());
            File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
            snapshotDir.mkdir();
            schemaRegion.createSnapshot(snapshotDir);
            schemaRegion.loadSnapshot(snapshotDir);
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.sg.**"), false, "tag-key", "tag-value");
            Assert.assertEquals((long)0L, (long)result.size());
            this.simulateRestart();
            ISchemaRegion newSchemaRegion = this.getSchemaRegion("root.sg", 0);
            newSchemaRegion.loadSnapshot(snapshotDir);
            result = SchemaRegionTestUtil.showTimeseries(newSchemaRegion, new PartialPath("root.sg.**"), false, "tag-key", "tag-value");
            Assert.assertEquals((long)0L, (long)result.size());
        }
        finally {
            this.config.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testSnapshotPerformance() throws Exception {
        String schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        try {
            ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag-key", "tag-value");
            long time = System.currentTimeMillis();
            for (int i = 0; i < 1000; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.d" + i + ".s" + j), (TSDataType)TSDataType.INT32, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
                }
            }
            System.out.println("Timeseries creation costs " + (System.currentTimeMillis() - time) + "ms.");
            File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
            snapshotDir.mkdir();
            schemaRegion.createSnapshot(snapshotDir);
            schemaRegion.loadSnapshot(snapshotDir);
        }
        finally {
            this.config.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
    }
}

