/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.filter.SchemaFilterFactory;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.metadata.schemaRegion.SchemaRegionTestUtil;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowNodesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaRegionBasicTest
extends AbstractSchemaRegionTest {
    public SchemaRegionBasicTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    @Test
    @Ignore
    public void testFetchSchemaPerfomance() throws Exception {
        System.out.println(this.testParams.getTestModeName());
        int deviceNum = 1000;
        int measurementNum = 40;
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        for (int i = 0; i < deviceNum; ++i) {
            for (int j = 0; j < measurementNum; ++j) {
                schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.d" + i + ".s" + j), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
            }
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (int i = 0; i < deviceNum; ++i) {
            for (int j = 0; j < measurementNum; ++j) {
                patternTree.appendFullPath(new PartialPath("root.sg.d" + i + ".s" + j));
            }
        }
        patternTree.constructTree();
        schemaRegion.fetchSchema(patternTree, Collections.EMPTY_MAP, false, true);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            schemaRegion.fetchSchema(patternTree, Collections.EMPTY_MAP, false, true);
        }
        System.out.println("cost time: " + (System.currentTimeMillis() - startTime));
    }

    @Test
    public void testFetchSchema() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.temperature"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.GZIP, null, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, (String)"temp"), -1L);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.wt01.*"));
        patternTree.constructTree();
        ClusterSchemaTree schemas = schemaRegion.fetchSchema(patternTree, Collections.EMPTY_MAP, true, true);
        List measurementPaths = (List)schemas.searchMeasurementPaths((PartialPath)new PartialPath((String)"root.sg.wf01.wt01.*")).left;
        Assert.assertEquals((long)measurementPaths.size(), (long)2L);
        for (MeasurementPath measurementPath : measurementPaths) {
            if (measurementPath.getFullPath().equals("root.sg.wf01.wt01.status")) {
                Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)measurementPath.getMeasurementAlias()));
                Assert.assertEquals((long)0L, (long)measurementPath.getTagMap().size());
                Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)measurementPath.getMeasurementSchema().getType());
                Assert.assertEquals((Object)TSEncoding.PLAIN, (Object)measurementPath.getMeasurementSchema().getEncodingType());
                Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)measurementPath.getMeasurementSchema().getCompressor());
                continue;
            }
            if (measurementPath.getFullPath().equals("root.sg.wf01.wt01.temperature")) {
                Assert.assertEquals((Object)"", (Object)measurementPath.getMeasurementAlias());
                Assert.assertEquals((long)2L, (long)measurementPath.getTagMap().size());
                Assert.assertEquals((Object)TSDataType.FLOAT, (Object)measurementPath.getMeasurementSchema().getType());
                Assert.assertEquals((Object)TSEncoding.RLE, (Object)measurementPath.getMeasurementSchema().getEncodingType());
                Assert.assertEquals((Object)CompressionType.GZIP, (Object)measurementPath.getMeasurementSchema().getCompressor());
                continue;
            }
            Assert.fail((String)("Unexpected MeasurementPath " + measurementPath));
        }
        patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.wt01.temp"));
        patternTree.constructTree();
        schemas = schemaRegion.fetchSchema(patternTree, Collections.EMPTY_MAP, false, true);
        measurementPaths = (List)schemas.searchMeasurementPaths((PartialPath)new PartialPath((String)"root.sg.wf01.wt01.temp")).left;
        Assert.assertEquals((long)measurementPaths.size(), (long)1L);
        Assert.assertEquals((Object)"root.sg.wf01.wt01.temperature", (Object)((MeasurementPath)measurementPaths.get(0)).getFullPath());
        Assert.assertEquals((Object)"temp", (Object)((MeasurementPath)measurementPaths.get(0)).getMeasurementAlias());
        Assert.assertNull((Object)((MeasurementPath)measurementPaths.get(0)).getTagMap());
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)((MeasurementPath)measurementPaths.get(0)).getMeasurementSchema().getType());
        Assert.assertEquals((Object)TSEncoding.RLE, (Object)((MeasurementPath)measurementPaths.get(0)).getMeasurementSchema().getEncodingType());
        Assert.assertEquals((Object)CompressionType.GZIP, (Object)((MeasurementPath)measurementPaths.get(0)).getMeasurementSchema().getCompressor());
    }

    @Test
    public void testCreateAlignedTimeseries() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        schemaRegion.createAlignedTimeSeries(SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf02.wt01"), Arrays.asList("temperature", "status"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY), null, null, null));
        Map checkRes = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf02.wt01"), Arrays.asList("temperature", "status"), null);
        Assert.assertEquals((long)2L, (long)checkRes.size());
        Assert.assertTrue((boolean)(checkRes.get(0) instanceof MeasurementAlreadyExistException));
        Assert.assertTrue((boolean)(checkRes.get(1) instanceof MeasurementAlreadyExistException));
    }

    @Test
    public void testCheckMeasurementExistence() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.v1.s1"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.temperature"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.GZIP, null, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, (String)"temp"), -1L);
        Map res1 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01.wt01"), IntStream.range(0, 5).mapToObj(i -> "s" + i).collect(Collectors.toList()), IntStream.range(0, 5).mapToObj(i -> "alias" + i).collect(Collectors.toList()));
        Assert.assertEquals((long)0L, (long)res1.size());
        Map res2 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01"), Collections.singletonList("wt01"), Collections.singletonList("alias1"));
        Assert.assertEquals((long)0L, (long)res2.size());
        Map res3 = schemaRegion.checkMeasurementExistence(new PartialPath("root.sg.wf01.wt01"), Arrays.asList("status", "s1", "v1"), Arrays.asList("", "temp", ""));
        Assert.assertEquals((long)3L, (long)res3.size());
        Assert.assertTrue((boolean)(res3.get(0) instanceof MeasurementAlreadyExistException));
        Assert.assertTrue((boolean)(res3.get(1) instanceof AliasAlreadyExistException));
        Assert.assertTrue((boolean)(res3.get(2) instanceof PathAlreadyExistException));
    }

    @Test
    public void testDeleteTimeseries() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt02.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf01.wt01.temperature"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.wf02.wt01.temperature"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null), -1L);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.wt01.*"));
        patternTree.appendPathPattern(new PartialPath("root.sg.wf01.*.status"));
        patternTree.appendPathPattern(new PartialPath("root.sg.wf02.wt01.temperature"));
        patternTree.constructTree();
        Assert.assertTrue((schemaRegion.constructSchemaBlackList(patternTree) >= 4L ? 1 : 0) != 0);
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.sg.wf01.wt01.*"), new PartialPath("root.sg.wf01.wt02.status"), new PartialPath("root.sg.wf01.wt01.status"), new PartialPath("root.sg.wf02.wt01.temperature"))), (Object)schemaRegion.fetchSchemaBlackList(patternTree));
        PathPatternTree rollbackTree = new PathPatternTree();
        rollbackTree.appendPathPattern(new PartialPath("root.sg.wf02.wt01.temperature"));
        rollbackTree.constructTree();
        schemaRegion.rollbackSchemaBlackList(rollbackTree);
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.sg.wf01.wt01.*"), new PartialPath("root.sg.wf01.wt02.status"), new PartialPath("root.sg.wf01.wt01.status"))), (Object)schemaRegion.fetchSchemaBlackList(patternTree));
        schemaRegion.deleteTimeseriesInBlackList(patternTree);
        List schemas = (List)schemaRegion.fetchSchema((PathPatternTree)SchemaConstant.ALL_MATCH_SCOPE, (Map)Collections.EMPTY_MAP, (boolean)false, (boolean)true).searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left;
        Assert.assertEquals((long)1L, (long)schemas.size());
        Assert.assertEquals((Object)"root.sg.wf02.wt01.temperature", (Object)((MeasurementPath)schemas.get(0)).getFullPath());
    }

    @Test
    public void testGetAllTimeseriesCount() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        Assert.assertEquals((long)6L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.**"), null, false));
        Assert.assertEquals((long)6L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.**"), null, false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.*"), null, false));
        Assert.assertEquals((long)4L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.*.*"), null, false));
        Assert.assertEquals((long)5L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.*.**"), null, false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.*.*.t1"), null, false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.*.s1"), null, false));
        Assert.assertEquals((long)3L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d1.**"), null, false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d1.*"), null, false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d2.s1"), null, false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d2.**"), null, false));
        Assert.assertEquals((long)0L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop"), null, false));
        Assert.assertEquals((long)0L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d3.s1"), null, false));
        Assert.assertEquals((long)6L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root"), null, true));
        Assert.assertEquals((long)6L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop"), null, true));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getAllTimeseriesCount(schemaRegion, new PartialPath("root.laptop.d2"), null, true));
    }

    @Test
    public void testGetMeasurementCountGroupByLevel() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        HashMap<PartialPath, Long> expected = new HashMap<PartialPath, Long>();
        expected.put(new PartialPath("root"), 6L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.**"), 0, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop"), 1L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.*"), 1, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d0"), 1L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.d0"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d1"), 2L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.d1.*"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d1"), 3L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.d1.**"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d2"), 2L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.d2.*"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop"), 2L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.*.s1"), 1, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d1"), 1L);
        expected.put(new PartialPath("root.laptop.d2"), 1L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.*.s1"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop"), 1L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.*.s2"), 1, false));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d1"), 2L);
        expected.put(new PartialPath("root.laptop.d2"), 2L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.*.*"), 2, false));
        expected.clear();
        expected.put(new PartialPath("root"), 6L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root"), 0, true));
        expected.clear();
        expected.put(new PartialPath("root.laptop.d1"), 3L);
        Assert.assertEquals(expected, SchemaRegionTestUtil.getMeasurementCountGroupByLevel(schemaRegion, new PartialPath("root.laptop.d1"), 2, true));
        expected.clear();
    }

    @Test
    public void testGetDevicesNum() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        Assert.assertEquals((long)4L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.**"), false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop"), false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.*"), false));
        Assert.assertEquals((long)0L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d0"), false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d1"), false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d1.s2"), false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d2"), false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d*"), false));
        Assert.assertEquals((long)2L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.*.d*"), false));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.**.s2"), false));
        Assert.assertEquals((long)4L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root"), true));
        Assert.assertEquals((long)4L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop"), true));
        Assert.assertEquals((long)3L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d*"), true));
        Assert.assertEquals((long)1L, (long)SchemaRegionTestUtil.getDevicesNum(schemaRegion, new PartialPath("root.laptop.d1.*"), true));
    }

    @Test
    public void testGetNodesListInGivenLevel() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        Assert.assertEquals(new LinkedList<PartialPath>(Collections.singletonList(new PartialPath("root"))), SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.**"), 0, false));
        Assert.assertEquals(new LinkedList<PartialPath>(Collections.singletonList(new PartialPath("root.laptop"))), SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.**"), 1, false));
        Assert.assertEquals(new LinkedList<PartialPath>(Collections.singletonList(new PartialPath("root.laptop"))), SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.laptop"), 1, false));
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.laptop.d0"), new PartialPath("root.laptop.d1"), new PartialPath("root.laptop.d2"))), new HashSet<PartialPath>(SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.laptop.**"), 2, false)));
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.laptop.d1.s1"), new PartialPath("root.laptop.d1.s2"), new PartialPath("root.laptop.d1.s3"), new PartialPath("root.laptop.d2.s1"), new PartialPath("root.laptop.d2.s2"))), new HashSet<PartialPath>(SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.laptop.**"), 3, false)));
        Assert.assertEquals(new HashSet<PartialPath>(Arrays.asList(new PartialPath("root.laptop.d1.s1"), new PartialPath("root.laptop.d2.s1"))), new HashSet<PartialPath>(SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.laptop.*.s1"), 3, false)));
        Assert.assertEquals(new HashSet(Collections.emptyList()), new HashSet<PartialPath>(SchemaRegionTestUtil.getNodesListInGivenLevel(schemaRegion, new PartialPath("root.laptop.notExists"), 1, false)));
    }

    @Test
    public void testGetChildNodePathInNextLevel() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        Assert.assertEquals(new HashSet(Collections.emptyList()), SchemaRegionTestUtil.getChildNodePathInNextLevel(schemaRegion, new PartialPath("root.laptop.d0")));
        Assert.assertEquals(new HashSet<ShowNodesResult>(Arrays.asList(new ShowNodesResult("root.laptop.d1.s1", MNodeType.MEASUREMENT), new ShowNodesResult("root.laptop.d1.s2", MNodeType.DEVICE), new ShowNodesResult("root.laptop.d1.s3", MNodeType.MEASUREMENT))), SchemaRegionTestUtil.getChildNodePathInNextLevel(schemaRegion, new PartialPath("root.laptop.d1")));
        Assert.assertEquals(new HashSet<ShowNodesResult>(Arrays.asList(new ShowNodesResult("root.laptop.d2.s1", MNodeType.MEASUREMENT), new ShowNodesResult("root.laptop.d2.s2", MNodeType.MEASUREMENT))), SchemaRegionTestUtil.getChildNodePathInNextLevel(schemaRegion, new PartialPath("root.laptop.d2")));
        Assert.assertEquals(new HashSet<ShowNodesResult>(Arrays.asList(new ShowNodesResult("root.laptop.d0", MNodeType.MEASUREMENT), new ShowNodesResult("root.laptop.d1", MNodeType.DEVICE), new ShowNodesResult("root.laptop.d2", MNodeType.DEVICE))), SchemaRegionTestUtil.getChildNodePathInNextLevel(schemaRegion, new PartialPath("root.laptop")));
        Assert.assertEquals(new HashSet<ShowNodesResult>(Collections.singletonList(new ShowNodesResult("root.laptop.d1.s2.t1", MNodeType.MEASUREMENT))), SchemaRegionTestUtil.getChildNodePathInNextLevel(schemaRegion, new PartialPath("root.**.s2")));
    }

    @Test
    public void testGetMatchedDevices() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        Assert.assertEquals(Collections.emptyList(), SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.laptop.d0")));
        Assert.assertEquals(Collections.singletonList(new ShowDevicesResult("root.laptop.d1", Boolean.valueOf(false), -1)), SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.laptop.d1")));
        Assert.assertEquals(Collections.singletonList(new ShowDevicesResult("root.laptop.d2", Boolean.valueOf(false), -1)), SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.laptop.d2")));
        Assert.assertEquals(Collections.singletonList(new ShowDevicesResult("root.laptop", Boolean.valueOf(false), -1)), SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.laptop")));
        Assert.assertEquals(Collections.singletonList(new ShowDevicesResult("root.laptop", Boolean.valueOf(false), -1)), SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.*")));
        List<IDeviceSchemaInfo> expectedList = Arrays.asList(new ShowDevicesResult("root.laptop", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d2", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d1.s2", Boolean.valueOf(false), -1));
        List<IDeviceSchemaInfo> actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"));
        HashSet<IDeviceSchemaInfo> expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        HashSet<IDeviceSchemaInfo> actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
        expectedList = Arrays.asList(new ShowDevicesResult("root.laptop.d1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d2", Boolean.valueOf(false), -1));
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**.d*"));
        expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 3, 0, false);
        Assert.assertEquals((long)3L, (long)actualResult.size());
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 3, 1, false);
        Assert.assertEquals((long)3L, (long)actualResult.size());
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 3, 2, false);
        Assert.assertEquals((long)2L, (long)actualResult.size());
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 3, 99, false);
        Assert.assertEquals((long)0L, (long)actualResult.size());
        expectedList = Arrays.asList(new ShowDevicesResult("root.laptop", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d1.s2", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d2", Boolean.valueOf(false), -1));
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 0, 0, false, SchemaFilterFactory.createPathContainsFilter((String)"laptop"));
        expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
        expectedList = Arrays.asList(new ShowDevicesResult("root.laptop.d1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.laptop.d1.s2", Boolean.valueOf(false), -1));
        actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**"), 2, 0, false, SchemaFilterFactory.createPathContainsFilter((String)"laptop.d"));
        expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
    }

    @Test
    public void testShowTimeseries() throws Exception {
        int index;
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.laptop", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"));
        HashSet<String> expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        int expectedSize = 6;
        Assert.assertEquals((long)expectedSize, (long)result.size());
        HashSet<String> actualPathList = new HashSet<String>();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**.s*"));
        expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d1.s1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        expectedSize = 4;
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createPathContainsFilter((String)"s"), false);
        expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createPathContainsFilter((String)"1"), false);
        expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1"));
        expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createPathContainsFilter((String)"laptop.d"), false);
        expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createDataTypeFilter((TSDataType)TSDataType.INT64), false);
        expectedPathList = new HashSet<String>(Arrays.asList("root.laptop.d0", "root.laptop.d1.s1", "root.laptop.d1.s2.t1", "root.laptop.d1.s3", "root.laptop.d2.s1", "root.laptop.d2.s2"));
        expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**"), Collections.emptyMap(), 0L, 0L, false, SchemaFilterFactory.createDataTypeFilter((TSDataType)TSDataType.BOOLEAN), false);
        expectedPathList = new HashSet(Collections.emptyList());
        expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
    }

    @Test
    public void testGetMatchedDevicesWithSpecialPattern() throws Exception {
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.test", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.test.d1.s", "root.test.dac.device1.s", "root.test.dac.device1.d1.s"));
        List<IDeviceSchemaInfo> expectedList = Arrays.asList(new ShowDevicesResult("root.test.d1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.test.dac.device1", Boolean.valueOf(false), -1), new ShowDevicesResult("root.test.dac.device1.d1", Boolean.valueOf(false), -1));
        List<IDeviceSchemaInfo> actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**.d*"));
        HashSet<IDeviceSchemaInfo> expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        HashSet<IDeviceSchemaInfo> actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
        List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**.d*.*"));
        HashSet<String> expectedPathList = new HashSet<String>(Arrays.asList("root.test.d1.s", "root.test.dac.device1.s", "root.test.dac.device1.d1.s"));
        int expectedSize = 3;
        Assert.assertEquals((long)expectedSize, (long)result.size());
        HashSet<String> actualPathList = new HashSet<String>();
        for (int index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
    }

    @Test
    public void testGetMatchedDevicesWithSpecialPattern2() throws Exception {
        int index;
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.test", 0);
        SchemaRegionTestUtil.createSimpleTimeseriesByList(schemaRegion, Arrays.asList("root.test.abc57.bcde22.def89.efg1", "root.test.abc57.bcde22.def89.efg2", "root.test.abc57.bcd22.def89.efg1", "root.test.abc57.bcd22.def89.efg2"));
        List<IDeviceSchemaInfo> expectedList = Arrays.asList(new ShowDevicesResult("root.test.abc57.bcde22.def89", Boolean.valueOf(false), -1), new ShowDevicesResult("root.test.abc57.bcd22.def89", Boolean.valueOf(false), -1));
        List<IDeviceSchemaInfo> actualResult = SchemaRegionTestUtil.getMatchedDevices(schemaRegion, new PartialPath("root.**.*b*.*"));
        HashSet<IDeviceSchemaInfo> expectedHashset = new HashSet<IDeviceSchemaInfo>(expectedList);
        HashSet<IDeviceSchemaInfo> actualHashset = new HashSet<IDeviceSchemaInfo>(actualResult);
        Assert.assertEquals(expectedHashset, actualHashset);
        List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**.*e*.*e*"));
        HashSet<String> expectedPathList = new HashSet<String>(Arrays.asList("root.test.abc57.bcde22.def89.efg1", "root.test.abc57.bcde22.def89.efg2", "root.test.abc57.bcd22.def89.efg1", "root.test.abc57.bcd22.def89.efg2"));
        int expectedSize = expectedPathList.size();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        HashSet<String> actualPathList = new HashSet<String>();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
        result = SchemaRegionTestUtil.showTimeseries(schemaRegion, new PartialPath("root.**.*e*"));
        Assert.assertEquals((long)expectedSize, (long)result.size());
        actualPathList = new HashSet();
        for (index = 0; index < expectedSize; ++index) {
            actualPathList.add(result.get(index).getFullPath());
        }
        Assert.assertEquals(expectedPathList, actualPathList);
    }
}

