/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.metadata.schemaRegion.AbstractSchemaRegionTest;
import org.apache.iotdb.db.metadata.schemaRegion.SchemaRegionTestUtil;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionAliasAndTagTest
extends AbstractSchemaRegionTest {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionAliasAndTagTest.class);
    private ISchemaRegion schemaRegion;

    public SchemaRegionAliasAndTagTest(AbstractSchemaRegionTest.SchemaRegionTestParams testParams) {
        super(testParams);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.schemaRegion = this.getSchemaRegion("root.sg", 0);
    }

    private void prepareTimeseries() throws MetadataException {
        SchemaRegionTestUtil.createTimeseries(this.schemaRegion, "root.sg.wf01.wt01.v1.s1", TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, null, null, null, null);
        SchemaRegionTestUtil.createTimeseries(this.schemaRegion, "root.sg.wf01.wt01.v1.s2", TSDataType.FLOAT, TSEncoding.RLE, CompressionType.GZIP, null, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, "temp");
        SchemaRegionTestUtil.createAlignedTimeseries(this.schemaRegion, "root.sg.wf01.aligned_device1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT64, TSDataType.INT32), Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.LZ4), null, null, null);
        SchemaRegionTestUtil.createAlignedTimeseries(this.schemaRegion, "root.sg.wf01.aligned_device2", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT64, TSDataType.INT32), Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.LZ4), Arrays.asList(new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
            }
        }, new HashMap<String, String>(){
            {
                this.put("tag2", "t2");
            }
        }), Arrays.asList(new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
            }
        }, new HashMap<String, String>(){
            {
                this.put("attr2", "a2");
            }
        }), Arrays.asList("alias1", "alias2"));
    }

    private void checkAliasAndTagsAndAttributes(String fullPath, String alias, Map<String, String> tags, Map<String, String> attributes) {
        try {
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(this.schemaRegion, new PartialPath(fullPath));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)fullPath, (Object)result.get(0).getFullPath());
            Assert.assertEquals((Object)alias, (Object)result.get(0).getAlias());
            Assert.assertEquals(tags, (Object)result.get(0).getTags());
            Assert.assertEquals(attributes, (Object)result.get(0).getAttributes());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkAttributes(String fullPath, Map<String, String> attributes) {
        try {
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(this.schemaRegion, new PartialPath(fullPath));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)fullPath, (Object)result.get(0).getFullPath());
            Assert.assertEquals(attributes, (Object)result.get(0).getAttributes());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkTags(String fullPath, Map<String, String> tags) {
        try {
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(this.schemaRegion, new PartialPath(fullPath));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)fullPath, (Object)result.get(0).getFullPath());
            Assert.assertEquals(tags, (Object)result.get(0).getTags());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShowTimeseries() throws MetadataException {
        this.prepareTimeseries();
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.wt01.v1.s1", null, Collections.emptyMap(), Collections.emptyMap());
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.wt01.v1.s2", "temp", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag2", "t2");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        });
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.aligned_device1.s1", null, Collections.emptyMap(), Collections.emptyMap());
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.aligned_device1.s2", null, Collections.emptyMap(), Collections.emptyMap());
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.aligned_device2.s1", "alias1", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
            }
        });
        this.checkAliasAndTagsAndAttributes("root.sg.wf01.aligned_device2.s2", "alias2", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tag2", "t2");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("attr2", "a2");
            }
        });
    }

    @Test
    public void testUpsertAliasAndTagsAndAttributes() {
        try {
            this.prepareTimeseries();
            try {
                this.schemaRegion.upsertAliasAndTagsAndAttributes("s2", null, null, new PartialPath("root.sg.wf01.wt01.v1.s1"));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The alias is duplicated with the name or alias of other measurement."));
            }
            try {
                this.schemaRegion.upsertAliasAndTagsAndAttributes("temp", null, null, new PartialPath("root.sg.wf01.wt01.v1.s1"));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The alias is duplicated with the name or alias of other measurement."));
            }
            HashMap<String, String> newTags = new HashMap<String, String>(){
                {
                    this.put("tag1", "new1");
                    this.put("tag2", "new2");
                    this.put("tag3", "new3");
                }
            };
            HashMap<String, String> newAttributes = new HashMap<String, String>(){
                {
                    this.put("attr1", "new1");
                    this.put("attr2", "new2");
                    this.put("attr3", "new3");
                }
            };
            List<String> fullPaths = Arrays.asList("root.sg.wf01.wt01.v1.s1", "root.sg.wf01.wt01.v1.s2", "root.sg.wf01.aligned_device1.s1", "root.sg.wf01.aligned_device1.s2", "root.sg.wf01.aligned_device2.s1", "root.sg.wf01.aligned_device2.s2");
            List<String> aliasList = Arrays.asList("newAlias1", "newAlias2", "newAlias3", "newAlias4", "newAlias5", "newAlias6");
            for (int i = 0; i < fullPaths.size(); ++i) {
                this.schemaRegion.upsertAliasAndTagsAndAttributes(aliasList.get(i), (Map)newTags, (Map)newAttributes, new PartialPath(fullPaths.get(i)));
                this.checkAliasAndTagsAndAttributes(fullPaths.get(i), aliasList.get(i), (Map<String, String>)newTags, (Map<String, String>)newAttributes);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddAttributes() {
        try {
            this.prepareTimeseries();
            HashMap<String, String> newAttributes = new HashMap<String, String>(){
                {
                    this.put("attr2", "new2");
                    this.put("attr3", "new3");
                }
            };
            this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.wt01.v1.s1"));
            this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.aligned_device1.s1"));
            try {
                this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.wt01.v1.s2"));
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("already has the attribute"));
            }
            try {
                this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.aligned_device2.s2"));
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("already has the attribute"));
            }
            this.checkAttributes("root.sg.wf01.wt01.v1.s1", (Map<String, String>)newAttributes);
            this.checkAttributes("root.sg.wf01.aligned_device1.s1", (Map<String, String>)newAttributes);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddTags() {
        try {
            this.prepareTimeseries();
            HashMap<String, String> newTags = new HashMap<String, String>(){
                {
                    this.put("tag2", "new2");
                    this.put("tag3", "new3");
                }
            };
            this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.wt01.v1.s1"));
            this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.aligned_device1.s1"));
            try {
                this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.wt01.v1.s2"));
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("already has the tag"));
            }
            try {
                this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.aligned_device2.s2"));
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("already has the tag"));
            }
            this.checkTags("root.sg.wf01.wt01.v1.s1", (Map<String, String>)newTags);
            this.checkTags("root.sg.wf01.aligned_device1.s1", (Map<String, String>)newTags);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDropTagsOrAttributes() {
        try {
            this.prepareTimeseries();
            HashSet<String> keySet = new HashSet<String>(Arrays.asList("tag1", "tag2", "tag3", "attr1", "attr2", "attr3"));
            HashMap<String, String> newTags = new HashMap<String, String>(){
                {
                    this.put("tag2", "new2");
                    this.put("tag3", "new3");
                }
            };
            this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.wt01.v1.s1"));
            this.schemaRegion.addTags((Map)newTags, new PartialPath("root.sg.wf01.aligned_device1.s1"));
            HashMap<String, String> newAttributes = new HashMap<String, String>(){
                {
                    this.put("attr2", "new2");
                    this.put("attr3", "new3");
                }
            };
            this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.wt01.v1.s1"));
            this.schemaRegion.addAttributes((Map)newAttributes, new PartialPath("root.sg.wf01.aligned_device1.s1"));
            List<String> fullPaths = Arrays.asList("root.sg.wf01.wt01.v1.s1", "root.sg.wf01.wt01.v1.s2", "root.sg.wf01.aligned_device1.s1", "root.sg.wf01.aligned_device1.s2", "root.sg.wf01.aligned_device2.s1", "root.sg.wf01.aligned_device2.s2");
            for (String fullPath : fullPaths) {
                this.schemaRegion.dropTagsOrAttributes(keySet, new PartialPath(fullPath));
                this.checkTags(fullPath, Collections.emptyMap());
                this.checkAttributes(fullPath, Collections.emptyMap());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTagsOrAttributesValue() {
        try {
            this.prepareTimeseries();
            HashMap<String, String> tagsOrAttributesValue = new HashMap<String, String>(){
                {
                    this.put("tag1", "new1");
                    this.put("attr1", "new1");
                }
            };
            List<String> fullPaths = Arrays.asList("root.sg.wf01.wt01.v1.s1", "root.sg.wf01.wt01.v1.s2", "root.sg.wf01.aligned_device1.s1", "root.sg.wf01.aligned_device1.s2", "root.sg.wf01.aligned_device2.s1", "root.sg.wf01.aligned_device2.s2");
            List<Boolean> expectException = Arrays.asList(true, false, true, true, false, true);
            for (int i = 0; i < fullPaths.size(); ++i) {
                try {
                    this.schemaRegion.setTagsOrAttributesValue((Map)tagsOrAttributesValue, new PartialPath(fullPaths.get(i)));
                    Assert.assertFalse((boolean)expectException.get(i));
                    continue;
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)expectException.get(i));
                    Assert.assertTrue((boolean)e.getMessage().contains("does not have"));
                }
            }
            this.checkAttributes("root.sg.wf01.wt01.v1.s2", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("attr1", "new1");
                    this.put("attr2", "a2");
                }
            });
            this.checkTags("root.sg.wf01.wt01.v1.s2", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("tag1", "new1");
                    this.put("tag2", "t2");
                }
            });
            this.checkAttributes("root.sg.wf01.aligned_device2.s1", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("attr1", "new1");
                }
            });
            this.checkTags("root.sg.wf01.aligned_device2.s1", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("tag1", "new1");
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRenameTagOrAttributeKey() {
        try {
            this.prepareTimeseries();
            try {
                this.schemaRegion.renameTagOrAttributeKey("attr1", "attr2", new PartialPath("root.sg.wf01.wt01.v1.s2"));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("already has a tag/attribute named"));
            }
            try {
                this.schemaRegion.renameTagOrAttributeKey("attr3", "newAttr3", new PartialPath("root.sg.wf01.wt01.v1.s2"));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("does not have tag/attribute"));
            }
            this.schemaRegion.renameTagOrAttributeKey("attr1", "newAttr1", new PartialPath("root.sg.wf01.wt01.v1.s2"));
            this.schemaRegion.renameTagOrAttributeKey("tag1", "newTag1", new PartialPath("root.sg.wf01.wt01.v1.s2"));
            this.schemaRegion.renameTagOrAttributeKey("attr1", "newAttr1", new PartialPath("root.sg.wf01.aligned_device2.s1"));
            this.schemaRegion.renameTagOrAttributeKey("tag1", "newTag1", new PartialPath("root.sg.wf01.aligned_device2.s1"));
            this.checkAttributes("root.sg.wf01.wt01.v1.s2", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("newAttr1", "a1");
                    this.put("attr2", "a2");
                }
            });
            this.checkTags("root.sg.wf01.wt01.v1.s2", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("newTag1", "t1");
                    this.put("tag2", "t2");
                }
            });
            this.checkAttributes("root.sg.wf01.aligned_device2.s1", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("newAttr1", "a1");
                }
            });
            this.checkTags("root.sg.wf01.aligned_device2.s1", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("newTag1", "t1");
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeleteAndQueryByAlias() {
        try {
            this.prepareTimeseries();
            List<ITimeSeriesSchemaInfo> result = SchemaRegionTestUtil.showTimeseries(this.schemaRegion, new PartialPath("root.sg.wf01.wt01.v1.temp"));
            Assert.assertEquals((long)1L, (long)result.size());
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendFullPath(new PartialPath("root.sg.wf01.wt01.v1.temp"));
            patternTree.constructTree();
            Assert.assertTrue((this.schemaRegion.constructSchemaBlackList(patternTree) >= 1L ? 1 : 0) != 0);
            this.schemaRegion.deleteTimeseriesInBlackList(patternTree);
            result = SchemaRegionTestUtil.showTimeseries(this.schemaRegion, new PartialPath("root.sg.wf01.wt01.v1.temp"));
            Assert.assertEquals((long)0L, (long)result.size());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }
}

