/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractSchemaRegionTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private SchemaRegionTestParams rawConfig;
    protected final SchemaRegionTestParams testParams;

    @Parameterized.Parameters(name="{0}")
    public static List<SchemaRegionTestParams> getTestModes() {
        return Arrays.asList(new SchemaRegionTestParams("MemoryMode", "Memory", -1), new SchemaRegionTestParams("PBTree-FullMemory", "PBTree", 10000), new SchemaRegionTestParams("PBTree-PartialMemory", "PBTree", 3), new SchemaRegionTestParams("PBTree-NonMemory", "PBTree", 0));
    }

    public AbstractSchemaRegionTest(SchemaRegionTestParams testParams) {
        this.testParams = testParams;
    }

    @Before
    public void setUp() throws Exception {
        this.rawConfig = new SchemaRegionTestParams("Raw-Config", COMMON_CONFIG.getSchemaEngineMode(), config.getCachedMNodeSizeInPBTreeMode());
        COMMON_CONFIG.setSchemaEngineMode(this.testParams.schemaEngineMode);
        config.setCachedMNodeSizeInPBTreeMode(this.testParams.cachedMNodeSize);
        SchemaEngine.getInstance().init();
    }

    @After
    public void tearDown() throws Exception {
        SchemaEngine.getInstance().clear();
        this.cleanEnv();
        COMMON_CONFIG.setSchemaEngineMode(this.rawConfig.schemaEngineMode);
        config.setCachedMNodeSizeInPBTreeMode(this.rawConfig.cachedMNodeSize);
    }

    protected void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)new File(IoTDBDescriptor.getInstance().getConfig().getSchemaDir()));
    }

    protected void simulateRestart() {
        SchemaEngine.getInstance().clear();
        SchemaEngine.getInstance().init();
    }

    protected ISchemaRegion getSchemaRegion(String database, int schemaRegionId) throws Exception {
        SchemaRegionId regionId = new SchemaRegionId(schemaRegionId);
        if (SchemaEngine.getInstance().getSchemaRegion(regionId) == null) {
            SchemaEngine.getInstance().createSchemaRegion(new PartialPath(database), regionId);
        }
        return SchemaEngine.getInstance().getSchemaRegion(regionId);
    }

    protected static class SchemaRegionTestParams {
        private final String testModeName;
        private final String schemaEngineMode;
        private final int cachedMNodeSize;

        private SchemaRegionTestParams(String testModeName, String schemaEngineMode, int cachedMNodeSize) {
            this.testModeName = testModeName;
            this.schemaEngineMode = schemaEngineMode;
            this.cachedMNodeSize = cachedMNodeSize;
        }

        public String getTestModeName() {
            return this.testModeName;
        }

        public String getSchemaEngineMode() {
            return this.schemaEngineMode;
        }

        public int getCachedMNodeSize() {
            return this.cachedMNodeSize;
        }

        public String toString() {
            return this.testModeName;
        }
    }
}

