/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class MeasurementPathTest {
    @Test
    public void testTransformDataToString() throws IllegalPathException {
        MeasurementPath rawPath = new MeasurementPath(new PartialPath("root.sg.d.s"), (IMeasurementSchema)new MeasurementSchema("s", TSDataType.INT32), Boolean.valueOf(true));
        rawPath.setMeasurementAlias("alias");
        String string = MeasurementPath.transformDataToString((MeasurementPath)rawPath);
        MeasurementPath newPath = MeasurementPath.parseDataFromString((String)string);
        Assert.assertEquals((Object)rawPath.getFullPath(), (Object)newPath.getFullPath());
        Assert.assertEquals((Object)rawPath.getMeasurementAlias(), (Object)newPath.getMeasurementAlias());
        Assert.assertEquals((Object)rawPath.getMeasurementSchema(), (Object)newPath.getMeasurementSchema());
        Assert.assertEquals((Object)rawPath.isUnderAlignedEntity(), (Object)newPath.isUnderAlignedEntity());
    }

    @Test
    public void testMeasurementPathSerde() throws IllegalPathException, IOException {
        MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.TEXT);
        MeasurementPath expectedPath = new MeasurementPath(new PartialPath("root.sg.d1.s1"), (IMeasurementSchema)schema, Boolean.valueOf(true));
        expectedPath.setMeasurementAlias("alias_s1");
        MeasurementPath actualPath = this.serdeWithByteBuffer(expectedPath);
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        actualPath = this.serdeWithStream(expectedPath);
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("k1", "v1");
        expectedPath.setTagMap(tagMap);
        actualPath = this.serdeWithByteBuffer(expectedPath);
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        actualPath = this.serdeWithStream(expectedPath);
        this.assertMeasurementPathEquals(actualPath, expectedPath);
    }

    @Test
    public void testCloneAndCopy() throws IllegalPathException {
        MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.TEXT);
        MeasurementPath expectedPath = new MeasurementPath(new PartialPath("root.sg.d1.s1"), (IMeasurementSchema)schema, Boolean.valueOf(true));
        expectedPath.setMeasurementAlias("alias_s1");
        MeasurementPath actualPath = expectedPath.clone();
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        actualPath = (MeasurementPath)expectedPath.copy();
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put("k1", "v1");
        expectedPath.setTagMap(tagMap);
        actualPath = expectedPath.clone();
        this.assertMeasurementPathEquals(actualPath, expectedPath);
        actualPath = (MeasurementPath)expectedPath.copy();
        this.assertMeasurementPathEquals(actualPath, expectedPath);
    }

    private MeasurementPath serdeWithByteBuffer(MeasurementPath origin) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        origin.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)0L, (long)ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer));
        return MeasurementPath.deserialize((ByteBuffer)byteBuffer);
    }

    private MeasurementPath serdeWithStream(MeasurementPath origin) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        origin.serialize((OutputStream)dataOutputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Assert.assertEquals((long)0L, (long)ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer));
        return MeasurementPath.deserialize((ByteBuffer)byteBuffer);
    }

    private void assertMeasurementPathEquals(MeasurementPath actual, MeasurementPath expected) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.isUnderAlignedEntity(), (Object)actual.isUnderAlignedEntity());
        Assert.assertEquals((Object)expected.getTagMap(), (Object)actual.getTagMap());
        Assert.assertEquals((Object)expected.getMeasurementSchema(), (Object)actual.getMeasurementSchema());
        Assert.assertEquals((Object)expected.getMeasurementAlias(), (Object)actual.getMeasurementAlias());
    }
}

