/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.WrappedSegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WrappedSegmentTest {
    private static final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.PBTree.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void testUpdateAlias() throws MetadataException {
        WrappedSegment sf = new WrappedSegment(500);
        ICachedMNode node = this.getMeasurementNode(null, "s1", null);
        sf.insertRecord("s1", RecordUtils.node2Buffer((ICachedMNode)node));
        node.getAsMeasurementMNode().setAlias("alias1");
        sf.updateRecord("s1", RecordUtils.node2Buffer((ICachedMNode)node));
        node.getAsMeasurementMNode().setAlias("alias2");
        sf.updateRecord("s1", RecordUtils.node2Buffer((ICachedMNode)node));
        Assert.assertEquals(null, (Object)sf.getRecordByAlias("alias1"));
        ICachedMNode node1 = sf.getRecordByAlias("alias2");
        Assert.assertTrue((boolean)node1.isMeasurement());
        Assert.assertEquals((Object)"alias2", (Object)node1.getAsMeasurementMNode().getAlias());
    }

    @Test
    public void flatTreeInsert() throws MetadataException {
        WrappedSegment sf = new WrappedSegment(500);
        ICachedMNode rNode = this.virtualFlatMTree(10);
        for (ICachedMNode node : rNode.getChildren().values()) {
            sf.insertRecord(node.getName(), RecordUtils.node2Buffer((ICachedMNode)node));
        }
        sf.syncBuffer();
        ByteBuffer recMid01 = sf.getRecord("mid1");
        Assert.assertEquals((Object)"[measurementNode, alias: mid1als, type: FLOAT, encoding: PLAIN, compressor: LZ4]", (Object)RecordUtils.buffer2String((ByteBuffer)recMid01));
        int resInsertNode = sf.insertRecord(rNode.getName(), RecordUtils.node2Buffer((ICachedMNode)rNode));
        System.out.println(resInsertNode);
        System.out.println(sf);
        Assert.assertEquals((Object)"[entityNode, not aligned, not using template.]", (Object)RecordUtils.buffer2String((ByteBuffer)sf.getRecord("vRoot1")));
        WrappedSegment nsf = new WrappedSegment(sf.getBufferCopy(), false);
        System.out.println(nsf);
        ByteBuffer nrec = nsf.getRecord("mid1");
        Assert.assertEquals((Object)"[measurementNode, alias: mid1als, type: FLOAT, encoding: PLAIN, compressor: LZ4]", (Object)RecordUtils.buffer2String((ByteBuffer)nsf.getRecord("mid1")));
        Assert.assertEquals((Object)"[entityNode, not aligned, not using template.]", (Object)RecordUtils.buffer2String((ByteBuffer)nsf.getRecord("vRoot1")));
        ByteBuffer newBuffer = ByteBuffer.allocate(1500);
        sf.extendsTo(newBuffer);
        ISegment newSeg = WrappedSegment.loadAsSegment((ByteBuffer)newBuffer);
        System.out.println(newSeg);
        Assert.assertEquals((Object)RecordUtils.buffer2String((ByteBuffer)sf.getRecord("mid4")), (Object)RecordUtils.buffer2String((ByteBuffer)((WrappedSegment)newSeg).getRecord("mid4")));
        Assert.assertEquals((Object)sf.getRecord("aaa"), (Object)nsf.getRecord("aaa"));
    }

    private ICachedMNode virtualFlatMTree(int childSize) {
        ICachedMNode internalNode = (ICachedMNode)nodeFactory.createDeviceMNode(null, "vRoot1").getAsMNode();
        for (int idx = 0; idx < childSize; ++idx) {
            String measurementId = "mid" + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            internalNode.addChild((IMNode)((ICachedMNode)nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), measurementId, (IMeasurementSchema)schema, measurementId + "als").getAsMNode()));
        }
        return internalNode;
    }

    @Test
    public void evenSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(500);
        ISegment seg = WrappedSegment.initAsSegment((ByteBuffer)buffer);
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9"};
        ICachedMNode mNode = this.getMeasurementNode(null, "m", null);
        ByteBuffer buf = RecordUtils.node2Buffer((ICachedMNode)mNode);
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)buf);
        }
        ByteBuffer buf2 = ByteBuffer.allocate(500);
        String sk = seg.splitByKey("a55", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a5", (Object)sk);
        Assert.assertEquals((long)4L, (long)seg.getAllRecords().size());
        Assert.assertEquals((long)6L, (long)WrappedSegment.loadAsSegment((ByteBuffer)buf2).getAllRecords().size());
        seg.syncBuffer();
        ISegment seg3 = WrappedSegment.loadAsSegment((ByteBuffer)buffer);
        Assert.assertEquals((long)seg.getAllRecords().size(), (long)seg3.getAllRecords().size());
        buf2.clear();
        seg.splitByKey(null, null, buf2, false);
        Assert.assertEquals((long)2L, (long)seg.getAllRecords().size());
        buf2.clear();
        seg.splitByKey(null, null, buf2, false);
        Assert.assertEquals((long)1L, (long)seg.getAllRecords().size());
        buf2.clear();
        seg.splitByKey("b", (Object)buf, buf2, false);
        Assert.assertEquals((long)1L, (long)seg.getAllRecords().size());
    }

    @Test
    public void increasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(500);
        ByteBuffer buf2 = ByteBuffer.allocate(500);
        ISegment seg = WrappedSegment.initAsSegment((ByteBuffer)buffer);
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8"};
        ICachedMNode mNode = (ICachedMNode)nodeFactory.createInternalMNode(null, "m");
        ByteBuffer buf = RecordUtils.node2Buffer((ICachedMNode)mNode);
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)buf);
        }
        String sk = seg.splitByKey("a9", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a9", (Object)sk);
        Assert.assertEquals((long)1L, (long)WrappedSegment.loadAsSegment((ByteBuffer)buf2).getAllRecords().size());
        seg.insertRecord("a71", (Object)buf);
        seg.insertRecord("a72", (Object)buf);
        buf2.clear();
        sk = seg.splitByKey("a73", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a73", (Object)sk);
        Assert.assertEquals((long)2L, (long)WrappedSegment.loadAsSegment((ByteBuffer)buf2).getAllRecords().size());
        seg.insertRecord("a00", (Object)buf);
        seg.insertRecord("a01", (Object)buf);
        buf2.clear();
        sk = seg.splitByKey("a02", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a3", (Object)sk);
        Assert.assertEquals((long)5L, (long)seg.getAllRecords().size());
    }

    @Test
    public void decreasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(500);
        ByteBuffer buf2 = ByteBuffer.allocate(500);
        ISegment seg = WrappedSegment.initAsSegment((ByteBuffer)buffer);
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8"};
        ICachedMNode mNode = (ICachedMNode)nodeFactory.createInternalMNode(null, "m");
        ByteBuffer buf = RecordUtils.node2Buffer((ICachedMNode)mNode);
        for (int i = test.length - 1; i >= 0; --i) {
            seg.insertRecord(test[i], (Object)buf);
        }
        seg.insertRecord("a12", (Object)buf);
        seg.insertRecord("a11", (Object)buf);
        String sk = seg.splitByKey("a10", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a11", (Object)sk);
        Assert.assertEquals((long)2L, (long)seg.getAllRecords().size());
        Assert.assertEquals((long)9L, (long)WrappedSegment.loadAsSegment((ByteBuffer)buf2).getAllRecords().size());
        test = new String[]{"a5", "a6", "a7", "a8"};
        for (int i = test.length - 1; i >= 0; --i) {
            seg.insertRecord(test[i], (Object)buf);
        }
        seg.insertRecord("a84", (Object)buf);
        seg.insertRecord("a83", (Object)buf);
        buf2.clear();
        sk = seg.splitByKey("a82", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a7", (Object)sk);
        Assert.assertEquals((long)4L, (long)seg.getAllRecords().size());
        seg.insertRecord("a43", (Object)buf);
        seg.insertRecord("a42", (Object)buf);
        buf2.clear();
        sk = seg.splitByKey("a41", (Object)buf, buf2, true);
        Assert.assertEquals((Object)"a42", (Object)sk);
        Assert.assertEquals((long)3L, (long)seg.getAllRecords().size());
    }

    public void print(ByteBuffer buf) throws MetadataException {
        System.out.println(WrappedSegment.loadAsSegment((ByteBuffer)buf).inspect());
    }

    public void print(Object s) {
        System.out.println(s);
    }

    private ICachedMNode getMeasurementNode(ICachedMNode par, String name, String alias) {
        MeasurementSchema schema = new MeasurementSchema(name, TSDataType.FLOAT);
        return (ICachedMNode)nodeFactory.createMeasurementMNode(par == null ? null : par.getAsDeviceMNode(), name, (IMeasurementSchema)schema, alias).getAsMNode();
    }
}

