/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaPageTest {
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void flatTreeInsert() throws IOException, MetadataException {
        ISegmentedPage page = ISchemaPage.initSegmentedPage((ByteBuffer)ByteBuffer.allocate(16384), (int)0);
        ICachedMNode root = this.virtualFlatMTree(15);
        block2: for (int i = 0; i < 7; ++i) {
            page.getAsSegmentedPage().allocNewSegment(SchemaFileConfig.SEG_SIZE_LST[0]);
            int cnt = 0;
            for (ICachedMNode child : root.getChildren().values()) {
                ++cnt;
                try {
                    page.getAsSegmentedPage().write((short)i, child.getName(), RecordUtils.node2Buffer((ICachedMNode)child));
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                if (cnt <= i) continue;
                continue block2;
            }
        }
        ByteBuffer newBuf = ByteBuffer.allocate(16384);
        page.syncPageBuffer();
        page.getPageBuffer(newBuf);
        SchemaPage newPage = ISchemaPage.loadSchemaPage((ByteBuffer)newBuf);
        Assert.assertEquals((Object)newPage.inspect(), (Object)page.inspect());
        System.out.println(newPage.inspect());
    }

    @Test
    public void essentialPageTest() throws MetadataException, IOException {
        ByteBuffer buf = ByteBuffer.allocate(16384);
        ISegmentedPage page = ISchemaPage.initSegmentedPage((ByteBuffer)buf, (int)0);
        page.getAsSegmentedPage().allocNewSegment((short)500);
        Assert.assertFalse((page.getAsInternalPage() != null ? 1 : 0) != 0);
        page.getAsSegmentedPage().deleteSegment((short)0);
        page = ISchemaPage.initInternalPage((ByteBuffer)buf, (int)0, (int)0);
        Assert.assertTrue((page.getAsInternalPage() != null ? 1 : 0) != 0);
        page.getAsInternalPage().insertRecord("aaa", (Object)256);
        page.getAsInternalPage().setNextSegAddress(999L);
        page.syncPageBuffer();
        SchemaPage nPage = ISchemaPage.loadSchemaPage((ByteBuffer)buf);
        Assert.assertTrue((nPage.getAsInternalPage() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)999L, (long)nPage.getAsInternalPage().getNextSegAddress());
        Assert.assertEquals((long)256L, (long)((Integer)nPage.getAsInternalPage().getRecordByKey("aab")).intValue());
    }

    private ICachedMNode virtualFlatMTree(int childSize) {
        ICachedMNode internalNode = (ICachedMNode)this.nodeFactory.createDeviceMNode(null, "vRoot1").getAsMNode();
        for (int idx = 0; idx < childSize; ++idx) {
            String measurementId = "mid" + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            internalNode.addChild((IMNode)((ICachedMNode)this.nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), measurementId, (IMeasurementSchema)schema, measurementId + "als").getAsMNode()));
        }
        return internalNode;
    }

    public void print(Object o) {
        System.out.println(o);
    }

    private void printBuffer(ByteBuffer buf) {
        int lim = buf.limit();
        ByteBuffer bufRep = buf.slice();
        for (int pos = buf.position(); pos < lim; ++pos) {
            System.out.print(buf.get(pos));
            System.out.print(" ");
        }
        System.out.println("");
    }
}

