/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.WrappedSegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MNodeUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFileTest {
    private static final int TEST_SCHEMA_REGION_ID = 0;
    private static final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.PBTree.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    private void writeMNodeInTest(ISchemaFile st, ICachedMNode node) throws IOException, MetadataException {
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node);
        container.transferAllBufferReceivingToFlushing();
        st.writeMNode(node);
    }

    @Test
    public void essentialTestSchemaFile() throws IOException, MetadataException {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        IDatabaseMNode newSGNode = ((ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "newSG", 10000L)).getAsDatabaseMNode();
        sf.updateDatabaseNode(newSGNode);
        ICachedMNode root = SchemaFileTest.virtualTriangleMTree(5, "root.test");
        ICachedMNode int0 = (ICachedMNode)root.getChild("int0");
        ICachedMNode int1 = (ICachedMNode)((ICachedMNode)root.getChild("int0")).getChild("int1");
        ICachedMNode int4 = (ICachedMNode)((ICachedMNode)((ICachedMNode)((ICachedMNode)((ICachedMNode)root.getChild("int0")).getChild("int1")).getChild("int2")).getChild("int3")).getChild("int4");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int0).getNewChildBuffer().put("mint1", SchemaFileTest.getMeasurementNode(int0, "mint1", "alas"));
        Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            ICachedMNode curNode = ite.next();
            if (curNode.isMeasurement()) continue;
            this.writeMNodeInTest((ISchemaFile)sf, curNode);
        }
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int0).getNewChildBuffer().clear();
        SchemaFileTest.addNodeToUpdateBuffer(int0, SchemaFileTest.getMeasurementNode(int0, "mint1", "alas99999"));
        this.writeMNodeInTest((ISchemaFile)sf, int0);
        Assert.assertEquals((Object)"alas99999", (Object)sf.getChildNode(int0, "mint1").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int1).appendMNode(SchemaFileTest.getMeasurementNode(int1, "int1newM", "alas"));
        this.writeMNodeInTest((ISchemaFile)sf, int1);
        Assert.assertEquals((Object)"alas", (Object)sf.getChildNode(int1, "int1newM").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int4).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int4).getNewChildBuffer().put("AAAAA", SchemaFileTest.getMeasurementNode(int4, "AAAAA", "alas"));
        this.writeMNodeInTest((ISchemaFile)sf, int4);
        Assert.assertEquals((Object)"alas", (Object)sf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int4).getUpdatedChildBuffer().clear();
        SchemaFileTest.addNodeToUpdateBuffer(int4, SchemaFileTest.getMeasurementNode(int4, "AAAAA", "BBBBBB"));
        this.writeMNodeInTest((ISchemaFile)sf, int4);
        Assert.assertEquals((Object)"BBBBBB", (Object)sf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int4).getUpdatedChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)int4).getUpdatedChildBuffer().put("finalM191", SchemaFileTest.getMeasurementNode(int4, "finalM191", "ALLLLLLLLLLLLLLLLLLLLfinalM191"));
        this.writeMNodeInTest((ISchemaFile)sf, int4);
        Assert.assertEquals((Object)"ALLLLLLLLLLLLLLLLLLLLfinalM191", (Object)sf.getChildNode(int4, "finalM191").getAsMeasurementMNode().getAlias());
        sf.close();
        SchemaFile nsf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        Assert.assertEquals((Object)"alas99999", (Object)nsf.getChildNode(int0, "mint1").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"alas", (Object)nsf.getChildNode(int1, "int1newM").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"BBBBBB", (Object)nsf.getChildNode(int4, "AAAAA").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"ALLLLLLLLLLLLLLLLLLLLfinalM191", (Object)nsf.getChildNode(int4, "finalM191").getAsMeasurementMNode().getAlias());
        nsf.close();
    }

    @Test
    public void testVerticalTree() throws MetadataException, IOException {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.sgvt.vt", (int)0);
        IDatabaseMNode sgNode = ((ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sg", 11111L)).getAsDatabaseMNode();
        sf.updateDatabaseNode(sgNode);
        ICachedMNode root = SchemaFileTest.getVerticalTree(100, "VT");
        Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            this.writeMNodeInTest((ISchemaFile)sf, ite.next());
        }
        ICachedMNode vt1 = this.getNode(root, "root.VT_0.VT_1");
        ICachedMNode vt4 = this.getNode(root, "root.VT_0.VT_1.VT_2.VT_3.VT_4");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt1).getNewChildBuffer().clear();
        SchemaFileTest.addMeasurementChild(vt1, "newM");
        this.writeMNodeInTest((ISchemaFile)sf, vt1);
        ICachedMNode vt0 = this.getNode(root, "root.VT_0");
        Assert.assertEquals((long)ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt1).getSegmentAddress(), (long)RecordUtils.getRecordSegAddr((ByteBuffer)SchemaFileTest.getSegment((ISchemaFile)sf, ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt0).getSegmentAddress()).getRecord("VT_1")));
        Assert.assertEquals((long)2L, (long)SchemaFileTest.getSegment((ISchemaFile)sf, ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt1).getSegmentAddress()).getKeyOffsetList().size());
        sf.close();
        SchemaFile nsf = SchemaFile.loadSchemaFile((String)"root.sgvt.vt", (int)0);
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt4).getNewChildBuffer().clear();
        HashSet<String> newNodes = new HashSet<String>();
        for (int i = 0; i < 15; ++i) {
            SchemaFileTest.addMeasurementChild(vt1, "r1_" + i);
            SchemaFileTest.addMeasurementChild(vt4, "r4_" + i);
            newNodes.add("r1_" + i);
            newNodes.add("r4_" + i);
        }
        this.writeMNodeInTest((ISchemaFile)nsf, vt1);
        this.writeMNodeInTest((ISchemaFile)nsf, vt4);
        nsf.close();
        nsf = SchemaFile.loadSchemaFile((String)"root.sgvt.vt", (int)0);
        Iterator vt1Children = nsf.getChildren(vt1);
        Iterator vt4Children = nsf.getChildren(vt4);
        while (vt1Children.hasNext()) {
            newNodes.remove(((ICachedMNode)vt1Children.next()).getName());
        }
        while (vt4Children.hasNext()) {
            newNodes.remove(((ICachedMNode)vt4Children.next()).getName());
        }
        Assert.assertTrue((boolean)newNodes.isEmpty());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt1).getNewChildBuffer().clear();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)vt4).getNewChildBuffer().clear();
        for (int i = 0; i < 660; ++i) {
            SchemaFileTest.addMeasurementChild(vt1, "2r1_" + i);
            SchemaFileTest.addMeasurementChild(vt4, "2r4_" + i);
            newNodes.add("2r1_" + i);
            newNodes.add("2r4_" + i);
        }
        this.writeMNodeInTest((ISchemaFile)nsf, vt1);
        this.writeMNodeInTest((ISchemaFile)nsf, vt4);
        Assert.assertEquals((long)11111L, (long)nsf.init().getAsDatabaseMNode().getDataTTL());
        nsf.close();
    }

    @Test
    public void testFlatTree() throws MetadataException, IOException {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(SchemaFileTest.getFlatTree(6000, "aa"));
        while (ite.hasNext()) {
            ICachedMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            this.writeMNodeInTest((ISchemaFile)sf, cur);
        }
        ICachedMNode node = (ICachedMNode)nodeFactory.createInternalMNode(null, "a");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node).setSegmentAddress(0L);
        List<Integer> tryReadList = Arrays.asList(199, 1999, 2999, 3999, 4999, 5999);
        for (Integer rid : tryReadList) {
            ICachedMNode target = sf.getChildNode(node, "aa" + rid);
            Assert.assertEquals((Object)("aa" + rid + "als"), (Object)target.getAsMeasurementMNode().getAlias());
        }
        sf.close();
    }

    @Test
    public void testGetChildren() throws MetadataException, IOException {
        this.essentialTestSchemaFile();
        ICachedMNode node = (ICachedMNode)nodeFactory.createInternalMNode(null, "test");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node).setSegmentAddress(SchemaFile.getGlobalIndex((int)2, (short)0));
        SchemaFile sf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        Iterator res = sf.getChildren(node);
        int cnt = 0;
        while (res.hasNext()) {
            res.next();
            ++cnt;
        }
        sf.close();
        Assert.assertEquals((long)1002L, (long)cnt);
    }

    @Test
    public void test2KMeasurement() throws MetadataException, IOException {
        int i = 2000;
        ICachedMNode dbNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 11111111L);
        SchemaFile sf = SchemaFile.initSchemaFile((String)dbNode.getName(), (int)0);
        for (int j = 20; j >= 0; --j) {
            ICachedMNode aDevice = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)dbNode, "dev_" + j).getAsMNode();
            dbNode.addChild((IMNode)aDevice);
        }
        this.writeMNodeInTest((ISchemaFile)sf, dbNode);
        ICachedMNode dev = (ICachedMNode)dbNode.getChildren().get((Object)"dev_2");
        while (i >= 0) {
            ICachedMNode meas = SchemaFileTest.getMeasurementNode(dev, "m_" + i, "ma_" + i);
            dev.addChild((IMNode)meas);
            --i;
        }
        this.writeMNodeInTest((ISchemaFile)sf, dev);
        Assert.assertEquals((Object)"ma_1994", (Object)sf.getChildNode(dev, "m_1994").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"m_19", (Object)sf.getChildNode(dev, "ma_19").getName());
        sf.delete(dev);
        Assert.assertNull((Object)sf.getChildNode(dbNode, "dev_2"));
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMassiveSegment() throws MetadataException, IOException {
        ICachedMNode dbNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 11111111L);
        this.fillChildren(dbNode, 500, "MEN", this::supplyEntity);
        try (SchemaFile sf = SchemaFile.initSchemaFile((String)dbNode.getName(), (int)0);){
            this.writeMNodeInTest((ISchemaFile)sf, dbNode);
        }
        ICachedMNode dbNode2 = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot2", 11111111L);
        this.fillChildren(dbNode2, 5000, "MEN", this::supplyEntity);
        try (SchemaFile sf2 = SchemaFile.initSchemaFile((String)dbNode2.getName(), (int)0);){
            this.writeMNodeInTest((ISchemaFile)sf2, dbNode2);
        }
        int cnt = 0;
        sf = SchemaFile.loadSchemaFile((String)dbNode.getName(), (int)0);
        Iterator ite = sf.getChildren(dbNode);
        while (ite.hasNext()) {
            ++cnt;
            ite.next();
        }
        Assert.assertEquals((long)cnt, (long)500L);
        sf.close();
        cnt = 0;
        sf = SchemaFile.loadSchemaFile((String)dbNode2.getName(), (int)0);
        ite = sf.getChildren(dbNode2);
        while (ite.hasNext()) {
            ++cnt;
            ite.next();
        }
        Assert.assertEquals((long)cnt, (long)5000L);
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDevices() throws MetadataException, IOException {
        int i;
        ICachedMNode dbNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 11111111L);
        for (i = 100; i >= 0; --i) {
            ICachedMNode aDevice = (ICachedMNode)nodeFactory.createInternalMNode((IMNode)dbNode, "dev_" + i);
            dbNode.addChild((IMNode)aDevice);
        }
        Iterator<ICachedMNode> orderedTree = SchemaFileTest.getTreeBFT(dbNode);
        SchemaFile sf = SchemaFile.initSchemaFile((String)dbNode.getName(), (int)0);
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)dbNode).setSegmentAddress(0L);
        ICachedMNode node = null;
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement()) continue;
                this.writeMNodeInTest((ISchemaFile)sf, node);
            }
            for (i = 100; i >= 0; --i) {
                long addr = SchemaFileTest.getSegAddrInContainer((ICachedMNode)dbNode.getChild("dev_" + i));
                ICachedMNode aDevice = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)dbNode, "dev_" + i).getAsMNode();
                dbNode.deleteChild(aDevice.getName());
                dbNode.addChild((IMNode)aDevice);
                SchemaFileTest.moveToUpdateBuffer(dbNode, "dev_" + i);
                ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)aDevice).setSegmentAddress(addr);
            }
            orderedTree = SchemaFileTest.getTreeBFT(dbNode);
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement()) continue;
                this.writeMNodeInTest((ISchemaFile)sf, node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        for (Object etn : dbNode.getChildren().values()) {
            for (int j = 10; j >= 0; --j) {
                SchemaFileTest.addMeasurementChild((ICachedMNode)etn, String.format("mtc_%d_%d", i, j));
            }
        }
        orderedTree = SchemaFileTest.getTreeBFT(dbNode);
        sf = SchemaFile.loadSchemaFile((String)dbNode.getName(), (int)0);
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement() || node.isDatabase()) continue;
                this.writeMNodeInTest((ISchemaFile)sf, node);
                ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node).getNewChildBuffer().clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        HashSet<String> resName = new HashSet<String>();
        for (ICachedMNode etn : dbNode.getChildren().values()) {
            for (int j = 50; j >= 0; --j) {
                SchemaFileTest.addMeasurementChild(etn, String.format("mtc2_%d_%d", i, j));
                if (!(Math.random() > 0.5)) continue;
                resName.add(String.format("mtc2_%d_%d", i, j));
            }
        }
        orderedTree = SchemaFileTest.getTreeBFT(dbNode);
        sf = SchemaFile.loadSchemaFile((String)dbNode.getName(), (int)0);
        ArrayList<ICachedMNode> arbitraryNode = new ArrayList<ICachedMNode>();
        try {
            while (orderedTree.hasNext()) {
                node = orderedTree.next();
                if (node.isMeasurement() || node.isDatabase()) continue;
                this.writeMNodeInTest((ISchemaFile)sf, node);
                if (!(Math.random() > 0.5)) continue;
                arbitraryNode.add(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(node.getName());
        }
        finally {
            sf.close();
        }
        sf = SchemaFile.loadSchemaFile((String)"sgRoot", (int)0);
        for (String key : resName) {
            ICachedMNode resNode = sf.getChildNode((ICachedMNode)arbitraryNode.get((int)((double)arbitraryNode.size() * Math.random())), key);
            Assert.assertTrue((boolean)resNode.getAsMeasurementMNode().getAlias().equals(resNode.getName() + "alias"));
        }
        Iterator res = sf.getChildren((ICachedMNode)arbitraryNode.get((int)((double)arbitraryNode.size() * Math.random())));
        while (res.hasNext()) {
            resName.remove(((ICachedMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)resName.isEmpty());
        sf.close();
    }

    @Test
    public void testUpdateOnFullPageSegment() throws MetadataException, IOException {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        ICachedMNode root = SchemaFileTest.getFlatTree(783, "aa");
        Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(root);
        while (ite.hasNext()) {
            ICachedMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            this.writeMNodeInTest((ISchemaFile)sf, cur);
        }
        root.getChildren().clear();
        root.addChild((IMNode)SchemaFileTest.getMeasurementNode(root, "aa0", "updatedupdatednode"));
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)root).transferAllBufferReceivingToFlushing();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)root).moveMNodeFromNewChildBufferToCache("aa0");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)root).updateMNode("aa0");
        this.writeMNodeInTest((ISchemaFile)sf, root);
        Assert.assertEquals((Object)"updatedupdatednode", (Object)sf.getChildNode(root, "aa0").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"aa0", (Object)sf.getChildNode(root, "updatedupdatednode").getName());
        root.getChildren().clear();
        root.addChild((IMNode)((ICachedMNode)nodeFactory.createDeviceMNode((IMNode)root, "ent1").getAsMNode()));
        ICachedMNode ent1 = (ICachedMNode)root.getChild("ent1");
        ent1.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent1, "m1", "m1a"));
        this.writeMNodeInTest((ISchemaFile)sf, root);
        this.writeMNodeInTest((ISchemaFile)sf, ent1);
        ent1.getChildren().clear();
        ent1.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent1, "m1", "m1aaaaaa"));
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)ent1).transferAllBufferReceivingToFlushing();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)ent1).moveMNodeFromNewChildBufferToCache("m1");
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)ent1).updateMNode("m1");
        Assert.assertEquals((long)63L, (long)SchemaFileTest.getSegment((ISchemaFile)sf, SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent1), "m1")).size());
        this.writeMNodeInTest((ISchemaFile)sf, ent1);
        Assert.assertEquals((long)1020L, (long)SchemaFileTest.getSegment((ISchemaFile)sf, SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent1), "m1")).size());
        ent1.getChildren().clear();
        while (ent1.getChildren().size() < 374) {
            SchemaFileTest.addMeasurementChild(ent1, "nc" + ent1.getChildren().size());
        }
        this.writeMNodeInTest((ISchemaFile)sf, ent1);
        ent1.getChildren().clear();
        ent1.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent1, "nc0", "updated_nc0updated_nc0updated_nc0updated_nc0"));
        SchemaFileTest.moveToUpdateBuffer(ent1, "nc0");
        this.writeMNodeInTest((ISchemaFile)sf, ent1);
        ent1.getChildren().clear();
        ent1.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent1, "nc1", "updated_nc1updated_nc1updated_nc1updated_nc1"));
        SchemaFileTest.moveToUpdateBuffer(ent1, "nc1");
        this.writeMNodeInTest((ISchemaFile)sf, ent1);
        Assert.assertEquals((long)SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent1), "nc1"), (long)SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent1), "nc0"));
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEstimateSegSize() throws Exception {
        ICachedMNode sgNode = (ICachedMNode)nodeFactory.createDatabaseMNode(null, "mma", 111111111L).getAsMNode();
        ICachedMNode d1 = this.fillChildren(sgNode, 300, "d", this::supplyEntity);
        try (SchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);){
            this.writeMNodeInTest((ISchemaFile)sf, sgNode);
            this.fillChildren(d1, 46, "s", this::supplyMeasurement);
            this.writeMNodeInTest((ISchemaFile)sf, d1);
            SchemaFileTest.moveAllToBuffer(d1);
            SchemaFileTest.moveAllToBuffer(sgNode);
            this.fillChildren(sgNode, 350, "sd", this::supplyEntity);
            this.writeMNodeInTest((ISchemaFile)sf, sgNode);
            this.fillChildren(d1, 20, "ss", this::supplyMeasurement);
            this.writeMNodeInTest((ISchemaFile)sf, d1);
            Iterator verifyChildren = sf.getChildren(d1);
            int cnt = 0;
            while (verifyChildren.hasNext()) {
                ++cnt;
                verifyChildren.next();
            }
            Assert.assertEquals((long)66L, (long)cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void test2KAlias() throws Exception {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        ICachedMNode sgNode = (ICachedMNode)nodeFactory.createDatabaseMNode(null, "mma", 111111111L).getAsMNode();
        int factor2K = 2000;
        ArrayList<ICachedMNode> devs = new ArrayList<ICachedMNode>();
        ArrayList senList = new ArrayList();
        HashMap<String, String> aliasAns = new HashMap<String, String>();
        try {
            for (int i = 0; i < 5; ++i) {
                devs.add((ICachedMNode)nodeFactory.createDeviceMNode((IMNode)sgNode, "d_" + i).getAsMNode());
                sgNode.addChild((IMNode)((ICachedMNode)devs.get(i)));
            }
            for (ICachedMNode dev : devs) {
                ArrayList<ICachedMNode> arrayList = new ArrayList<ICachedMNode>();
                for (int i = 0; i < factor2K; ++i) {
                    arrayList.add(SchemaFileTest.getMeasurementNode(dev, "s_" + i, null));
                    dev.addChild((IMNode)((ICachedMNode)arrayList.get(i)));
                    if (!dev.getName().equals("d_0")) continue;
                    aliasAns.put("s_" + i, "als_" + i);
                }
                senList.add(arrayList);
            }
            Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(sgNode);
            while (ite.hasNext()) {
                ICachedMNode curNode = ite.next();
                if (curNode.isMeasurement()) continue;
                this.writeMNodeInTest((ISchemaFile)sf, curNode);
            }
        }
        finally {
            sf.sync();
            sf.close();
        }
        sf = SchemaFile.loadSchemaFile((String)"root.sg", (int)0);
        try {
            void var9_18;
            ICachedMNode dev2 = (ICachedMNode)devs.get(2);
            for (ICachedMNode iCachedMNode : dev2.getChildren().values()) {
                iCachedMNode.getAsMeasurementMNode().setAlias((String)aliasAns.get(iCachedMNode.getName()));
            }
            for (String string : aliasAns.keySet()) {
                SchemaFileTest.moveToUpdateBuffer(dev2, string);
            }
            this.writeMNodeInTest((ISchemaFile)sf, dev2);
            sf.sync();
            sf.close();
            sf = SchemaFile.loadSchemaFile((String)"root.sg", (int)0);
            for (Map.Entry entry : aliasAns.entrySet()) {
                Assert.assertEquals(entry.getKey(), (Object)sf.getChildNode(dev2, (String)entry.getValue()).getName());
            }
            Iterator children = sf.getChildren(dev2);
            boolean bl = false;
            while (children.hasNext()) {
                ++var9_18;
                children.next();
            }
            Assert.assertEquals((long)factor2K, (long)((long)var9_18));
        }
        finally {
            sf.close();
        }
    }

    @Test
    public void testRearrangementWhenInsert() throws MetadataException, IOException {
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.sg", (int)0);
        ICachedMNode root = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 0L);
        root.getChildren().clear();
        ICachedMNode ent2 = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)root, "ent2").getAsMNode();
        ICachedMNode ent3 = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)root, "ent3").getAsMNode();
        ICachedMNode ent4 = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)root, "ent4").getAsMNode();
        root.addChild((IMNode)ent2);
        root.addChild((IMNode)ent3);
        root.addChild((IMNode)ent4);
        while (ent4.getChildren().size() < 19) {
            ent4.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent4, "e4m" + ent4.getChildren().size(), "e4malais" + ent4.getChildren().size()));
        }
        this.writeMNodeInTest((ISchemaFile)sf, root);
        this.writeMNodeInTest((ISchemaFile)sf, ent4);
        ent4.getChildren().clear();
        ent4.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent4, "e4m0", "updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_updated_"));
        SchemaFileTest.moveToUpdateBuffer(ent4, "e4m0");
        this.writeMNodeInTest((ISchemaFile)sf, ent4);
        while (ent2.getChildren().size() < 19) {
            ent2.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent2, "e2m" + ent2.getChildren().size(), "e2malais" + ent2.getChildren().size()));
        }
        this.writeMNodeInTest((ISchemaFile)sf, ent2);
        while (ent3.getChildren().size() < 180) {
            ent3.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent3, "e3m" + ent3.getChildren().size(), "e3malais" + ent3.getChildren().size()));
        }
        this.writeMNodeInTest((ISchemaFile)sf, ent3);
        ent2.getChildren().clear();
        while (ent2.getChildren().size() < 70) {
            ent2.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent2, "e2ms" + ent2.getChildren().size(), "e2is_s2_" + ent2.getChildren().size()));
        }
        this.writeMNodeInTest((ISchemaFile)sf, ent2);
        Assert.assertEquals((long)(SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent2), "e2m0") + 65536L), (long)SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent3), "e3m0"));
        Assert.assertEquals((long)(SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent2), "e2m0") + 2L), (long)SchemaFileTest.getSegAddr((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent4), "e4m0"));
        root.getChildren().clear();
        ICachedMNode ent5 = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)root, "ent5").getAsMNode();
        root.addChild((IMNode)ent5);
        while (ent5.getChildren().size() < 19) {
            ent5.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent5, "e5mk" + ent5.getChildren().size(), "e5malaikkkkks" + ent5.getChildren().size()));
        }
        this.writeMNodeInTest((ISchemaFile)sf, root);
        this.writeMNodeInTest((ISchemaFile)sf, ent5);
        ent5.getChildren().clear();
        ent5.addChild((IMNode)SchemaFileTest.getMeasurementNode(ent5, "e5extm", "e5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkks"));
        this.writeMNodeInTest((ISchemaFile)sf, ent5);
        Assert.assertEquals((long)20L, (long)SchemaFileTest.getSegment((ISchemaFile)sf, SchemaFileTest.getSegAddrInContainer(ent5)).getAllRecords().size());
        Assert.assertEquals((Object)"e5extm", (Object)sf.getChildNode(ent5, "e5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkkse5malaikkkkks").getName());
        ent5.getChildren().clear();
        SchemaFileTest.addNodeToUpdateBuffer(ent5, SchemaFileTest.getMeasurementNode(ent5, "e5extm", null));
        this.writeMNodeInTest((ISchemaFile)sf, ent5);
        Assert.assertEquals(null, (Object)sf.getChildNode(ent5, "e5extm").getAsMeasurementMNode().getAlias());
        sf.close();
    }

    @Test
    public void bitwiseTest() {
        long initGlbAdr = 0x10010000000L;
        int pageIndex = SchemaFile.getPageIndex((long)initGlbAdr);
        for (int bs = 1; bs <= 32; ++bs) {
            long highBits = 0xFFFFFFFF00000000L & (0xFFFFFFFFL & (long)pageIndex) << 1;
            pageIndex <<= 1;
            pageIndex = (int)((long)pageIndex | highBits >>> 32);
            Assert.assertEquals((long)pageIndex, (long)SchemaFile.getPageIndex((long)SchemaFile.getGlobalIndex((int)pageIndex, (short)0)));
        }
        short segIdx = SchemaFile.getSegIndex((long)initGlbAdr);
        while (initGlbAdr < 1099980063232L) {
            Assert.assertEquals((long)initGlbAdr, (long)SchemaFile.getGlobalIndex((int)pageIndex, (short)segIdx));
            pageIndex = SchemaFile.getPageIndex((long)(initGlbAdr += 0x80000000L));
            segIdx = SchemaFile.getSegIndex((long)initGlbAdr);
        }
    }

    @Test
    public void basicTest() throws IOException, MetadataException {
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 16000;
        ICachedMNode sgNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 11111111L);
        HashSet<String> checkSet = new HashSet<String>();
        for (int i = 10000; i >= 0; --i) {
            String name = Integer.toString(i);
            if (i < 10) {
                name = "00" + name;
            } else if (i < 100) {
                name = "0" + name;
            }
            ICachedMNode aMeas = SchemaFileTest.getMeasurementNode(sgNode, "s_" + name, null);
            checkSet.add(aMeas.getName());
            sgNode.addChild((IMNode)aMeas);
        }
        Iterator<ICachedMNode> orderedTree = SchemaFileTest.getTreeBFT(sgNode);
        SchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        this.writeMNodeInTest((ISchemaFile)sf, sgNode);
        Iterator res = sf.getChildren(sgNode);
        while (res.hasNext()) {
            checkSet.remove(((ICachedMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sf.close();
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 0;
    }

    @Test
    public void basicSplitTest() throws MetadataException, IOException {
        ICachedMNode aMeas;
        String name;
        int j;
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 16230;
        SchemaFileConfig.DETAIL_SKETCH = true;
        ICachedMNode sgNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "sgRoot", 11111111L);
        HashSet<String> checkSet = new HashSet<String>();
        for (int i = 999; i >= 0; --i) {
            String name2 = Integer.toString(i);
            if (i < 10) {
                name2 = "00" + name2;
            } else if (i < 100) {
                name2 = "0" + name2;
            }
            ICachedMNode aMeas2 = SchemaFileTest.getMeasurementNode(sgNode, "s_" + name2, null);
            checkSet.add(aMeas2.getName());
            sgNode.addChild((IMNode)aMeas2);
        }
        SchemaFile sf = SchemaFile.initSchemaFile((String)sgNode.getName(), (int)0);
        this.writeMNodeInTest((ISchemaFile)sf, sgNode);
        Iterator res = sf.getChildren(sgNode);
        while (res.hasNext()) {
            checkSet.remove(((ICachedMNode)res.next()).getName());
        }
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sgNode.getChildren().clear();
        for (j = 50; j >= 0; --j) {
            name = Integer.toString(j);
            if (j < 10) {
                name = "00" + name;
            } else if (j < 100) {
                name = "0" + name;
            }
            aMeas = (ICachedMNode)nodeFactory.createInternalMNode((IMNode)sgNode, "d_" + name);
            sgNode.addChild((IMNode)aMeas);
        }
        for (j = 560; j >= 0; --j) {
            name = Integer.toString(j);
            if (j < 10) {
                name = "00" + name;
            } else if (j < 100) {
                name = "0" + name;
            }
            aMeas = (ICachedMNode)nodeFactory.createInternalMNode((IMNode)sgNode, "dd2_" + name);
            checkSet.add(aMeas.getName());
            ((ICachedMNode)sgNode.getChildren().get((Object)"d_010")).addChild((IMNode)aMeas);
        }
        ICachedMNode d010 = (ICachedMNode)sgNode.getChildren().get((Object)"d_010");
        MNodeUtils.setToEntity((IMNode)d010);
        ICachedMNode ano = SchemaFileTest.getMeasurementNode(d010, "splitover", "aliaslasialsai");
        d010.addChild((IMNode)ano);
        sgNode.addChild((IMNode)d010);
        this.writeMNodeInTest((ISchemaFile)sf, sgNode);
        this.writeMNodeInTest((ISchemaFile)sf, (ICachedMNode)sgNode.getChildren().get((Object)"d_010"));
        ano.getAsMeasurementMNode().setAlias("aliaslasialsaialiaslasialsai");
        d010.getChildren().clear();
        d010.addChild((IMNode)ano);
        SchemaFileTest.moveToUpdateBuffer(d010, "splitover");
        this.writeMNodeInTest((ISchemaFile)sf, d010);
        int d010cs = 0;
        Iterator res2 = sf.getChildren(d010);
        while (res2.hasNext()) {
            checkSet.add(((ICachedMNode)res2.next()).getName());
            ++d010cs;
        }
        sf.close();
        SchemaFile sf2 = SchemaFile.loadSchemaFile((String)"sgRoot", (int)0);
        res2 = sf2.getChildren(d010);
        while (res2.hasNext()) {
            checkSet.remove(((ICachedMNode)res2.next()).getName());
            --d010cs;
        }
        Assert.assertEquals((Object)"aliaslasialsaialiaslasialsai", (Object)sf2.getChildNode(d010, "splitover").getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)"splitover", (Object)sf2.getChildNode(d010, "aliaslasialsaialiaslasialsai").getName());
        Assert.assertEquals((long)0L, (long)d010cs);
        Assert.assertTrue((boolean)checkSet.isEmpty());
        sf2.close();
        SchemaFileConfig.INTERNAL_SPLIT_VALVE = 0;
    }

    private void printSF(ISchemaFile file) throws IOException, MetadataException {
        ((SchemaFile)file).inspect();
    }

    public static void print(Object o) {
        System.out.println(o.toString());
    }

    private static WrappedSegment getSegment(ISchemaFile sf, long address) {
        try {
            return ((SchemaFile)sf).getPageOnTest(SchemaFile.getPageIndex((long)address)).getSegmentOnTest(SchemaFile.getSegIndex((long)address));
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long getSegAddr(ISchemaFile sf, long curAddr, String key) {
        try {
            return ((SchemaFile)sf).getTargetSegmentOnTest(curAddr, key);
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private ICachedMNode supplyMeasurement(ICachedMNode par, String name) {
        return SchemaFileTest.getMeasurementNode(par, name, name + "_als");
    }

    private ICachedMNode supplyInternal(ICachedMNode par, String name) {
        return (ICachedMNode)nodeFactory.createInternalMNode((IMNode)par, name);
    }

    private ICachedMNode supplyEntity(ICachedMNode par, String name) {
        return (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)par, name).getAsMNode();
    }

    private ICachedMNode fillChildren(ICachedMNode par, int number, String prefix, BiFunction<ICachedMNode, String, ICachedMNode> nodeFactory) {
        ICachedMNode lastChild = null;
        for (int i = 0; i < number; ++i) {
            String childName = prefix + "_" + i;
            lastChild = nodeFactory.apply(par, childName);
            par.addChild((IMNode)lastChild);
        }
        return lastChild;
    }

    static void addMeasurementChild(ICachedMNode par, String mid) {
        par.addChild((IMNode)SchemaFileTest.getMeasurementNode(par, mid, mid + "alias"));
    }

    static IMeasurementSchema getSchema(String id) {
        return new MeasurementSchema(id, TSDataType.FLOAT);
    }

    private ICachedMNode getNode(ICachedMNode root, String path) throws MetadataException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        ICachedMNode cur = root;
        for (String node : pathNodes) {
            if (node.equals("root")) continue;
            cur = (ICachedMNode)cur.getChild(node);
        }
        return cur;
    }

    static ICachedMNode getInternalWithSegAddr(ICachedMNode par, String name, long segAddr) {
        ICachedMNode node = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)par, name).getAsMNode();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node).setSegmentAddress(segAddr);
        return node;
    }

    static ICachedMNode getMeasurementNode(ICachedMNode par, String name, String alias) {
        MeasurementSchema schema = new MeasurementSchema(name, TSDataType.FLOAT);
        return (ICachedMNode)nodeFactory.createMeasurementMNode(par.getAsDeviceMNode(), name, (IMeasurementSchema)schema, alias).getAsMNode();
    }

    static void addNodeToUpdateBuffer(ICachedMNode par, ICachedMNode child) {
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).remove((Object)child.getName());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).appendMNode(child);
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).transferAllBufferReceivingToFlushing();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).moveMNodeFromNewChildBufferToCache(child.getName());
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).updateMNode(child.getName());
    }

    static void moveToUpdateBuffer(ICachedMNode par, String childName) {
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).appendMNode((ICachedMNode)par.getChild(childName));
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).transferAllBufferReceivingToFlushing();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).moveMNodeFromNewChildBufferToCache(childName);
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).updateMNode(childName);
    }

    static void moveAllToUpdate(ICachedMNode par) {
        List childNames = par.getChildren().values().stream().map(IMNode::getName).collect(Collectors.toList());
        for (String name : childNames) {
            ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).moveMNodeFromNewChildBufferToCache(name);
            ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).updateMNode(name);
        }
    }

    static void moveAllToBuffer(ICachedMNode par) {
        List childNames = par.getChildren().values().stream().map(IMNode::getName).collect(Collectors.toList());
        for (String name : childNames) {
            ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).moveMNodeFromNewChildBufferToCache(name);
        }
    }

    static long getSegAddrInContainer(ICachedMNode par) {
        return ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)par).getSegmentAddress();
    }

    static ICachedMNode virtualTriangleMTree(int size, String sgPath) throws MetadataException {
        int idx;
        IMeasurementMNode mNode;
        MeasurementSchema schema;
        String[] sgPathNodes = PathUtils.splitPathToDetachedNodes((String)sgPath);
        ICachedMNode upperNode = null;
        for (String name : sgPathNodes) {
            upperNode = (ICachedMNode)nodeFactory.createInternalMNode(upperNode, name);
        }
        ICachedMNode internalNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(upperNode, "vRoot1", 0L);
        for (int idx2 = 0; idx2 < size; ++idx2) {
            String measurementId = "mid" + idx2;
            schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            mNode = nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), measurementId, (IMeasurementSchema)schema, measurementId + "als");
            internalNode.addChild((IMNode)((ICachedMNode)mNode.getAsMNode()));
        }
        ICachedMNode curNode = internalNode;
        for (idx = 0; idx < size; ++idx) {
            String nodeName = "int" + idx;
            ICachedMNode newNode = (ICachedMNode)nodeFactory.createDeviceMNode((IMNode)curNode, nodeName).getAsMNode();
            curNode.addChild((IMNode)newNode);
            curNode = newNode;
        }
        for (idx = 0; idx < 1000; ++idx) {
            schema = new MeasurementSchema("finalM" + idx, TSDataType.FLOAT);
            mNode = nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), "finalM" + idx, (IMeasurementSchema)schema, "finalals" + idx);
            curNode.addChild((IMNode)((ICachedMNode)mNode.getAsMNode()));
        }
        MeasurementSchema schema2 = new MeasurementSchema("finalM", TSDataType.FLOAT);
        IMeasurementMNode mNode2 = nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), "finalM", (IMeasurementSchema)schema2, "finalals");
        curNode.addChild((IMNode)((ICachedMNode)mNode2.getAsMNode()));
        upperNode.addChild((IMNode)internalNode);
        return internalNode;
    }

    static ICachedMNode getFlatTree(int flatSize, String id) {
        ICachedMNode root = (ICachedMNode)nodeFactory.createInternalMNode(null, "root");
        ICachedMNode test = (ICachedMNode)nodeFactory.createInternalMNode((IMNode)root, "test");
        ICachedMNode internalNode = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "vRoot1", 0L);
        for (int idx = 0; idx < flatSize; ++idx) {
            String measurementId = id + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), measurementId, (IMeasurementSchema)schema, measurementId + "als");
            internalNode.addChild((IMNode)((ICachedMNode)mNode.getAsMNode()));
        }
        test.addChild((IMNode)internalNode);
        return internalNode;
    }

    static ICachedMNode getVerticalTree(int height, String id) {
        ICachedMNode trueRoot = (ICachedMNode)nodeFactory.createInternalMNode(null, "root");
        trueRoot.addChild((IMNode)((ICachedMNode)nodeFactory.createInternalMNode((IMNode)trueRoot, "sgvt")));
        ICachedMNode root = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, "vt", 0L);
        ICachedMNode cur = root;
        for (int cnt = 0; cnt < height; ++cnt) {
            cur.addChild((IMNode)((ICachedMNode)nodeFactory.createDeviceMNode((IMNode)cur, id + "_" + cnt).getAsMNode()));
            cur = (ICachedMNode)cur.getChild(id + "_" + cnt);
        }
        ((ICachedMNode)trueRoot.getChild("sgvt")).addChild((IMNode)root);
        return root;
    }

    static Iterator<ICachedMNode> getTreeBFT(final ICachedMNode root) {
        return new Iterator<ICachedMNode>(){
            final Queue<ICachedMNode> queue = new LinkedList<ICachedMNode>();
            {
                this.queue.add(root);
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public ICachedMNode next() {
                ICachedMNode curNode = this.queue.poll();
                if (!curNode.isMeasurement() && curNode.getChildren().size() > 0) {
                    for (ICachedMNode child : curNode.getChildren().values()) {
                        this.queue.add(child);
                    }
                }
                return curNode;
            }
        };
    }
}

