/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.schemafile.SchemaFileTest;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFileLogTest {
    private static final int TEST_SCHEMA_REGION_ID = 0;
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.PBTree.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void essentialLogTest() throws IOException, MetadataException {
        String previousConsensus = IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass();
        IoTDBDescriptor.getInstance().getConfig().setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.simple.SimpleConsensus");
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)0);
        IDatabaseMNode newSGNode = ((ICachedMNode)this.nodeFactory.createDatabaseDeviceMNode(null, "newSG", 10000L)).getAsDatabaseMNode();
        sf.updateDatabaseNode(newSGNode);
        ICachedMNode root = SchemaFileTest.virtualTriangleMTree(5, "root.test");
        Iterator<ICachedMNode> ite = SchemaFileTest.getTreeBFT(root);
        ICachedMNode lastNode = null;
        while (ite.hasNext()) {
            ICachedMNode curNode = ite.next();
            if (curNode.isMeasurement()) continue;
            ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)curNode);
            container.transferAllBufferReceivingToFlushing();
            sf.writeMNode(curNode);
            lastNode = curNode;
        }
        long address = SchemaFileTest.getSegAddrInContainer(lastNode);
        int corruptPageIndex = SchemaFile.getPageIndex((long)address);
        ISegmentedPage corPage = ISchemaPage.initSegmentedPage((ByteBuffer)ByteBuffer.allocate(16384), (int)corruptPageIndex);
        Iterator res = sf.getChildren(lastNode);
        int cnt = 0;
        while (res.hasNext()) {
            ++cnt;
            res.next();
        }
        try {
            Class<SchemaFile> schemaFileClass = SchemaFile.class;
            Field channelField = schemaFileClass.getDeclaredField("channel");
            channelField.setAccessible(true);
            FileChannel fileChannel = (FileChannel)channelField.get(sf);
            corPage.flushPageToChannel(fileChannel);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            sf.close();
        }
        sf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        try {
            sf.getChildren(lastNode);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)String.format("Segment(index:0) not found in page(index:%d).", corruptPageIndex), (Object)e.getMessage());
        }
        finally {
            sf.close();
        }
        try (FileOutputStream outputStream = null;){
            CharSequence[] logFilePath = new String[]{"target", "tmp", "system", "schema", "root.test.vRoot1", "0", "pbtree_log.bin"};
            File logFile = new File(String.join((CharSequence)File.separator, logFilePath));
            outputStream = new FileOutputStream(logFile, true);
            FileChannel channel = outputStream.getChannel();
            channel.truncate(channel.size() - 1L);
        }
        sf = SchemaFile.loadSchemaFile((String)"root.test.vRoot1", (int)0);
        res = sf.getChildren(lastNode);
        int cnt2 = 0;
        while (res.hasNext()) {
            res.next();
            ++cnt2;
        }
        Assert.assertEquals((long)cnt, (long)cnt2);
        sf.close();
        IoTDBDescriptor.getInstance().getConfig().setSchemaRegionConsensusProtocolClass(previousConsensus);
    }
}

