/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordUtilTests {
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void internalNodeTest() throws MetadataException {
        ICachedMNode oneNode = (ICachedMNode)this.nodeFactory.createInternalMNode(null, "abcd");
        ICachedMNode twoNode = (ICachedMNode)this.nodeFactory.createDeviceMNode(null, "efgh").getAsMNode();
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)oneNode).setSegmentAddress(1234567L);
        ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)twoNode).setSegmentAddress(66666L);
        twoNode.getAsDeviceMNode().setUseTemplate(true);
        ByteBuffer buffer = RecordUtils.node2Buffer((ICachedMNode)oneNode);
        buffer.clear();
        ICachedMNode node1 = RecordUtils.buffer2Node((String)"abcd", (ByteBuffer)buffer);
        Assert.assertEquals((long)1234567L, (long)ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node1).getSegmentAddress());
        buffer = RecordUtils.node2Buffer((ICachedMNode)twoNode);
        buffer.clear();
        node1 = RecordUtils.buffer2Node((String)"efgh", (ByteBuffer)buffer);
        Assert.assertEquals((long)66666L, (long)ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)node1).getSegmentAddress());
        Assert.assertTrue((boolean)node1.getAsDeviceMNode().isUseTemplate());
    }

    @Test
    public void measurementTest() throws MetadataException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ka", "va");
        props.put("kb", "vb");
        MeasurementSchema schema = new MeasurementSchema("amn", TSDataType.FLOAT, TSEncoding.BITMAP, CompressionType.GZIP, props);
        ICachedMNode amn = (ICachedMNode)this.nodeFactory.createMeasurementMNode(null, "amn", (IMeasurementSchema)schema, "anothername").getAsMNode();
        ByteBuffer tBuf = RecordUtils.node2Buffer((ICachedMNode)amn);
        tBuf.clear();
        Assert.assertFalse((boolean)RecordUtils.buffer2Node((String)"name", (ByteBuffer)tBuf).getAsMeasurementMNode().isPreDeleted());
        amn.getAsMeasurementMNode().setPreDeleted(true);
        tBuf = RecordUtils.node2Buffer((ICachedMNode)amn);
        tBuf.clear();
        Assert.assertTrue((boolean)RecordUtils.buffer2Node((String)"name", (ByteBuffer)tBuf).getAsMeasurementMNode().isPreDeleted());
        ByteBuffer buffer = RecordUtils.node2Buffer((ICachedMNode)amn);
        buffer.clear();
        ICachedMNode node2 = RecordUtils.buffer2Node((String)"amn", (ByteBuffer)buffer);
        Assert.assertTrue((boolean)amn.getAsMeasurementMNode().getSchema().equals(node2.getAsMeasurementMNode().getSchema()));
        Assert.assertEquals((Object)node2.getAsMeasurementMNode().getAlias(), (Object)amn.getAsMeasurementMNode().getAlias());
        Assert.assertEquals((Object)true, (Object)node2.getAsMeasurementMNode().isPreDeleted());
        Assert.assertEquals(props, (Object)node2.getAsMeasurementMNode().getSchema().getProps());
    }
}

