/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MonitorTest {
    private ReleaseFlushMonitor releaseFlushMonitor;

    @Before
    public void setUp() {
        this.releaseFlushMonitor = ReleaseFlushMonitor.getInstance();
    }

    @After
    public void tearDown() throws IOException {
        this.releaseFlushMonitor.clear();
    }

    private void mockCachedMTreeStore(int size) {
        int i = 1;
        while (i <= size) {
            CachedMTreeStore mockStore = (CachedMTreeStore)Mockito.mock(CachedMTreeStore.class);
            int finalI = i++;
            CachedSchemaRegionStatistics mockStatistics = (CachedSchemaRegionStatistics)Mockito.mock(CachedSchemaRegionStatistics.class);
            Mockito.when((Object)mockStore.getRegionStatistics()).then(o -> mockStatistics);
            Mockito.when((Object)mockStatistics.getSchemaRegionId()).then(o -> finalI);
            LockManager lockManager = new LockManager();
            Mockito.when((Object)mockStore.getLockManager()).then(o -> lockManager);
            this.releaseFlushMonitor.registerCachedMTreeStore(mockStore);
        }
    }

    @Test
    public void testGetRegionsToFlush() {
        this.mockCachedMTreeStore(5);
        this.setRecord(1, Arrays.asList(0L, 2L, 3L, 3000L, 4000L), Arrays.asList(100L, 2500L, 200L, 5000L, 6000L));
        this.setRecord(2, Arrays.asList(0L, 2L, 3L, 3000L, 4000L), Arrays.asList(100L, 1000L, 200L, 5500L, 6000L));
        this.setRecord(3, Arrays.asList(700L, 800L), Arrays.asList(900L, 6000L));
        this.setRecord(4, Arrays.asList(700L, 800L, 2500L), Arrays.asList(1000L, 1500L, 5000L));
        this.setRecord(5, Arrays.asList(0L, 2000L), Arrays.asList(1000L, 3900L));
        List regions = this.releaseFlushMonitor.getRegionsToFlush(5000L);
        Assert.assertEquals((long)3L, (long)regions.size());
        Assert.assertEquals((long)5L, (long)((Integer)regions.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)regions.get(1)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)regions.get(2)).intValue());
    }

    @Test
    public void testGetRegionsToFlush2() {
        this.mockCachedMTreeStore(2);
        this.setRecord(1, Arrays.asList(0L, 2000L), Arrays.asList(100L, 7000L));
        this.setRecord(2, Collections.singletonList(3000L), Collections.singletonList(3500L));
        List regions = this.releaseFlushMonitor.getRegionsToFlush(7000L);
        Assert.assertEquals((long)1L, (long)regions.size());
        Assert.assertEquals((long)2L, (long)((Integer)regions.get(0)).intValue());
    }

    private void setRecord(int regionId, List<Long> startTimes, List<Long> eneTimes) {
        this.releaseFlushMonitor.initRecordList(regionId);
        for (int i = 0; i < startTimes.size(); ++i) {
            ReleaseFlushMonitor.RecordNode node = this.releaseFlushMonitor.recordTraverserTime(regionId);
            node.setStartTime(startTimes.get(i));
            node.setEndTime(eneTimes.get(i));
        }
    }
}

