/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AliasIndexPageTest {
    @Before
    public void setUp() {
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.PBTree.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void initTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        ISegment seg = ISchemaPage.initAliasIndexPage((ByteBuffer)buffer, (int)0).getAsAliasIndexPage();
        String[] testKey = new String[]{"abc", "key3", "key4", "key9", "key5", "key6", "key112", "key888"};
        String[] testName = new String[]{"abc_a", "key3_a", "key4_a", "key9_a", "key5_a", "key6_a", "key112_a", "key888_a"};
        for (int i = 0; i < testKey.length; ++i) {
            seg.insertRecord(testKey[i], (Object)testName[i]);
        }
        seg.syncBuffer();
        buffer.clear();
        ISegment seg2 = ISchemaPage.loadSchemaPage((ByteBuffer)buffer).getAsAliasIndexPage();
        Assert.assertEquals((Object)seg.inspect(), (Object)seg2.inspect());
        Assert.assertTrue((boolean)seg2.hasRecordKey("key5"));
        Assert.assertFalse((boolean)seg2.hasRecordKey("key51"));
        Assert.assertEquals((Object)"key4_a", (Object)seg2.getRecordByKey("key4"));
        Assert.assertEquals(null, (Object)seg2.getRecordByKey("abd"));
        Assert.assertEquals(null, (Object)seg2.getRecordByKey("zzz"));
    }

    @Test
    public void evenSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(170);
        ISegment seg = ISchemaPage.initAliasIndexPage((ByteBuffer)buffer, (int)0).getAsAliasIndexPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        String[] name = this.companionName(test);
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)name[i]);
        }
        ByteBuffer buf2 = ByteBuffer.allocate(170);
        String sk = seg.splitByKey("a8", (Object)"alias", buf2, true);
        Assert.assertEquals((Object)"a5", (Object)sk);
        buf2.clear();
        ISegment seg2 = ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage();
        Assert.assertEquals((Object)"a5_nm", (Object)seg2.getRecordByKey("a5"));
        Assert.assertEquals((Object)"a6_nm", (Object)seg2.getRecordByKey("a6"));
        Assert.assertEquals((Object)"alias", (Object)seg2.getRecordByKey("a8"));
        Assert.assertEquals((Object)"a3_nm", (Object)seg.getRecordByKey("a3"));
    }

    @Test
    public void increasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(400);
        ISegment seg = ISchemaPage.initAliasIndexPage((ByteBuffer)buffer, (int)0).getAsAliasIndexPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        String[] name = this.companionName(test);
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)name[i]);
        }
        seg.insertRecord("a61", (Object)"a61_nm");
        seg.insertRecord("a62", (Object)"a62_nm");
        seg.insertRecord("a63", (Object)"a63_nm");
        ByteBuffer buf2 = ByteBuffer.allocate(400);
        String sk = seg.splitByKey("a99", (Object)"a99_nm", buf2, true);
        Assert.assertEquals((Object)"a99", (Object)sk);
        Assert.assertEquals((Object)"a99_nm", (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().getRecordByKey("a99"));
        int spare = seg.getSpareSize();
        Assert.assertEquals((long)spare, (long)seg.insertRecord("a1", (Object)"a1alias"));
        Assert.assertEquals((long)(spare -= 10 + "a1e".getBytes().length + "a1alias".getBytes().length), (long)seg.insertRecord("a1e", (Object)"a1alias"));
        seg.insertRecord("a21", (Object)"a21_nm");
        seg.insertRecord("a22", (Object)"a22_nm");
        seg.insertRecord("a23", (Object)"a23_nm");
        sk = seg.splitByKey("a64", (Object)"a64_mm", buf2, true);
        Assert.assertEquals((Object)"a64", (Object)sk);
        seg.insertRecord("a11", (Object)"a11_nm");
        seg.insertRecord("a12", (Object)"a12_nm");
        buf2.clear();
        sk = seg.splitByKey("a24", (Object)"a24_nm", buf2, true);
        Assert.assertEquals((Object)"a24", (Object)sk);
        buf2.clear();
        Assert.assertEquals((Object)"a24_nm", (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().getRecordByKey("a24"));
        spare = seg.getSpareSize();
        Assert.assertEquals((long)spare, (long)seg.insertRecord("a1", (Object)"a1_nm"));
        buf2.clear();
        spare = ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().getSpareSize();
        Assert.assertEquals((long)(spare - 10 - "a24e".getBytes().length - "a24_nm".getBytes().length), (long)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().insertRecord("a24e", (Object)"a24_nm"));
    }

    @Test
    public void decreasingSplitTest() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(350);
        ISegment seg = ISchemaPage.initAliasIndexPage((ByteBuffer)buffer, (int)0).getAsAliasIndexPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a9"};
        String[] name = this.companionName(test);
        for (int i = test.length - 1; i >= 0; --i) {
            seg.insertRecord(test[i], (Object)name[i]);
        }
        ByteBuffer buf2 = ByteBuffer.allocate(350);
        String sk = seg.splitByKey("a0", (Object)"a0_nm", buf2, true);
        Assert.assertEquals((Object)"a1", (Object)sk);
        short spare = seg.getSpareSize();
        Assert.assertEquals((long)spare, (long)seg.insertRecord("a0", (Object)"a00"));
        buf2.clear();
        spare = ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().getSpareSize();
        Assert.assertEquals((long)spare, (long)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().insertRecord("a2", (Object)"a222"));
        seg.insertRecord("a13", (Object)"a133");
        seg.insertRecord("a12", (Object)"a122");
        sk = seg.splitByKey("a11", (Object)"a11_nm", buf2, true);
        Assert.assertEquals((Object)"a11", (Object)sk);
        spare = seg.getSpareSize();
        Assert.assertEquals((long)spare, (long)seg.insertRecord("a0", (Object)"a00"));
        buf2.clear();
        Assert.assertEquals((Object)"a11_nm", (Object)ISchemaPage.loadSchemaPage((ByteBuffer)buf2).getAsAliasIndexPage().getRecordByKey("a11"));
    }

    @Test
    public void increasingOnLowIndex() throws MetadataException {
        ByteBuffer buffer = ByteBuffer.allocate(300);
        ISegment seg = ISchemaPage.initAliasIndexPage((ByteBuffer)buffer, (int)0).getAsAliasIndexPage();
        String[] test = new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9"};
        for (int i = 0; i < test.length; ++i) {
            seg.insertRecord(test[i], (Object)(test[i] + "_al"));
        }
        seg.insertRecord("a01", (Object)"a0011");
        seg.insertRecord("a02", (Object)"a0022");
        ByteBuffer buf2 = ByteBuffer.allocate(300);
        String sk = seg.splitByKey("a04", (Object)"a0044", buf2, true);
        Assert.assertEquals((Object)"a3", (Object)sk);
        Assert.assertEquals((long)5L, (long)seg.getAllRecords().size());
    }

    private String[] companionName(String[] alias) {
        String[] res = new String[alias.length];
        for (int i = 0; i < alias.length; ++i) {
            res[i] = alias[i] + "_nm";
        }
        return res;
    }

    public void print(ByteBuffer buf) throws MetadataException {
        System.out.println(ISchemaPage.loadSchemaPage((ByteBuffer)buf).getAsAliasIndexPage().inspect());
    }

    public void print(Object s) {
        System.out.println(s);
    }
}

