/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.lock;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.StampedWriterPreferredLock;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class StampedWriterPreferredLockTest {
    @Test
    public void testStampReadLock() {
        StampedWriterPreferredLock lock = new StampedWriterPreferredLock();
        Semaphore semaphore = new Semaphore(0);
        AtomicInteger counter = new AtomicInteger();
        AtomicLong stamp = new AtomicLong();
        new Thread(() -> {
            stamp.set(lock.stampedReadLock());
            semaphore.release(2);
            counter.incrementAndGet();
        }).start();
        new Thread(() -> {
            try {
                semaphore.acquire();
                lock.stampedReadUnlock(stamp.get());
                counter.incrementAndGet();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }).start();
        new Thread(() -> {
            try {
                semaphore.acquire();
                lock.writeLock();
                counter.incrementAndGet();
                lock.writeUnlock();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }).start();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> counter.get() == 3);
        Assert.assertEquals((long)3L, (long)counter.get());
    }

    @Test
    public void testThreadReadLock() {
        StampedWriterPreferredLock lock = new StampedWriterPreferredLock();
        Semaphore semaphore = new Semaphore(0);
        AtomicInteger counter = new AtomicInteger();
        new Thread(() -> {
            lock.threadReadLock();
            semaphore.release(1);
            counter.incrementAndGet();
            lock.threadReadUnlock();
        }).start();
        new Thread(() -> {
            try {
                semaphore.acquire();
                lock.writeLock();
                counter.incrementAndGet();
                lock.writeUnlock();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }).start();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> counter.get() == 2);
        Assert.assertEquals((long)2L, (long)counter.get());
        counter.set(0);
        new Thread(() -> {
            lock.threadReadLock();
            semaphore.release(2);
            counter.incrementAndGet();
        }).start();
        new Thread(() -> {
            try {
                semaphore.acquire();
                lock.threadReadUnlock();
                counter.incrementAndGet();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }).start();
        new Thread(() -> {
            try {
                semaphore.acquire();
                lock.writeLock();
                counter.incrementAndGet();
                lock.writeUnlock();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }).start();
        try {
            Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> counter.get() == 3);
            Assert.fail();
        }
        catch (ConditionTimeoutException e) {
            Assert.assertNotEquals((long)3L, (long)counter.get());
        }
    }

    @Test
    public void testAcquireReadLockWhileWriting() {
        StampedWriterPreferredLock lock = new StampedWriterPreferredLock();
        lock.writeLock();
        AtomicInteger counter = new AtomicInteger();
        new Thread(() -> {
            lock.threadReadLock();
            counter.incrementAndGet();
            lock.threadReadUnlock();
        }).start();
        Assert.assertEquals((long)0L, (long)counter.get());
        lock.writeUnlock();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> counter.get() == 1);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testWriterPreferred() {
        StampedWriterPreferredLock lock = new StampedWriterPreferredLock();
        AtomicInteger counter = new AtomicInteger();
        long stamp = lock.stampedReadLock();
        new Thread(() -> {
            lock.writeLock();
            counter.incrementAndGet();
            lock.writeUnlock();
        }).start();
        try {
            Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> counter.get() == 1);
            Assert.fail();
        }
        catch (ConditionTimeoutException e) {
            Assert.assertEquals((long)0L, (long)counter.get());
        }
        new Thread(() -> {
            lock.threadReadLock();
            counter.incrementAndGet();
            lock.threadReadUnlock();
        }).start();
        new Thread(() -> {
            lock.threadReadLock(true);
            counter.incrementAndGet();
            lock.threadReadUnlock();
        }).start();
        new Thread(() -> {
            long stamp1 = lock.stampedReadLock();
            counter.incrementAndGet();
            lock.stampedReadUnlock(stamp1);
        }).start();
        try {
            Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> counter.get() == 4);
            Assert.fail();
        }
        catch (ConditionTimeoutException e) {
            Assert.assertEquals((long)1L, (long)counter.get());
        }
        lock.stampedReadUnlock(stamp);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> counter.get() == 4);
        Assert.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void testConcurrent() throws InterruptedException {
        StampedWriterPreferredLock lock = new StampedWriterPreferredLock();
        Semaphore semaphore = new Semaphore(0);
        AtomicInteger counter1 = new AtomicInteger();
        AtomicInteger counter2 = new AtomicInteger();
        new Thread(() -> {
            lock.writeLock();
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            lock.writeUnlock();
            lock.writeLock();
            counter1.incrementAndGet();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            counter2.incrementAndGet();
            lock.writeUnlock();
        }).start();
        new Thread(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            semaphore.release();
        }).start();
        lock.threadReadLock();
        Assert.assertEquals((long)counter2.get(), (long)counter1.get());
        lock.threadReadUnlock();
    }
}

