/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.container;

import java.util.Iterator;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.MNodeUpdateChildBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.junit.Assert;
import org.junit.Test;

public class MNodeChildBufferTest {
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Test
    public void testMNodeChildBuffer() {
        ICachedMNode rootNode = (ICachedMNode)this.nodeFactory.createInternalMNode(null, "root");
        ICachedMNode speedNode = (ICachedMNode)((ICachedMNode)((ICachedMNode)rootNode.addChild((IMNode)((ICachedMNode)this.nodeFactory.createInternalMNode(null, "sg1")))).addChild((IMNode)((ICachedMNode)this.nodeFactory.createInternalMNode(null, "device")))).addChild((IMNode)((ICachedMNode)this.nodeFactory.createInternalMNode(null, "speed")));
        Assert.assertEquals((Object)"root.sg1.device.speed", (Object)speedNode.getFullPath());
        ICachedMNode temperatureNode = (ICachedMNode)((ICachedMNode)((ICachedMNode)rootNode.getChild("sg1")).addChild((IMNode)((ICachedMNode)this.nodeFactory.createInternalMNode(null, "device11")))).addChild((IMNode)((ICachedMNode)this.nodeFactory.createInternalMNode(null, "temperature")));
        Assert.assertEquals((Object)"root.sg1.device11.temperature", (Object)temperatureNode.getFullPath());
        MNodeUpdateChildBuffer buffer = new MNodeUpdateChildBuffer();
        Assert.assertTrue((boolean)buffer.getReceivingBuffer().isEmpty());
        Assert.assertTrue((boolean)buffer.getFlushingBuffer().isEmpty());
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.put((Object)"root.sg1.device.speed", (Object)speedNode);
        Assert.assertEquals((long)1L, (long)buffer.getReceivingBuffer().size());
        Assert.assertEquals((long)0L, (long)buffer.getFlushingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.size());
        buffer.transferReceivingBufferToFlushingBuffer();
        Assert.assertEquals((long)0L, (long)buffer.getReceivingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.getFlushingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.size());
        buffer.put((Object)"root.sg1.device.speed", (Object)speedNode);
        Assert.assertEquals((long)1L, (long)buffer.getReceivingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.getFlushingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.size());
        buffer.put((Object)"root.sg1.device11.temperature", (Object)temperatureNode);
        Assert.assertTrue((boolean)buffer.containsKey((Object)"root.sg1.device.speed"));
        Assert.assertTrue((boolean)buffer.containsKey((Object)"root.sg1.device11.temperature"));
        Assert.assertTrue((boolean)buffer.containsValue((Object)speedNode));
        Assert.assertTrue((boolean)buffer.containsValue((Object)temperatureNode));
        Assert.assertEquals((long)2L, (long)buffer.keySet().size());
        Assert.assertEquals((long)2L, (long)buffer.values().size());
        Assert.assertEquals((long)2L, (long)buffer.entrySet().size());
        Iterator iterator = buffer.getMNodeChildBufferIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)speedNode, iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)temperatureNode, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)speedNode, (Object)buffer.get((Object)"root.sg1.device.speed"));
        Assert.assertEquals((Object)temperatureNode, (Object)buffer.get((Object)"root.sg1.device11.temperature"));
        buffer.remove((Object)"root.sg1.device.speed");
        Assert.assertEquals((long)1L, (long)buffer.getReceivingBuffer().size());
        Assert.assertEquals((long)0L, (long)buffer.getFlushingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.size());
        buffer.transferReceivingBufferToFlushingBuffer();
        buffer.putIfAbsent((Object)"root.sg1.device11.temperature", (Object)temperatureNode);
        buffer.removeFromFlushingBuffer((Object)"root.sg1.device11.temperature");
        Assert.assertEquals((long)1L, (long)buffer.getReceivingBuffer().size());
        Assert.assertEquals((long)0L, (long)buffer.getFlushingBuffer().size());
        Assert.assertEquals((long)1L, (long)buffer.size());
        buffer.transferReceivingBufferToFlushingBuffer();
        buffer.putIfAbsent((Object)"root.sg1.device11.temperature", (Object)temperatureNode);
        buffer.clear();
        Assert.assertTrue((boolean)buffer.getReceivingBuffer().isEmpty());
        Assert.assertTrue((boolean)buffer.getFlushingBuffer().isEmpty());
        Assert.assertTrue((boolean)buffer.isEmpty());
    }
}

