/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache.dualkeycache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheUpdating;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCacheBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.DataNodeLastCacheManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DualKeyCacheTest {
    private final String policy;

    public DualKeyCacheTest(String policy) {
        this.policy = policy;
    }

    @Parameterized.Parameters
    public static List<String> getTestModes() {
        return Arrays.asList("FIFO", "LRU");
    }

    @Test
    public void testBasicReadPut() {
        int i;
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        IDualKeyCache dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.valueOf((String)this.policy)).memoryCapacity(300L).firstKeySizeComputer(this::computeStringSize).secondKeySizeComputer(this::computeStringSize).valueSizeComputer(this::computeStringSize).build();
        final String[] firstKeyList = new String[]{"root.db.d1", "root.db.d2"};
        final String[] secondKeyList = new String[]{"s1", "s2"};
        final String[][] valueTable = new String[][]{{"1-1", "1-2"}, {"2-1", "2-2"}};
        for (int i2 = 0; i2 < firstKeyList.length; ++i2) {
            for (int j = 0; j < secondKeyList.length; ++j) {
                dualKeyCache.put((Object)firstKeyList[i2], (Object)secondKeyList[j], (Object)valueTable[i2][j]);
            }
        }
        int firstKeyOfMissingEntry = -1;
        int secondKeyOfMissingEntry = -1;
        for (i = 0; i < firstKeyList.length; ++i) {
            for (int j = 0; j < secondKeyList.length; ++j) {
                String value = (String)dualKeyCache.get((Object)firstKeyList[i], (Object)secondKeyList[j]);
                if (value == null) {
                    if (firstKeyOfMissingEntry == -1) {
                        firstKeyOfMissingEntry = i;
                        secondKeyOfMissingEntry = j;
                        continue;
                    }
                    Assert.fail();
                    continue;
                }
                Assert.assertEquals((Object)valueTable[i][j], (Object)value);
            }
        }
        Assert.assertEquals((long)230L, (long)dualKeyCache.stats().memoryUsage());
        Assert.assertEquals((long)4L, (long)dualKeyCache.stats().requestCount());
        Assert.assertEquals((long)3L, (long)dualKeyCache.stats().hitCount());
        dualKeyCache.put((Object)firstKeyList[firstKeyOfMissingEntry], (Object)secondKeyList[secondKeyOfMissingEntry], (Object)valueTable[firstKeyOfMissingEntry][secondKeyOfMissingEntry]);
        Assert.assertEquals((long)230L, (long)dualKeyCache.stats().memoryUsage());
        i = 0;
        while (i < firstKeyList.length) {
            final int finalI = i++;
            dualKeyCache.compute((IDualKeyCacheComputation)new IDualKeyCacheComputation<String, String, String>(){

                public String getFirstKey() {
                    return firstKeyList[finalI];
                }

                public String[] getSecondKeyList() {
                    return secondKeyList;
                }

                public void computeValue(int index, String value) {
                    if (value != null) {
                        Assert.assertEquals((Object)valueTable[finalI][index], (Object)value);
                    }
                }
            });
        }
        Assert.assertEquals((long)8L, (long)dualKeyCache.stats().requestCount());
        Assert.assertEquals((long)6L, (long)dualKeyCache.stats().hitCount());
    }

    private int computeStringSize(String string) {
        return 20 + 2 * string.length();
    }

    @Test
    public void testComputeAndUpdateSize() {
        String[] secondKeyList;
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        IDualKeyCache dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.valueOf((String)this.policy)).memoryCapacity(500L).firstKeySizeComputer(this::computeStringSize).secondKeySizeComputer(this::computeStringSize).valueSizeComputer(SchemaCacheEntry::estimateSize).build();
        final String firstKey = "root.db.d1";
        for (String s : secondKeyList = new String[]{"s1", "s2"}) {
            dualKeyCache.put((Object)firstKey, (Object)s, (Object)new SchemaCacheEntry("root.db", (IMeasurementSchema)new MeasurementSchema(s, TSDataType.INT32), Collections.emptyMap(), false));
        }
        SchemaCacheEntry schemaCacheEntry = new SchemaCacheEntry("root.db", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false);
        int expectedSize = this.computeStringSize("root.db.d1") + this.computeStringSize("s1") * 2 + SchemaCacheEntry.estimateSize((SchemaCacheEntry)schemaCacheEntry) * 2;
        Assert.assertEquals((long)expectedSize, (long)dualKeyCache.stats().memoryUsage());
        dualKeyCache.update((IDualKeyCacheUpdating)new IDualKeyCacheUpdating<String, String, SchemaCacheEntry>(){

            public String getFirstKey() {
                return firstKey;
            }

            public String[] getSecondKeyList() {
                return secondKeyList;
            }

            public int updateValue(int index, SchemaCacheEntry value) {
                return DataNodeLastCacheManager.updateLastCache((SchemaCacheEntry)value, (TimeValuePair)new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), (boolean)true, (Long)0L);
            }
        });
        int tmp = SchemaCacheEntry.estimateSize((SchemaCacheEntry)schemaCacheEntry);
        schemaCacheEntry.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        Assert.assertEquals((long)(expectedSize += (SchemaCacheEntry.estimateSize((SchemaCacheEntry)schemaCacheEntry) - tmp) * 2), (long)dualKeyCache.stats().memoryUsage());
    }

    @Test
    public void testInvalidDatabase() throws IllegalPathException {
        IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache = this.generateCache();
        dualKeyCache.invalidate("root.db1");
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s11"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2"));
        int expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db2.d1")) + this.computeStringSize("s1") * 2 + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false)) * 2;
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        dualKeyCache.evictOneEntry();
        expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db2.d1")) + this.computeStringSize("s1") + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        dualKeyCache.evictOneEntry();
        Assert.assertEquals((long)0L, (long)dualKeyCache.stats().memoryUsage());
    }

    @Test
    public void testInvalidPathPattern1() throws IllegalPathException {
        IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache = this.generateCache();
        dualKeyCache.invalidate(Arrays.asList(new PartialPath("root.db2.**"), new PartialPath("root.db1.d1.s1")));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s11"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2"));
        int expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db1.d1")) + PartialPath.estimateSize((PartialPath)new PartialPath("root.db1")) + this.computeStringSize("s1") + this.computeStringSize("s11") + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false)) + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s11", TSDataType.INT32), Collections.emptyMap(), false));
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        dualKeyCache.evictOneEntry();
        dualKeyCache.evictOneEntry();
        Assert.assertEquals((long)0L, (long)dualKeyCache.stats().memoryUsage());
    }

    @Test
    public void testInvalidPathPattern2() throws IllegalPathException {
        IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache = this.generateCache();
        dualKeyCache.invalidate(Arrays.asList(new PartialPath("root.db1.**"), new PartialPath("root.db2.d1.*1")));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s11"));
        Assert.assertNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2"));
        int expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db2.d1")) + this.computeStringSize("s2") + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32), Collections.emptyMap(), false));
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        dualKeyCache.evictOneEntry();
        Assert.assertEquals((long)0L, (long)dualKeyCache.stats().memoryUsage());
    }

    private IDualKeyCache<PartialPath, String, SchemaCacheEntry> generateCache() throws IllegalPathException {
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        IDualKeyCache dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.valueOf((String)this.policy)).memoryCapacity(2000L).firstKeySizeComputer(PartialPath::estimateSize).secondKeySizeComputer(this::computeStringSize).valueSizeComputer(SchemaCacheEntry::estimateSize).build();
        dualKeyCache.put((Object)new PartialPath("root.db1.d1"), (Object)"s1", (Object)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        dualKeyCache.put((Object)new PartialPath("root.db1.d1"), (Object)"s2", (Object)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        dualKeyCache.put((Object)new PartialPath("root.db1"), (Object)"s11", (Object)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s11", TSDataType.INT32), Collections.emptyMap(), false));
        dualKeyCache.put((Object)new PartialPath("root.db1.d1"), (Object)"s2", (Object)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        dualKeyCache.put((Object)new PartialPath("root.db2.d1"), (Object)"s1", (Object)new SchemaCacheEntry("root.db2", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        dualKeyCache.put((Object)new PartialPath("root.db2.d1"), (Object)"s2", (Object)new SchemaCacheEntry("root.db2", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s11"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2"));
        int expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db1.d1")) * 2 + PartialPath.estimateSize((PartialPath)new PartialPath("root.db1")) + this.computeStringSize("s1") * 4 + this.computeStringSize("s11") + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false)) * 4 + SchemaCacheEntry.estimateSize((SchemaCacheEntry)new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s11", TSDataType.INT32), Collections.emptyMap(), false));
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        return dualKeyCache;
    }

    private IDualKeyCache<PartialPath, String, SchemaCacheEntry> generateLastCache() throws IllegalPathException {
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        IDualKeyCache dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.valueOf((String)this.policy)).memoryCapacity(2000L).firstKeySizeComputer(PartialPath::estimateSize).secondKeySizeComputer(this::computeStringSize).valueSizeComputer(SchemaCacheEntry::estimateSize).build();
        SchemaCacheEntry cacheEntry1 = new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), Collections.emptyMap(), false);
        cacheEntry1.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        dualKeyCache.put((Object)new PartialPath("root.db1.d1"), (Object)"s1", (Object)cacheEntry1);
        SchemaCacheEntry cacheEntry2 = new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32), Collections.emptyMap(), false);
        cacheEntry2.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        dualKeyCache.put((Object)new PartialPath("root.db1.d1"), (Object)"s2", (Object)cacheEntry2);
        SchemaCacheEntry cacheEntry3 = new SchemaCacheEntry("root.db2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32), Collections.emptyMap(), false);
        cacheEntry3.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        dualKeyCache.put((Object)new PartialPath("root.db2.d1"), (Object)"s2", (Object)cacheEntry3);
        SchemaCacheEntry cacheEntry4 = new SchemaCacheEntry("root.db2", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32), Collections.emptyMap(), false);
        cacheEntry4.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        dualKeyCache.put((Object)new PartialPath("root.db2.d1"), (Object)"s1", (Object)cacheEntry4);
        SchemaCacheEntry cacheEntry5 = new SchemaCacheEntry("root.db1", (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.INT32), Collections.emptyMap(), false);
        cacheEntry5.updateLastCache(new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), true, Long.valueOf(0L));
        dualKeyCache.put((Object)new PartialPath("root.db1"), (Object)"s2", (Object)cacheEntry5);
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s2"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1"));
        Assert.assertNotNull((Object)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2"));
        int expectSize = PartialPath.estimateSize((PartialPath)new PartialPath("root.db1.d1")) * 2 + PartialPath.estimateSize((PartialPath)new PartialPath("root.db1")) + this.computeStringSize("s1") * 5 + SchemaCacheEntry.estimateSize((SchemaCacheEntry)cacheEntry1) * 5;
        Assert.assertEquals((long)expectSize, (long)dualKeyCache.stats().memoryUsage());
        return dualKeyCache;
    }

    @Test
    public void testInvalidateSimpleTimeseriesAndDataRegion() throws IllegalPathException {
        IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache = this.generateLastCache();
        long memUse = dualKeyCache.stats().memoryUsage();
        dualKeyCache.invalidateLastCache(new PartialPath("root.db1.d1.s1"));
        SchemaCacheEntry cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
        dualKeyCache.invalidateLastCache(new PartialPath("root.db1.d1.*"));
        cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
        dualKeyCache.invalidateLastCache(new PartialPath("root.db2.d1.**"));
        cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s2");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
        dualKeyCache.invalidateDataRegionLastCache("root.db2");
        cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db2.d1"), (Object)"s1");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
        cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db1"), (Object)"s2");
        int size = cacheEntry.getLastCacheContainer().estimateSize() - 16;
        Assert.assertEquals((long)(memUse - (long)(size * 4)), (long)dualKeyCache.stats().memoryUsage());
    }

    @Test
    public void testComplexInvalidate() throws IllegalPathException {
        IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache = this.generateLastCache();
        dualKeyCache.invalidateLastCache(new PartialPath("root.db1.*.s1"));
        SchemaCacheEntry cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s1");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
        dualKeyCache.invalidateLastCache(new PartialPath("root.db1.**.s2"));
        cacheEntry = (SchemaCacheEntry)dualKeyCache.get((Object)new PartialPath("root.db1.d1"), (Object)"s2");
        Assert.assertNull((Object)cacheEntry.getLastCacheContainer().getCachedLast());
    }
}

