/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataNodeSchemaCacheTest {
    DataNodeSchemaCache dataNodeSchemaCache;
    private Map<String, String> s1TagMap;

    @Before
    public void setUp() throws Exception {
        this.dataNodeSchemaCache = DataNodeSchemaCache.getInstance();
        this.s1TagMap = new HashMap<String, String>();
        this.s1TagMap.put("k1", "v1");
    }

    @After
    public void tearDown() throws Exception {
        this.dataNodeSchemaCache.cleanUp();
        ClusterTemplateManager.getInstance().clear();
    }

    @Test
    public void testGetSchemaEntity() throws IllegalPathException {
        PartialPath device1 = new PartialPath("root.sg1.d1");
        String[] measurements = new String[]{"s1", "s2", "s3"};
        this.dataNodeSchemaCache.put((ClusterSchemaTree)this.generateSchemaTree1());
        Map<PartialPath, SchemaCacheEntry> schemaCacheEntryMap = this.dataNodeSchemaCache.get(device1, measurements).getAllDevices().stream().flatMap(deviceSchemaInfo -> deviceSchemaInfo.getMeasurementSchemaPathList().stream()).collect(Collectors.toMap(o -> new PartialPath(o.getNodes()), o -> new SchemaCacheEntry("root.sg1", o.getMeasurementSchema(), o.getTagMap(), o.isUnderAlignedEntity())));
        Assert.assertEquals((Object)TSDataType.INT32, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s1")).getTsDataType());
        Assert.assertEquals(this.s1TagMap, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s1")).getTagMap());
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s2")).getTsDataType());
        Assert.assertNull((Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s2")).getTagMap());
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTsDataType());
        Assert.assertNull((Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTagMap());
        String[] otherMeasurements = new String[]{"s3", "s4", "s5"};
        this.dataNodeSchemaCache.put((ClusterSchemaTree)this.generateSchemaTree2());
        schemaCacheEntryMap = this.dataNodeSchemaCache.get(device1, otherMeasurements).getAllDevices().stream().flatMap(deviceSchemaInfo -> deviceSchemaInfo.getMeasurementSchemaPathList().stream()).collect(Collectors.toMap(o -> new PartialPath(o.getNodes()), o -> new SchemaCacheEntry("root.sg1", o.getMeasurementSchema(), o.getTagMap(), o.isUnderAlignedEntity())));
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTsDataType());
        Assert.assertNull((Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTagMap());
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s4")).getTsDataType());
        Assert.assertNull((Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s4")).getTagMap());
        Assert.assertEquals((Object)TSDataType.INT64, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s5")).getTsDataType());
        Assert.assertNull((Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s4")).getTagMap());
    }

    @Test
    public void testLastCache() throws IllegalPathException {
        PartialPath devicePath = new PartialPath("root.sg1.d1");
        PartialPath seriesPath1 = new PartialPath("root.sg1.d1.s1");
        PartialPath seriesPath2 = new PartialPath("root.sg1.d1.s2");
        PartialPath seriesPath3 = new PartialPath("root.sg1.d1.s3");
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath1));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        this.dataNodeSchemaCache.put((ClusterSchemaTree)this.generateSchemaTree1());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath1));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        long timestamp = 100L;
        long timestamp2 = 101L;
        TsPrimitiveType value = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)101);
        TsPrimitiveType value2 = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)100);
        TsPrimitiveType value3 = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)99);
        TimeValuePair timeValuePair = new TimeValuePair(timestamp, value);
        this.dataNodeSchemaCache.updateLastCache(devicePath, "s1", timeValuePair, false, Long.valueOf(99L));
        TimeValuePair cachedTimeValuePair = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair.getTimestamp());
        Assert.assertEquals((Object)value, (Object)cachedTimeValuePair.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        TimeValuePair timeValuePair2 = new TimeValuePair(timestamp, value2);
        this.dataNodeSchemaCache.updateLastCache(devicePath, "s1", timeValuePair2, false, Long.valueOf(100L));
        TimeValuePair cachedTimeValuePair2 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair2);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair2.getTimestamp());
        Assert.assertEquals((Object)value, (Object)cachedTimeValuePair2.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        this.dataNodeSchemaCache.updateLastCache(devicePath, "s1", timeValuePair2, true, Long.valueOf(100L));
        cachedTimeValuePair2 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair2);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair2.getTimestamp());
        Assert.assertEquals((Object)value2, (Object)cachedTimeValuePair2.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        TimeValuePair timeValuePair3 = new TimeValuePair(timestamp2, value3);
        this.dataNodeSchemaCache.updateLastCache(devicePath, "s1", timeValuePair3, false, Long.valueOf(100L));
        TimeValuePair cachedTimeValuePair3 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair3);
        Assert.assertEquals((long)timestamp2, (long)cachedTimeValuePair3.getTimestamp());
        Assert.assertEquals((Object)value3, (Object)cachedTimeValuePair3.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
    }

    private ISchemaTree generateSchemaTree1() throws IllegalPathException {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        HashMap<String, String> s1TagMap = new HashMap<String, String>();
        s1TagMap.put("k1", "v1");
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s1"), (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT32), s1TagMap, null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s2"), (IMeasurementSchema)new MeasurementSchema("s2", TSDataType.FLOAT), null, null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s3"), (IMeasurementSchema)new MeasurementSchema("s3", TSDataType.BOOLEAN), null, null, false);
        schemaTree.setDatabases(Collections.singleton("root.sg1"));
        return schemaTree;
    }

    private ISchemaTree generateSchemaTree2() throws IllegalPathException {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s3"), (IMeasurementSchema)new MeasurementSchema("s3", TSDataType.BOOLEAN), null, null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s4"), (IMeasurementSchema)new MeasurementSchema("s4", TSDataType.TEXT), null, null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s5"), (IMeasurementSchema)new MeasurementSchema("s5", TSDataType.INT64), null, null, false);
        schemaTree.setDatabases(Collections.singleton("root.sg1"));
        return schemaTree;
    }

    @Test
    public void testUpdateLastCache() throws IllegalPathException {
        String database = "root.db";
        PartialPath device = new PartialPath("root.db.d");
        String[] measurements = new String[]{"s1", "s2", "s3"};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32), new MeasurementSchema("s2", TSDataType.INT32), new MeasurementSchema("s3", TSDataType.INT32)};
        this.dataNodeSchemaCache.updateLastCache(database, device, measurements, measurementSchemas, true, index -> new TimeValuePair(1L, (TsPrimitiveType)new TsPrimitiveType.TsInt(1)), index -> index != 1, true, Long.valueOf(1L));
        Assert.assertNotNull((Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s1")));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s2")));
        Assert.assertNotNull((Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s3")));
        this.dataNodeSchemaCache.updateLastCache(database, device, measurements, measurementSchemas, true, index -> new TimeValuePair(2L, (TsPrimitiveType)new TsPrimitiveType.TsInt(2)), index -> true, true, Long.valueOf(1L));
        Assert.assertEquals((Object)new TimeValuePair(2L, (TsPrimitiveType)new TsPrimitiveType.TsInt(2)), (Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s1")));
        Assert.assertEquals((Object)new TimeValuePair(2L, (TsPrimitiveType)new TsPrimitiveType.TsInt(2)), (Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s2")));
        Assert.assertEquals((Object)new TimeValuePair(2L, (TsPrimitiveType)new TsPrimitiveType.TsInt(2)), (Object)this.dataNodeSchemaCache.getLastCache(new PartialPath("root.db.d.s3")));
    }

    @Test
    public void testPut() throws Exception {
        ClusterSchemaTree clusterSchemaTree = new ClusterSchemaTree();
        Template template1 = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        template1.setId(1);
        Template template2 = new Template("t2", Arrays.asList("t1", "t2", "t3"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32, TSDataType.INT64), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLBE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY, CompressionType.SNAPPY));
        template2.setId(2);
        ClusterTemplateManager.getInstance().putTemplate(template1);
        ClusterTemplateManager.getInstance().putTemplate(template2);
        clusterSchemaTree.appendTemplateDevice(new PartialPath("root.sg1.d1"), false, 1, template1);
        clusterSchemaTree.appendTemplateDevice(new PartialPath("root.sg1.d2"), false, 2, template2);
        clusterSchemaTree.setDatabases(Collections.singleton("root.sg1"));
        clusterSchemaTree.appendSingleMeasurementPath(new MeasurementPath("root.sg1.d3.s1", TSDataType.FLOAT));
        this.dataNodeSchemaCache.put(clusterSchemaTree);
        ClusterSchemaTree d1Tree = this.dataNodeSchemaCache.getMatchedSchemaWithTemplate(new PartialPath("root.sg1.d1"));
        ClusterSchemaTree d2Tree = this.dataNodeSchemaCache.getMatchedSchemaWithTemplate(new PartialPath("root.sg1.d2"));
        ClusterSchemaTree d3Tree = this.dataNodeSchemaCache.getMatchedSchemaWithoutTemplate(new PartialPath("root.sg1.d3.s1"));
        List measurementPaths = (List)d1Tree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left;
        Assert.assertEquals((long)2L, (long)measurementPaths.size());
        for (MeasurementPath measurementPath : measurementPaths) {
            Assert.assertEquals((Object)template1.getSchema(measurementPath.getMeasurement()), (Object)measurementPath.getMeasurementSchema());
        }
        measurementPaths = (List)d2Tree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left;
        Assert.assertEquals((long)3L, (long)measurementPaths.size());
        for (MeasurementPath measurementPath : measurementPaths) {
            Assert.assertEquals((Object)template2.getSchema(measurementPath.getMeasurement()), (Object)measurementPath.getMeasurementSchema());
        }
        measurementPaths = (List)d3Tree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left;
        Assert.assertEquals((long)1L, (long)measurementPaths.size());
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)((MeasurementPath)measurementPaths.get(0)).getMeasurementSchema().getType());
        Assert.assertEquals((Object)"root.sg1.d3.s1", (Object)((MeasurementPath)measurementPaths.get(0)).getFullPath());
    }
}

