/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataNodeDevicePathCacheTest {
    DataNodeDevicePathCache dataNodeDevicePathCache;

    @Before
    public void setUp() throws Exception {
        this.dataNodeDevicePathCache = DataNodeDevicePathCache.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        this.dataNodeDevicePathCache.cleanUp();
    }

    @Test
    public void testGetPartialPath() {
        try {
            this.dataNodeDevicePathCache.getPartialPath("root.sg.d1");
        }
        catch (IllegalPathException e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalPathException.class)
    public void testGetIllegalPartialPath() throws Exception {
        try {
            this.dataNodeDevicePathCache.getPartialPath("root.sg.1");
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root.sg.1 is not a legal path", (Object)e.getMessage());
            throw e;
        }
        Assert.fail((String)"root.sg.1 should be an illegal path");
    }
}

