/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class MetaUtilsTest {
    private final IMNodeFactory<IMemMNode> nodeFactory = MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory();

    @Test
    public void testGetMultiFullPaths() {
        IMemMNode rootNode = (IMemMNode)this.nodeFactory.createInternalMNode(null, "root");
        IMemMNode aNode = (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)rootNode, "a");
        rootNode.addChild(aNode.getName(), (IMNode)aNode);
        IMemMNode aaNode = (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)rootNode, "aa");
        rootNode.addChild(aaNode.getName(), (IMNode)aaNode);
        IMemMNode bNode = (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)aNode, "b");
        aNode.addChild(bNode.getName(), (IMNode)bNode);
        IMemMNode bbNode = (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)aaNode, "bb");
        aaNode.addChild(bbNode.getName(), (IMNode)bbNode);
        IMemMNode ccNode = (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)bbNode, "cc");
        bbNode.addChild(ccNode.getName(), (IMNode)ccNode);
        List multiFullPaths = MetaUtils.getMultiFullPaths((IMNode)rootNode);
        Assert.assertSame((Object)2, (Object)multiFullPaths.size());
        multiFullPaths.forEach(fullPath -> {
            if (fullPath.contains("aa")) {
                Assert.assertEquals((Object)"root.aa.bb.cc", (Object)fullPath);
            } else {
                Assert.assertEquals((Object)"root.a.b", (Object)fullPath);
            }
        });
    }

    @Test
    public void testGroupAlignedPath() throws MetadataException {
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        MeasurementPath path1 = new MeasurementPath(new PartialPath("root.sg.device1.s1"), TSDataType.INT32);
        pathList.add(path1);
        MeasurementPath path2 = new MeasurementPath(new PartialPath("root.sg.device1.s2"), TSDataType.INT32);
        pathList.add(path2);
        MeasurementPath path3 = new MeasurementPath(new PartialPath("root.sg.aligned_device.s1"), TSDataType.INT32);
        path3.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path3);
        MeasurementPath path4 = new MeasurementPath(new PartialPath("root.sg.aligned_device.s2"), TSDataType.INT32);
        path4.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path4);
        AlignedPath alignedPath = new AlignedPath(path3);
        alignedPath.addMeasurement(path4);
        List result = MetaUtils.groupAlignedPaths(pathList);
        Assert.assertTrue((boolean)result.contains(path1));
        Assert.assertTrue((boolean)result.contains(path2));
        Assert.assertTrue((boolean)result.contains(alignedPath));
    }

    @Test
    public void testGetStorageGroupPathByLevel() {
        int level = 1;
        try {
            Assert.assertEquals((Object)"root.laptop", (Object)MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root.laptop.d1.s1"), (int)level).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        boolean caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root1.laptop.d1.s1"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root1.laptop.d1.s1 is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
        caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
    }

    @Test
    public void testGroupAlignedSeries() throws MetadataException {
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        MeasurementPath path1 = new MeasurementPath(new PartialPath("root.sg.device1.s1"), TSDataType.INT32);
        pathList.add(path1);
        MeasurementPath path2 = new MeasurementPath(new PartialPath("root.sg.device1.s2"), TSDataType.INT32);
        pathList.add(path2);
        MeasurementPath path3 = new MeasurementPath(new PartialPath("root.sg.aligned_device1.s1"), TSDataType.INT32);
        path3.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path3);
        MeasurementPath path4 = new MeasurementPath(new PartialPath("root.sg.aligned_device2.s1"), TSDataType.INT32);
        path4.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path4);
        MeasurementPath path5 = new MeasurementPath(new PartialPath("root.sg.aligned_device1.s2"), TSDataType.INT32);
        path5.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path5);
        MeasurementPath path6 = new MeasurementPath(new PartialPath("root.sg.aligned_device2.s2"), TSDataType.INT32);
        path6.setUnderAlignedEntity(Boolean.valueOf(true));
        pathList.add(path6);
        AlignedPath alignedPath1 = new AlignedPath(path3);
        alignedPath1.addMeasurement(path5);
        AlignedPath alignedPath2 = new AlignedPath(path4);
        alignedPath2.addMeasurement(path6);
        List result = MetaUtils.groupAlignedSeries(pathList);
        Assert.assertTrue((boolean)result.contains(path1));
        Assert.assertTrue((boolean)result.contains(path2));
        Assert.assertTrue((boolean)result.contains(alignedPath1));
        Assert.assertTrue((boolean)result.contains(alignedPath2));
    }

    @Test
    public void testParseDeadbandInfo() {
        HashMap<String, String> props = new HashMap<String, String>();
        HashMap<String, String> sdtProps = new HashMap<String, String>();
        props.put("loss", "sdt");
        sdtProps.put("compdev", "0.01");
        sdtProps.put("compmintime", "2");
        sdtProps.put("compmaxtime", "10");
        props.putAll(sdtProps);
        Pair res = MetaUtils.parseDeadbandInfo(props);
        Assert.assertEquals((Object)"SDT", (Object)res.left);
        Assert.assertEquals((Object)((Object)sdtProps).toString(), (Object)res.right);
    }
}

