/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBDescriptorTest {
    private final String confPath = System.getProperty("IOTDB_CONF", null);

    @BeforeClass
    public static void init() {
        URL.setURLStreamHandlerFactory(new ConfigurableStreamHandlerFactory("classpath", new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                throw new RuntimeException("This shouldn't have been called");
            }
        }));
    }

    @After
    public void clear() {
        if (this.confPath != null) {
            System.setProperty("IOTDB_CONF", this.confPath);
        } else {
            System.clearProperty("IOTDB_CONF");
        }
    }

    @Test
    public void testConfigURLWithFileProtocol() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        String pathString = "file:/usr/local/bin";
        System.setProperty("IOTDB_CONF", pathString);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertTrue((boolean)confURL.toString().startsWith(pathString));
    }

    @Test
    public void testConfigURLWithClasspathProtocol() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        String pathString = "classpath:/root/path";
        System.setProperty("IOTDB_CONF", pathString);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertTrue((boolean)confURL.toString().startsWith(pathString));
    }

    @Test
    public void testConfigURLWithPlainFilePath() {
        IoTDBDescriptor desc = IoTDBDescriptor.getInstance();
        URL path = IoTDBConfig.class.getResource("/iotdb-datanode.properties");
        String filePath = path.getFile();
        System.setProperty("IOTDB_CONF", filePath);
        URL confURL = desc.getPropsUrl("iotdb-datanode.properties");
        Assert.assertEquals((Object)confURL.toString(), (Object)path.toString());
    }

    static class ConfigurableStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private final Map<String, URLStreamHandler> protocolHandlers = new HashMap<String, URLStreamHandler>();

        public ConfigurableStreamHandlerFactory(String protocol, URLStreamHandler urlHandler) {
            this.addHandler(protocol, urlHandler);
        }

        public void addHandler(String protocol, URLStreamHandler urlHandler) {
            this.protocolHandlers.put(protocol, urlHandler);
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            return this.protocolHandlers.get(protocol);
        }
    }
}

