/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.user;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.LocalFileUserManager;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileUserManagerTest {
    private File testFolder;
    private LocalFileUserManager manager;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.manager = new LocalFileUserManager(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testIllegalInput() throws AuthException {
        try {
            this.manager.createUser("username1", "password_ ", true);
        }
        catch (AuthException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cannot contain spaces"));
        }
        try {
            Assert.assertFalse((boolean)this.manager.createUser("username 2", "password_", true));
        }
        catch (AuthException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cannot contain spaces"));
        }
    }

    @Test
    public void test() throws AuthException, IllegalPathException {
        User[] users = new User[5];
        for (int i = 0; i < users.length; ++i) {
            users[i] = new User("user" + i, "password" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.a.b.c" + j));
                pathPrivilege.getPrivileges().add(j);
                users[i].getPathPrivilegeList().add(pathPrivilege);
                users[i].getRoleList().add("role" + j);
            }
        }
        User user = this.manager.getUser(users[0].getName());
        Assert.assertNull((Object)user);
        for (User user1 : users) {
            Assert.assertTrue((boolean)this.manager.createUser(user1.getName(), user1.getPassword(), false));
        }
        for (User user1 : users) {
            user = this.manager.getUser(user1.getName());
            Assert.assertEquals((Object)user1.getName(), (Object)user.getName());
            Assert.assertTrue((boolean)AuthUtils.validatePassword((String)user1.getPassword(), (String)user.getPassword()));
        }
        Assert.assertFalse((boolean)this.manager.createUser(users[0].getName(), users[0].getPassword(), false));
        Assert.assertThrows(AuthException.class, () -> this.manager.createUser("too", "short", true));
        Assert.assertThrows(AuthException.class, () -> this.manager.createUser("short", "too", true));
        Assert.assertFalse((boolean)this.manager.deleteUser("not a user"));
        Assert.assertTrue((boolean)this.manager.deleteUser(users[users.length - 1].getName()));
        Assert.assertNull((Object)this.manager.getUser(users[users.length - 1].getName()));
        Assert.assertFalse((boolean)this.manager.deleteUser(users[users.length - 1].getName()));
        user = this.manager.getUser(users[0].getName());
        PartialPath path = new PartialPath("root.a.b.c");
        int privilegeId = 0;
        Assert.assertFalse((boolean)user.hasPrivilegeToRevoke(path, privilegeId));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId, false));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId + 1, false));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId, false));
        user = this.manager.getUser(users[0].getName());
        Assert.assertTrue((boolean)user.hasPrivilegeToRevoke(path, privilegeId));
        Assert.assertThrows(AuthException.class, () -> this.manager.grantPrivilegeToUser("not a user", path, privilegeId, false));
        user = this.manager.getUser(users[0].getName());
        Assert.assertTrue((boolean)this.manager.revokePrivilegeFromUser(user.getName(), path, privilegeId));
        Assert.assertFalse((boolean)this.manager.revokePrivilegeFromUser(user.getName(), path, privilegeId));
        Assert.assertThrows(AuthException.class, () -> this.manager.revokePrivilegeFromUser("not a user", path, privilegeId));
        String newPassword = "newPassword";
        String illegalPW = "new";
        Assert.assertTrue((boolean)this.manager.updateUserPassword(user.getName(), newPassword));
        Assert.assertFalse((boolean)this.manager.updateUserPassword(user.getName(), illegalPW));
        user = this.manager.getUser(user.getName());
        Assert.assertTrue((boolean)AuthUtils.validatePassword((String)newPassword, (String)user.getPassword()));
        Assert.assertThrows(AuthException.class, () -> this.manager.updateUserPassword("not a user", newPassword));
        String roleName = "newrole";
        Assert.assertTrue((boolean)this.manager.grantRoleToUser(roleName, user.getName()));
        Assert.assertFalse((boolean)this.manager.grantRoleToUser(roleName, user.getName()));
        user = this.manager.getUser(user.getName());
        Assert.assertTrue((boolean)user.hasRole(roleName));
        Assert.assertThrows(AuthException.class, () -> this.manager.grantRoleToUser("not a user", roleName));
        boolean caught = false;
        Assert.assertTrue((boolean)this.manager.revokeRoleFromUser(roleName, user.getName()));
        Assert.assertFalse((boolean)this.manager.revokeRoleFromUser(roleName, user.getName()));
        user = this.manager.getUser(user.getName());
        Assert.assertFalse((boolean)user.hasRole(roleName));
        Assert.assertThrows(AuthException.class, () -> this.manager.revokeRoleFromUser("not a user", roleName));
        List usernames = this.manager.listAllUsers();
        usernames.sort(null);
        Assert.assertEquals((Object)CommonDescriptor.getInstance().getConfig().getAdminName(), usernames.get(0));
        for (int i = 0; i < users.length - 1; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i + 1));
        }
    }

    @Test
    public void testCreateUserRawPassword() throws AuthException {
        Assert.assertTrue((boolean)this.manager.createUser("testRaw", AuthUtils.encryptPassword((String)"password1"), true, false));
        User user = this.manager.getUser("testRaw");
        Assert.assertEquals((Object)user.getPassword(), (Object)AuthUtils.encryptPassword((String)"password1"));
    }
}

