/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.user;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.LocalFileUserAccessor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileUserAccessorTest {
    private File testFolder;
    private LocalFileUserAccessor accessor;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.accessor = new LocalFileUserAccessor(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws IOException, IllegalPathException {
        int i;
        User[] users = new User[4];
        for (int i2 = 0; i2 < users.length; ++i2) {
            users[i2] = new User("user" + i2, "password" + i2);
            for (int j = 0; j <= i2; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.a.b.c" + j));
                pathPrivilege.getPrivileges().add(j);
                users[i2].getPathPrivilegeList().add(pathPrivilege);
                users[i2].getSysPrivilege().add(j + 5);
                users[i2].getRoleList().add("role" + j);
            }
        }
        for (User user : users) {
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        for (User user : users) {
            try {
                User loadedUser = this.accessor.loadUser(user.getName());
                Assert.assertEquals((Object)user, (Object)loadedUser);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        Assert.assertNull((Object)this.accessor.loadUser("not a user"));
        List usernames = this.accessor.listAllUsers();
        usernames.sort(null);
        for (i = 0; i < users.length; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i));
        }
        Assert.assertTrue((boolean)this.accessor.deleteUser("not a user"));
        Assert.assertTrue((boolean)this.accessor.deleteUser(users[users.length - 1].getName()));
        usernames = this.accessor.listAllUsers();
        Assert.assertEquals((long)(users.length - 1), (long)usernames.size());
        usernames.sort(null);
        for (i = 0; i < users.length - 1; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i));
        }
        User nullUser = this.accessor.loadUser(users[users.length - 1].getName());
        Assert.assertNull((Object)nullUser);
    }

    @Test
    public void testLoadOldVersion() throws IOException, IllegalPathException {
        User role = new User();
        role.setName("root");
        ArrayList<PathPrivilege> pathPriList = new ArrayList<PathPrivilege>();
        PathPrivilege rootPathPriv = new PathPrivilege(new PartialPath("root.**"));
        PathPrivilege normalPathPriv = new PathPrivilege(new PartialPath("root.b.c.**"));
        PathPrivilege wroPathPriv = new PathPrivilege(new PartialPath("root.c.*.d"));
        PathPrivilege wroPathPriv2 = new PathPrivilege(new PartialPath("root.c.*.**"));
        for (PriPrivilegeType item : PriPrivilegeType.values()) {
            if (item.ordinal() == PriPrivilegeType.ALL.ordinal()) continue;
            if (item.isPrePathRelevant()) {
                normalPathPriv.grantPrivilege(item.ordinal(), false);
                wroPathPriv.grantPrivilege(item.ordinal(), false);
                wroPathPriv2.grantPrivilege(item.ordinal(), false);
            }
            rootPathPriv.grantPrivilege(item.ordinal(), false);
        }
        pathPriList.add(rootPathPriv);
        pathPriList.add(normalPathPriv);
        pathPriList.add(wroPathPriv);
        pathPriList.add(wroPathPriv2);
        role.setPrivilegeList(pathPriList);
        role.setSysPriGrantOpt(new HashSet());
        role.setSysPrivilegeSet(new HashSet());
        role.setRoleList(new ArrayList());
        this.accessor.saveUserOldVersion(role);
        User newRole = this.accessor.loadUser("root");
        Assert.assertEquals((Object)"root", (Object)newRole.getName());
        Assert.assertFalse((boolean)newRole.getServiceReady());
        Assert.assertEquals((long)4L, (long)newRole.getPathPrivilegeList().size());
        for (PathPrivilege path : newRole.getPathPrivilegeList()) {
            if (!path.getPath().equals((Object)new PartialPath("root.**"))) {
                Assert.assertEquals((long)17L, (long)path.getPrivileges().size());
                continue;
            }
            Assert.assertEquals((long)33L, (long)path.getPrivileges().size());
        }
    }
}

