/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.LocalFileRoleManager;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileRoleManagerTest {
    private File testFolder;
    private LocalFileRoleManager manager;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.manager = new LocalFileRoleManager(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws AuthException, IllegalPathException {
        Role[] roles = new Role[4];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new Role("role" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.a.b.c" + j));
                pathPrivilege.getPrivileges().add(j);
                roles[i].getPathPrivilegeList().add(pathPrivilege);
                roles[i].getSysPrivilege().add(j + 4);
            }
        }
        Role role = this.manager.getRole(roles[0].getName());
        Assert.assertNull((Object)role);
        for (Role role1 : roles) {
            Assert.assertTrue((boolean)this.manager.createRole(role1.getName()));
        }
        for (Role role1 : roles) {
            role = this.manager.getRole(role1.getName());
            Assert.assertEquals((Object)role1.getName(), (Object)role.getName());
        }
        Assert.assertFalse((boolean)this.manager.createRole(roles[0].getName()));
        boolean caught = false;
        Assert.assertFalse((boolean)this.manager.deleteRole("not a role"));
        Assert.assertTrue((boolean)this.manager.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertNull((Object)this.manager.getRole(roles[roles.length - 1].getName()));
        Assert.assertFalse((boolean)this.manager.deleteRole(roles[roles.length - 1].getName()));
        role = this.manager.getRole(roles[0].getName());
        PartialPath path = new PartialPath("root.a.b.c");
        int privilegeId = 0;
        Assert.assertFalse((boolean)role.hasPrivilegeToRevoke(path, privilegeId));
        this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId, false);
        this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId + 1, false);
        this.manager.grantPrivilegeToRole(role.getName(), path, privilegeId, false);
        role = this.manager.getRole(roles[0].getName());
        Assert.assertTrue((boolean)role.hasPrivilegeToRevoke(path, privilegeId));
        this.manager.grantPrivilegeToRole(role.getName(), null, PrivilegeType.MAINTAIN.ordinal(), true);
        this.manager.grantPrivilegeToRole(role.getName(), null, PrivilegeType.MAINTAIN.ordinal(), true);
        caught = false;
        try {
            this.manager.grantPrivilegeToRole("not a role", path, privilegeId, false);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        role = this.manager.getRole(roles[0].getName());
        Assert.assertTrue((boolean)this.manager.revokePrivilegeFromRole(role.getName(), path, privilegeId));
        Assert.assertFalse((boolean)this.manager.revokePrivilegeFromRole(role.getName(), path, privilegeId));
        Assert.assertFalse((boolean)this.manager.revokePrivilegeFromRole(role.getName(), null, PrivilegeType.USE_PIPE.ordinal()));
        Assert.assertTrue((boolean)this.manager.revokePrivilegeFromRole(role.getName(), null, PrivilegeType.MAINTAIN.ordinal()));
        Assert.assertEquals((long)this.manager.getRole(role.getName()).getSysPriGrantOpt().size(), (long)0L);
        caught = false;
        try {
            this.manager.revokePrivilegeFromRole("not a role", path, privilegeId);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        List rolenames = this.manager.listAllRoles();
        rolenames.sort(null);
        for (int i = 0; i < roles.length - 1; ++i) {
            Assert.assertEquals((Object)roles[i].getName(), rolenames.get(i));
        }
    }

    @Test
    public void testPathCheckForUpgrade() throws AuthException, IllegalPathException {
        this.manager.createRole("test");
        this.manager.setPreVersion(true);
        for (PriPrivilegeType item : PriPrivilegeType.values()) {
            if (item == PriPrivilegeType.ALL || !item.isAccept()) continue;
            if (item.isPrePathRelevant()) {
                this.manager.grantPrivilegeToRole("test", new PartialPath("root.d.a"), item.ordinal(), false);
                this.manager.grantPrivilegeToRole("test", new PartialPath("root.ds.a.b*"), item.ordinal(), false);
                this.manager.grantPrivilegeToRole("test", new PartialPath("root.ds.a.c*"), item.ordinal(), false);
                continue;
            }
            this.manager.grantPrivilegeToRole("test", new PartialPath("root.**"), item.ordinal(), false);
        }
        io.jsonwebtoken.lang.Assert.isTrue((this.manager.getRole("test").getPathPrivilegeList().size() == 4 ? 1 : 0) != 0);
        io.jsonwebtoken.lang.Assert.isTrue((!this.manager.getRole("test").getServiceReady() ? 1 : 0) != 0);
        this.manager.checkAndRefreshPathPri();
        Assert.assertEquals((long)3L, (long)this.manager.getRole("test").getPathPrivileges(new PartialPath("root.d.a")).size());
        Assert.assertEquals((long)3L, (long)this.manager.getRole("test").getPathPrivileges(new PartialPath("root.ds.a.**")).size());
        Assert.assertEquals((long)0L, (long)this.manager.getRole("test").getPathPrivileges(new PartialPath("root.**")).size());
        Assert.assertEquals((long)(PrivilegeType.getSysPriCount() - 3), (long)this.manager.getRole("test").getSysPrivilege().size());
        this.manager.getRole("test").getPathPrivilegeList().clear();
        this.manager.getRole("test").getSysPrivilege().clear();
    }

    @Test
    public void testPrivRefreshSingle() throws AuthException, IllegalPathException {
        this.manager.createRole("test");
        this.manager.setPreVersion(true);
        for (PriPrivilegeType item : PriPrivilegeType.values()) {
            if (item == PriPrivilegeType.ALL) continue;
            if (item.isAccept()) {
                if (item.isPrePathRelevant()) {
                    this.manager.grantPrivilegeToRole("test", new PartialPath("root.d.a"), item.ordinal(), false);
                    this.manager.grantPrivilegeToRole("test", new PartialPath("root.ds.a.b*"), item.ordinal(), false);
                } else {
                    this.manager.grantPrivilegeToRole("test", new PartialPath("root.**"), item.ordinal(), false);
                }
            }
            this.manager.checkAndRefreshPathPri();
            PartialPath path1 = AuthUtils.convertPatternPath((PartialPath)new PartialPath("root.ds.a.b*"));
            PartialPath path2 = new PartialPath("root.d.a");
            for (PrivilegeType pri : item.getSubPri()) {
                if (pri.isPathRelevant()) {
                    io.jsonwebtoken.lang.Assert.isTrue((boolean)this.manager.getRole("test").checkPathPrivilege(path1, pri.ordinal()));
                    io.jsonwebtoken.lang.Assert.isTrue((boolean)this.manager.getRole("test").checkPathPrivilege(path2, pri.ordinal()));
                    this.manager.getRole("test").removePathPrivilege(path1, pri.ordinal());
                    this.manager.getRole("test").removePathPrivilege(path2, pri.ordinal());
                    continue;
                }
                io.jsonwebtoken.lang.Assert.isTrue((boolean)this.manager.getRole("test").checkSysPrivilege(pri.ordinal()));
                this.manager.getRole("test").removeSysPrivilege(pri.ordinal());
            }
            io.jsonwebtoken.lang.Assert.isTrue((boolean)this.manager.getRole("test").getPathPrivilegeList().isEmpty());
            io.jsonwebtoken.lang.Assert.isTrue((boolean)this.manager.getRole("test").getSysPrivilege().isEmpty());
        }
    }
}

